/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.OpCode;
import java.util.Arrays;

public class Instruction {
    public static final long[] EMPTY_OPERANDS = new long[0];
    private final int address;
    private final OpCode opcode;
    private final long[] operands;

    public Instruction(int address, OpCode opcode, long[] operands) {
        this.address = address;
        this.opcode = opcode;
        this.operands = operands.length == 0 ? EMPTY_OPERANDS : (long[])operands.clone();
    }

    public int address() {
        return this.address;
    }

    public OpCode opcode() {
        return this.opcode;
    }

    public long[] operands() {
        return (long[])this.operands.clone();
    }

    public int operandCount() {
        return this.operands.length;
    }

    public long operand(int index) {
        return this.operands[index];
    }

    public String toString() {
        String result = String.format("0x%08X", this.address) + ": ";
        if (this.operands.length > 0) {
            return result + this.opcode + " " + Arrays.toString(this.operands);
        }
        return result + this.opcode.toString();
    }
}

