/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.WasmEncoding;
import java.util.List;

public enum OpCode {
    UNREACHABLE(0),
    NOP(1),
    BLOCK(2, List.of(WasmEncoding.VARUINT)),
    LOOP(3, List.of(WasmEncoding.VARUINT)),
    IF(4, List.of(WasmEncoding.VARUINT)),
    ELSE(5),
    END(11),
    BR(12, List.of(WasmEncoding.VARUINT)),
    BR_IF(13, List.of(WasmEncoding.VARUINT)),
    BR_TABLE(14, List.of(WasmEncoding.VEC_VARUINT, WasmEncoding.VARUINT)),
    RETURN(15),
    CALL(16, List.of(WasmEncoding.VARUINT)),
    CALL_INDIRECT(17, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    RETURN_CALL(18, List.of(WasmEncoding.VARUINT)),
    RETURN_CALL_INDIRECT(19, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    CALL_REF(20, List.of(WasmEncoding.VARUINT)),
    DROP(26),
    SELECT(27),
    SELECT_T(28, List.of(WasmEncoding.VEC_VARUINT)),
    LOCAL_GET(32, List.of(WasmEncoding.VARUINT)),
    LOCAL_SET(33, List.of(WasmEncoding.VARUINT)),
    LOCAL_TEE(34, List.of(WasmEncoding.VARUINT)),
    GLOBAL_GET(35, List.of(WasmEncoding.VARUINT)),
    GLOBAL_SET(36, List.of(WasmEncoding.VARUINT)),
    TABLE_GET(37, List.of(WasmEncoding.VARUINT)),
    TABLE_SET(38, List.of(WasmEncoding.VARUINT)),
    I32_LOAD(40, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_LOAD(41, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    F32_LOAD(42, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    F64_LOAD(43, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I32_LOAD8_S(44, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I32_LOAD8_U(45, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I32_LOAD16_S(46, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I32_LOAD16_U(47, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_LOAD8_S(48, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_LOAD8_U(49, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_LOAD16_S(50, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_LOAD16_U(51, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_LOAD32_S(52, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_LOAD32_U(53, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I32_STORE(54, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_STORE(55, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    F32_STORE(56, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    F64_STORE(57, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I32_STORE8(58, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I32_STORE16(59, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_STORE8(60, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_STORE16(61, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I64_STORE32(62, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    MEMORY_SIZE(63),
    MEMORY_GROW(64),
    I32_CONST(65, List.of(WasmEncoding.VARSINT32)),
    I64_CONST(66, List.of(WasmEncoding.VARSINT64)),
    F32_CONST(67, List.of(WasmEncoding.FLOAT32)),
    F64_CONST(68, List.of(WasmEncoding.FLOAT64)),
    I32_EQZ(69),
    I32_EQ(70),
    I32_NE(71),
    I32_LT_S(72),
    I32_LT_U(73),
    I32_GT_S(74),
    I32_GT_U(75),
    I32_LE_S(76),
    I32_LE_U(77),
    I32_GE_S(78),
    I32_GE_U(79),
    I64_EQZ(80),
    I64_EQ(81),
    I64_NE(82),
    I64_LT_S(83),
    I64_LT_U(84),
    I64_GT_S(85),
    I64_GT_U(86),
    I64_LE_S(87),
    I64_LE_U(88),
    I64_GE_S(89),
    I64_GE_U(90),
    F32_EQ(91),
    F32_NE(92),
    F32_LT(93),
    F32_GT(94),
    F32_LE(95),
    F32_GE(96),
    F64_EQ(97),
    F64_NE(98),
    F64_LT(99),
    F64_GT(100),
    F64_LE(101),
    F64_GE(102),
    I32_CLZ(103),
    I32_CTZ(104),
    I32_POPCNT(105),
    I32_ADD(106),
    I32_SUB(107),
    I32_MUL(108),
    I32_DIV_S(109),
    I32_DIV_U(110),
    I32_REM_S(111),
    I32_REM_U(112),
    I32_AND(113),
    I32_OR(114),
    I32_XOR(115),
    I32_SHL(116),
    I32_SHR_S(117),
    I32_SHR_U(118),
    I32_ROTL(119),
    I32_ROTR(120),
    I64_CLZ(121),
    I64_CTZ(122),
    I64_POPCNT(123),
    I64_ADD(124),
    I64_SUB(125),
    I64_MUL(126),
    I64_DIV_S(127),
    I64_DIV_U(128),
    I64_REM_S(129),
    I64_REM_U(130),
    I64_AND(131),
    I64_OR(132),
    I64_XOR(133),
    I64_SHL(134),
    I64_SHR_S(135),
    I64_SHR_U(136),
    I64_ROTL(137),
    I64_ROTR(138),
    F32_ABS(139),
    F32_NEG(140),
    F32_CEIL(141),
    F32_FLOOR(142),
    F32_TRUNC(143),
    F32_NEAREST(144),
    F32_SQRT(145),
    F32_ADD(146),
    F32_SUB(147),
    F32_MUL(148),
    F32_DIV(149),
    F32_MIN(150),
    F32_MAX(151),
    F32_COPYSIGN(152),
    F64_ABS(153),
    F64_NEG(154),
    F64_CEIL(155),
    F64_FLOOR(156),
    F64_TRUNC(157),
    F64_NEAREST(158),
    F64_SQRT(159),
    F64_ADD(160),
    F64_SUB(161),
    F64_MUL(162),
    F64_DIV(163),
    F64_MIN(164),
    F64_MAX(165),
    F64_COPYSIGN(166),
    I32_WRAP_I64(167),
    I32_TRUNC_F32_S(168),
    I32_TRUNC_F32_U(169),
    I32_TRUNC_F64_S(170),
    I32_TRUNC_F64_U(171),
    I64_EXTEND_I32_S(172),
    I64_EXTEND_I32_U(173),
    I64_TRUNC_F32_S(174),
    I64_TRUNC_F32_U(175),
    I64_TRUNC_F64_S(176),
    I64_TRUNC_F64_U(177),
    F32_CONVERT_I32_S(178),
    F32_CONVERT_I32_U(179),
    F32_CONVERT_I64_S(180),
    F32_CONVERT_I64_U(181),
    F32_DEMOTE_F64(182),
    F64_CONVERT_I32_S(183),
    F64_CONVERT_I32_U(184),
    F64_CONVERT_I64_S(185),
    F64_CONVERT_I64_U(186),
    F64_PROMOTE_F32(187),
    I32_REINTERPRET_F32(188),
    I64_REINTERPRET_F64(189),
    F32_REINTERPRET_I32(190),
    F64_REINTERPRET_I64(191),
    I32_EXTEND_8_S(192),
    I32_EXTEND_16_S(193),
    I64_EXTEND_8_S(194),
    I64_EXTEND_16_S(195),
    I64_EXTEND_32_S(196),
    REF_NULL(208, List.of(WasmEncoding.VARUINT)),
    REF_IS_NULL(209),
    REF_FUNC(210, List.of(WasmEncoding.VARUINT)),
    I32_TRUNC_SAT_F32_S(64512),
    I32_TRUNC_SAT_F32_U(64513),
    I32_TRUNC_SAT_F64_S(64514),
    I32_TRUNC_SAT_F64_U(64515),
    I64_TRUNC_SAT_F32_S(64516),
    I64_TRUNC_SAT_F32_U(64517),
    I64_TRUNC_SAT_F64_S(64518),
    I64_TRUNC_SAT_F64_U(64519),
    MEMORY_INIT(64520, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    DATA_DROP(64521, List.of(WasmEncoding.VARUINT)),
    MEMORY_COPY(64522, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    MEMORY_FILL(64523, List.of(WasmEncoding.VARUINT)),
    TABLE_INIT(64524, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    ELEM_DROP(64525, List.of(WasmEncoding.VARUINT)),
    TABLE_COPY(64526, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    TABLE_GROW(64527, List.of(WasmEncoding.VARUINT)),
    TABLE_SIZE(64528, List.of(WasmEncoding.VARUINT)),
    TABLE_FILL(64529, List.of(WasmEncoding.VARUINT)),
    V128_LOAD(64768, List.of(WasmEncoding.VARUINT, WasmEncoding.VARUINT)),
    I8x16_SWIZZLE(64782),
    V128_CONST(64780, List.of(WasmEncoding.VEC_VARUINT)),
    I8x16_EXTRACT_LANE_S(64789, List.of(WasmEncoding.VARUINT)),
    I8x16_EQ(64803),
    V128_NOT(64845),
    V128_BITSELECT(64850),
    I8x16_SHL(64875),
    I8x16_ADD(64878),
    I8x16_SUB(64881),
    F32x4_MUL(64998),
    F32x4_ABS(64992),
    F32x4_MIN(65000),
    I32x4_TRUNC_SAT_F32X4_S(65016),
    F32x4_CONVERT_I32x4_U(65019),
    I8x16_ALL_TRUE(64867);

    private static final int OP_CODES_SIZE = 65280;
    private final int opcode;

    private OpCode(int opcode) {
        this(opcode, List.of());
    }

    private OpCode(int opcode, List<WasmEncoding> signature) {
        this.opcode = opcode;
        OpCodes.byOpCode[opcode] = this;
        OpCodes.signatures[opcode] = signature;
    }

    public int opcode() {
        return this.opcode;
    }

    public static OpCode byOpCode(int opcode) {
        return OpCodes.byOpCode[opcode];
    }

    public static List<WasmEncoding> signature(OpCode opcode) {
        return OpCodes.signatures[opcode.opcode()];
    }

    private static final class OpCodes {
        private static final OpCode[] byOpCode = new OpCode[65280];
        private static final List<WasmEncoding>[] signatures = new List[65280];

        private OpCodes() {
        }
    }
}

