/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm;

import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.ControlTree;
import com.dylibso.chicory.wasm.Encoding;
import com.dylibso.chicory.wasm.InvalidException;
import com.dylibso.chicory.wasm.MalformedException;
import com.dylibso.chicory.wasm.ParserListener;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.ActiveElement;
import com.dylibso.chicory.wasm.types.AnnotatedInstruction;
import com.dylibso.chicory.wasm.types.CodeSection;
import com.dylibso.chicory.wasm.types.CustomSection;
import com.dylibso.chicory.wasm.types.DataCountSection;
import com.dylibso.chicory.wasm.types.DataSection;
import com.dylibso.chicory.wasm.types.DeclarativeElement;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.ElementSection;
import com.dylibso.chicory.wasm.types.Export;
import com.dylibso.chicory.wasm.types.ExportSection;
import com.dylibso.chicory.wasm.types.ExternalType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionImport;
import com.dylibso.chicory.wasm.types.FunctionSection;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.GlobalImport;
import com.dylibso.chicory.wasm.types.GlobalSection;
import com.dylibso.chicory.wasm.types.ImportSection;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.Memory;
import com.dylibso.chicory.wasm.types.MemoryImport;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.MemorySection;
import com.dylibso.chicory.wasm.types.MutabilityType;
import com.dylibso.chicory.wasm.types.NameCustomSection;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.PassiveDataSegment;
import com.dylibso.chicory.wasm.types.PassiveElement;
import com.dylibso.chicory.wasm.types.RawSection;
import com.dylibso.chicory.wasm.types.Section;
import com.dylibso.chicory.wasm.types.StartSection;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.TableImport;
import com.dylibso.chicory.wasm.types.TableLimits;
import com.dylibso.chicory.wasm.types.TableSection;
import com.dylibso.chicory.wasm.types.TypeSection;
import com.dylibso.chicory.wasm.types.UnknownCustomSection;
import com.dylibso.chicory.wasm.types.ValueType;
import com.dylibso.chicory.wasm.types.WasmEncoding;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Parser {
    static final byte[] MAGIC_BYTES = new byte[]{0, 97, 115, 109};
    static final byte[] VERSION_BYTES = new byte[]{1, 0, 0, 0};
    private final Map<String, Function<byte[], CustomSection>> customParsers;
    private final BitSet includeSections;
    private static final Map<String, Function<byte[], CustomSection>> DEFAULT_CUSTOM_PARSERS = Map.of("name", NameCustomSection::parse);

    private Parser() {
        this(null, DEFAULT_CUSTOM_PARSERS);
    }

    private Parser(BitSet includeSections, Map<String, Function<byte[], CustomSection>> customParsers) {
        this.includeSections = includeSections;
        this.customParsers = Map.copyOf(customParsers);
    }

    private static ByteBuffer readByteBuffer(InputStream is) {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(is.readAllBytes());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return buffer;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read wasm bytes.", e);
        }
    }

    private static void onSection(WasmModule.Builder module, Section s) {
        switch (s.sectionId()) {
            case 0: {
                CustomSection customSection = (CustomSection)s;
                module.addCustomSection(customSection.name(), customSection);
                break;
            }
            case 1: {
                module.setTypeSection((TypeSection)s);
                break;
            }
            case 2: {
                module.setImportSection((ImportSection)s);
                break;
            }
            case 3: {
                module.setFunctionSection((FunctionSection)s);
                break;
            }
            case 4: {
                module.setTableSection((TableSection)s);
                break;
            }
            case 5: {
                module.setMemorySection((MemorySection)s);
                break;
            }
            case 6: {
                module.setGlobalSection((GlobalSection)s);
                break;
            }
            case 7: {
                module.setExportSection((ExportSection)s);
                break;
            }
            case 8: {
                module.setStartSection((StartSection)s);
                break;
            }
            case 9: {
                module.setElementSection((ElementSection)s);
                break;
            }
            case 10: {
                module.setCodeSection((CodeSection)s);
                break;
            }
            case 11: {
                module.setDataSection((DataSection)s);
                break;
            }
            case 12: {
                module.setDataCountSection((DataCountSection)s);
                break;
            }
            default: {
                module.addIgnoredSection(s.sectionId());
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WasmModule parse(InputStream input) {
        return new Parser().parse(() -> input);
    }

    public static WasmModule parse(byte[] buffer) {
        return new Parser().parse(() -> new ByteArrayInputStream(buffer));
    }

    public static WasmModule parse(File file) {
        return Parser.parse(file.toPath());
    }

    public static WasmModule parse(Path path) {
        return new Parser().parse(() -> {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error opening file: " + String.valueOf(path), e);
            }
        });
    }

    public WasmModule parse(Supplier<InputStream> inputStreamSupplier) {
        WasmModule.Builder moduleBuilder = WasmModule.builder();
        try (InputStream is = inputStreamSupplier.get();){
            this.parse(is, s -> Parser.onSection(moduleBuilder, s));
        }
        catch (IOException e) {
            throw new ChicoryException(e);
        }
        catch (MalformedException e) {
            throw new MalformedException("section size mismatch, unexpected end of section or function, " + e.getMessage(), e);
        }
        return moduleBuilder.build();
    }

    public void parse(InputStream in, ParserListener listener) {
        this.parse(in, listener, true);
    }

    private void parse(InputStream in, ParserListener listener, boolean decode) {
        Objects.requireNonNull(listener, "listener");
        SectionsValidator validator = new SectionsValidator();
        ByteBuffer buffer = Parser.readByteBuffer(in);
        byte[] magic = new byte[4];
        Encoding.readBytes(buffer, magic);
        if (!Arrays.equals(magic, MAGIC_BYTES)) {
            throw new MalformedException("magic header not detected, found: " + Arrays.toString(magic) + " expected: " + Arrays.toString(MAGIC_BYTES));
        }
        byte[] version = new byte[4];
        Encoding.readBytes(buffer, version);
        if (!Arrays.equals(version, VERSION_BYTES)) {
            throw new MalformedException("unknown binary version, found: " + Arrays.toString(version) + " expected: " + Arrays.toString(VERSION_BYTES));
        }
        boolean firstTime = true;
        block15: while (buffer.hasRemaining()) {
            byte sectionId = Encoding.readByte(buffer);
            long sectionSize = Encoding.readVarUInt32(buffer);
            validator.validateSectionType(sectionId);
            if (this.shouldParseSection(sectionId)) {
                if (!decode) {
                    listener.onSection(Parser.parseRawSection(buffer, sectionId, sectionSize));
                    continue;
                }
                switch (sectionId) {
                    case 0: {
                        CustomSection customSection = this.parseCustomSection(buffer, sectionSize, firstTime);
                        firstTime = false;
                        listener.onSection(customSection);
                        continue block15;
                    }
                    case 1: {
                        TypeSection typeSection = Parser.parseTypeSection(buffer);
                        listener.onSection(typeSection);
                        continue block15;
                    }
                    case 2: {
                        ImportSection importSection = Parser.parseImportSection(buffer);
                        listener.onSection(importSection);
                        continue block15;
                    }
                    case 3: {
                        FunctionSection funcSection = Parser.parseFunctionSection(buffer);
                        listener.onSection(funcSection);
                        continue block15;
                    }
                    case 4: {
                        TableSection tableSection = Parser.parseTableSection(buffer);
                        listener.onSection(tableSection);
                        continue block15;
                    }
                    case 5: {
                        MemorySection memorySection = Parser.parseMemorySection(buffer);
                        listener.onSection(memorySection);
                        continue block15;
                    }
                    case 6: {
                        GlobalSection globalSection = Parser.parseGlobalSection(buffer);
                        listener.onSection(globalSection);
                        continue block15;
                    }
                    case 7: {
                        ExportSection exportSection = Parser.parseExportSection(buffer);
                        listener.onSection(exportSection);
                        continue block15;
                    }
                    case 8: {
                        StartSection startSection = Parser.parseStartSection(buffer);
                        listener.onSection(startSection);
                        continue block15;
                    }
                    case 9: {
                        ElementSection elementSection = Parser.parseElementSection(buffer, sectionSize);
                        listener.onSection(elementSection);
                        continue block15;
                    }
                    case 10: {
                        CodeSection codeSection = Parser.parseCodeSection(buffer);
                        listener.onSection(codeSection);
                        continue block15;
                    }
                    case 11: {
                        DataSection dataSection = Parser.parseDataSection(buffer);
                        listener.onSection(dataSection);
                        continue block15;
                    }
                    case 12: {
                        DataCountSection dataCountSection = Parser.parseDataCountSection(buffer);
                        listener.onSection(dataCountSection);
                        continue block15;
                    }
                }
                throw new MalformedException("section size mismatch, malformed section id " + sectionId);
            }
            buffer.position((int)((long)buffer.position() + sectionSize));
        }
    }

    public static void parseWithoutDecoding(byte[] bytes, ParserListener listener) {
        new Parser().parseWithoutDecoding(new ByteArrayInputStream(bytes), listener);
    }

    public void parseWithoutDecoding(InputStream in, ParserListener listener) {
        this.parse(in, listener, false);
    }

    private boolean shouldParseSection(int sectionId) {
        return this.includeSections == null || this.includeSections.get(sectionId);
    }

    private CustomSection parseCustomSection(ByteBuffer buffer, long sectionSize, boolean checkMalformed) {
        int sectionPos = buffer.position();
        String name = Encoding.readName(buffer, checkMalformed);
        long size = sectionSize - (long)(buffer.position() - sectionPos);
        if (size < 0L) {
            throw new MalformedException("unexpected end");
        }
        byte[] bytes = new byte[(int)size];
        Encoding.readBytes(buffer, bytes);
        Function<byte[], CustomSection> parser = this.customParsers.get(name);
        return parser == null ? UnknownCustomSection.builder().withName(name).withBytes(bytes).build() : parser.apply(bytes);
    }

    private static RawSection parseRawSection(ByteBuffer buffer, byte sectionId, long sectionSize) {
        byte[] bytes = new byte[Math.toIntExact(sectionSize)];
        Encoding.readBytes(buffer, bytes);
        return new RawSection(sectionId, bytes);
    }

    private static TypeSection parseTypeSection(ByteBuffer buffer) {
        long typeCount = Encoding.readVarUInt32(buffer);
        TypeSection.Builder typeSection = TypeSection.builder();
        int i = 0;
        while ((long)i < typeCount) {
            long form = Encoding.readVarUInt32(buffer);
            if (form > 127L) {
                throw new MalformedException("integer representation too long");
            }
            if (form != 96L) {
                throw new MalformedException("We don't support non func types. Form " + String.format("0x%02X", form) + " was given but we expected 0x60");
            }
            int paramCount = (int)Encoding.readVarUInt32(buffer);
            ValueType[] params = new ValueType[paramCount];
            for (int j = 0; j < paramCount; ++j) {
                params[j] = ValueType.forId((int)Encoding.readVarUInt32(buffer));
            }
            int returnCount = (int)Encoding.readVarUInt32(buffer);
            ValueType[] returns = new ValueType[returnCount];
            for (int j = 0; j < returnCount; ++j) {
                returns[j] = ValueType.forId((int)Encoding.readVarUInt32(buffer));
            }
            typeSection.addFunctionType(FunctionType.of(params, returns));
            ++i;
        }
        return typeSection.build();
    }

    private static ImportSection parseImportSection(ByteBuffer buffer) {
        long importCount = Encoding.readVarUInt32(buffer);
        ImportSection.Builder importSection = ImportSection.builder();
        int i = 0;
        while ((long)i < importCount) {
            ExternalType descType;
            String moduleName = Encoding.readName(buffer);
            String importName = Encoding.readName(buffer);
            try {
                descType = ExternalType.byId((int)Encoding.readVarUInt32(buffer));
            }
            catch (RuntimeException e) {
                throw new MalformedException("malformed import kind", e);
            }
            switch (descType) {
                case FUNCTION: {
                    if (moduleName.isEmpty() && importName.isEmpty()) {
                        throw new MalformedException("malformed import kind");
                    }
                    importSection.addImport(new FunctionImport(moduleName, importName, (int)Encoding.readVarUInt32(buffer)));
                    break;
                }
                case TABLE: {
                    long rawTableType = Encoding.readVarUInt32(buffer);
                    assert (rawTableType == 112L || rawTableType == 111L);
                    ValueType tableType = rawTableType == 112L ? ValueType.FuncRef : ValueType.ExternRef;
                    byte limitType = Encoding.readByte(buffer);
                    assert (limitType == 0 || limitType == 1);
                    int min = (int)Encoding.readVarUInt32(buffer);
                    TableLimits limits = limitType > 0 ? new TableLimits(min, Encoding.readVarUInt32(buffer)) : new TableLimits(min);
                    importSection.addImport(new TableImport(moduleName, importName, tableType, limits));
                    break;
                }
                case MEMORY: {
                    byte limitType = Encoding.readByte(buffer);
                    assert (limitType == 0 || limitType == 1);
                    int min = (int)Math.min(65536L, Encoding.readVarUInt32(buffer));
                    MemoryLimits limits = limitType > 0 ? new MemoryLimits(min, (int)Math.min(65536L, Encoding.readVarUInt32(buffer))) : new MemoryLimits(min, 65536);
                    importSection.addImport(new MemoryImport(moduleName, importName, limits));
                    break;
                }
                case GLOBAL: {
                    ValueType globalValType = ValueType.forId((int)Encoding.readVarUInt32(buffer));
                    MutabilityType globalMut = MutabilityType.forId(Encoding.readByte(buffer));
                    importSection.addImport(new GlobalImport(moduleName, importName, globalMut, globalValType));
                    break;
                }
                default: {
                    throw new MalformedException("malformed import kind");
                }
            }
            ++i;
        }
        return importSection.build();
    }

    private static FunctionSection parseFunctionSection(ByteBuffer buffer) {
        long functionCount = Encoding.readVarUInt32(buffer);
        FunctionSection.Builder functionSection = FunctionSection.builder();
        int i = 0;
        while ((long)i < functionCount) {
            long typeIndex = Encoding.readVarUInt32(buffer);
            functionSection.addFunctionType((int)typeIndex);
            ++i;
        }
        return functionSection.build();
    }

    private static TableSection parseTableSection(ByteBuffer buffer) {
        long tableCount = Encoding.readVarUInt32(buffer);
        TableSection.Builder tableSection = TableSection.builder();
        int i = 0;
        while ((long)i < tableCount) {
            ValueType tableType = ValueType.refTypeForId((int)Encoding.readVarUInt32(buffer));
            byte limitType = Encoding.readByte(buffer);
            if (limitType != 0 && limitType != 1) {
                throw new MalformedException("integer representation too long, integer too large");
            }
            long min = Encoding.readVarUInt32(buffer);
            TableLimits limits = limitType > 0 ? new TableLimits(min, Encoding.readVarUInt32(buffer)) : new TableLimits(min);
            tableSection.addTable(new Table(tableType, limits));
            ++i;
        }
        return tableSection.build();
    }

    private static MemorySection parseMemorySection(ByteBuffer buffer) {
        long memoryCount = Encoding.readVarUInt32(buffer);
        MemorySection.Builder memorySection = MemorySection.builder();
        int i = 0;
        while ((long)i < memoryCount) {
            MemoryLimits limits = Parser.parseMemoryLimits(buffer);
            memorySection.addMemory(new Memory(limits));
            ++i;
        }
        return memorySection.build();
    }

    private static MemoryLimits parseMemoryLimits(ByteBuffer buffer) {
        byte limitType = Encoding.readByte(buffer);
        if (limitType != 0 && limitType != 1) {
            throw new MalformedException("integer representation too long, integer too large");
        }
        int initial = (int)Encoding.readVarUInt32(buffer);
        if (limitType != 1) {
            return new MemoryLimits(initial);
        }
        int maximum = (int)Encoding.readVarUInt32(buffer);
        return new MemoryLimits(initial, maximum);
    }

    private static GlobalSection parseGlobalSection(ByteBuffer buffer) {
        long globalCount = Encoding.readVarUInt32(buffer);
        GlobalSection.Builder globalSection = GlobalSection.builder();
        int i = 0;
        while ((long)i < globalCount) {
            ValueType valueType = ValueType.forId((int)Encoding.readVarUInt32(buffer));
            MutabilityType mutabilityType = MutabilityType.forId(Encoding.readByte(buffer));
            Instruction[] init = Parser.parseExpression(buffer);
            globalSection.addGlobal(new Global(valueType, mutabilityType, List.of(init)));
            ++i;
        }
        return globalSection.build();
    }

    private static ExportSection parseExportSection(ByteBuffer buffer) {
        long exportCount = Encoding.readVarUInt32(buffer);
        ExportSection.Builder exportSection = ExportSection.builder();
        int i = 0;
        while ((long)i < exportCount) {
            String name = Encoding.readName(buffer, false);
            ExternalType exportType = ExternalType.byId((int)Encoding.readVarUInt32(buffer));
            int index = (int)Encoding.readVarUInt32(buffer);
            exportSection.addExport(new Export(name, index, exportType));
            ++i;
        }
        return exportSection.build();
    }

    private static StartSection parseStartSection(ByteBuffer buffer) {
        return StartSection.builder().setStartIndex(Encoding.readVarUInt32(buffer)).build();
    }

    private static ElementSection parseElementSection(ByteBuffer buffer, long sectionSize) {
        int initialPosition = buffer.position();
        long elementCount = Encoding.readVarUInt32(buffer);
        ElementSection.Builder elementSection = ElementSection.builder();
        int i = 0;
        while ((long)i < elementCount) {
            elementSection.addElement(Parser.parseSingleElement(buffer));
            ++i;
        }
        if ((long)buffer.position() != (long)initialPosition + sectionSize) {
            throw new MalformedException("section size mismatch");
        }
        return elementSection.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Element parseSingleElement(ByteBuffer buffer) {
        ValueType type;
        int flags = (int)Encoding.readVarUInt32(buffer);
        boolean active = (flags & 1) == 0;
        boolean declarative = !active && (flags & 2) != 0;
        boolean passive = !active && !declarative;
        boolean hasTableIdx = active && (flags & 2) != 0;
        boolean alwaysFuncRef = active && !hasTableIdx;
        boolean exprInit = (flags & 4) != 0;
        boolean hasElemKind = !exprInit && !alwaysFuncRef;
        boolean hasRefType = exprInit && !alwaysFuncRef;
        int tableIdx = 0;
        List<Instruction> offset = List.of();
        if (active) {
            if (hasTableIdx) {
                tableIdx = Math.toIntExact(Encoding.readVarUInt32(buffer));
            }
            offset = List.of(Parser.parseExpression(buffer));
        }
        if (alwaysFuncRef) {
            type = ValueType.FuncRef;
        } else if (hasElemKind) {
            int ek = (int)Encoding.readVarUInt32(buffer);
            if (ek != 0) throw new ChicoryException("Invalid element kind");
            type = ValueType.FuncRef;
        } else {
            assert (hasRefType);
            type = ValueType.refTypeForId(Math.toIntExact(Encoding.readVarUInt32(buffer)));
        }
        int initCnt = Math.toIntExact(Encoding.readVarUInt32(buffer));
        ArrayList<List<Instruction>> inits = new ArrayList<List<Instruction>>(initCnt);
        if (exprInit) {
            for (int i = 0; i < initCnt; ++i) {
                inits.add(List.of(Parser.parseExpression(buffer)));
            }
        } else {
            for (int i = 0; i < initCnt; ++i) {
                inits.add(List.of(new Instruction(-1, OpCode.REF_FUNC, new long[]{Encoding.readVarUInt32(buffer)}), new Instruction(-1, OpCode.END, Instruction.EMPTY_OPERANDS)));
            }
        }
        if (declarative) {
            return new DeclarativeElement(type, inits);
        }
        if (passive) {
            return new PassiveElement(type, inits);
        }
        assert (active);
        return new ActiveElement(type, inits, tableIdx, offset);
    }

    private static List<ValueType> parseCodeSectionLocalTypes(ByteBuffer buffer) {
        long distinctTypesCount = Encoding.readVarUInt32(buffer);
        ArrayList<ValueType> locals = new ArrayList<ValueType>();
        int i = 0;
        while ((long)i < distinctTypesCount) {
            long numberOfLocals = Encoding.readVarUInt32(buffer);
            if (numberOfLocals > 50000L) {
                throw new MalformedException("too many locals");
            }
            ValueType type = ValueType.forId((int)Encoding.readVarUInt32(buffer));
            int j = 0;
            while ((long)j < numberOfLocals) {
                locals.add(type);
                ++j;
            }
            ++i;
        }
        return locals;
    }

    private static CodeSection parseCodeSection(ByteBuffer buffer) {
        long funcBodyCount = Encoding.readVarUInt32(buffer);
        ControlTree root = new ControlTree();
        CodeSection.Builder codeSection = CodeSection.builder();
        int i = 0;
        while ((long)i < funcBodyCount) {
            ArrayDeque<Instruction> blockScope = new ArrayDeque<Instruction>();
            int depth = 0;
            long funcEndPoint = Encoding.readVarUInt32(buffer) + (long)buffer.position();
            List<ValueType> locals = Parser.parseCodeSectionLocalTypes(buffer);
            ArrayList<AnnotatedInstruction.Builder> instructions = new ArrayList<AnnotatedInstruction.Builder>();
            boolean lastInstruction = false;
            ControlTree currentControlFlow = null;
            do {
                Instruction baseInstruction = Parser.parseInstruction(buffer);
                AnnotatedInstruction.Builder instruction = AnnotatedInstruction.builder().from(baseInstruction);
                boolean bl = lastInstruction = (long)buffer.position() >= funcEndPoint;
                if (instructions.isEmpty()) {
                    currentControlFlow = root.spawn(0, instruction);
                }
                switch (baseInstruction.opcode()) {
                    case MEMORY_INIT: 
                    case DATA_DROP: {
                        codeSection.setRequiresDataCount(true);
                    }
                }
                switch (baseInstruction.opcode()) {
                    case BLOCK: 
                    case LOOP: 
                    case IF: {
                        instruction.withDepth(++depth);
                        blockScope.push(baseInstruction);
                        instruction.withScope((Instruction)blockScope.peek());
                        break;
                    }
                    case END: {
                        instruction.withDepth(depth);
                        --depth;
                        instruction.withScope(blockScope.isEmpty() ? baseInstruction : (Instruction)blockScope.pop());
                        break;
                    }
                    default: {
                        instruction.withDepth(depth);
                    }
                }
                switch (baseInstruction.opcode()) {
                    case BLOCK: 
                    case LOOP: {
                        currentControlFlow = currentControlFlow.spawn(instructions.size(), instruction);
                        break;
                    }
                    case IF: {
                        currentControlFlow = currentControlFlow.spawn(instructions.size(), instruction);
                        int defaultJmp = instructions.size() + 1;
                        currentControlFlow.addCallback(end -> instruction.updateLabelFalse((int)end));
                        instruction.withLabelTrue(defaultJmp);
                        instruction.withLabelFalse(defaultJmp);
                        break;
                    }
                    case ELSE: {
                        currentControlFlow.instruction().withLabelFalse(instructions.size() + 1);
                        currentControlFlow.addCallback(instruction::withLabelTrue);
                        break;
                    }
                    case BR_IF: {
                        instruction.withLabelFalse(instructions.size() + 1);
                    }
                    case BR: {
                        ControlTree reference = currentControlFlow;
                        for (int offset = (int)baseInstruction.operand(0); offset > 0; --offset) {
                            if (reference == null) {
                                throw new InvalidException("unknown label");
                            }
                            reference = reference.parent();
                        }
                        reference.addCallback(instruction::withLabelTrue);
                        break;
                    }
                    case BR_TABLE: {
                        int length = baseInstruction.operandCount();
                        ArrayList<Integer> labelTable = new ArrayList<Integer>();
                        int idx = 0;
                        while (idx < length) {
                            labelTable.add(null);
                            ControlTree reference = currentControlFlow;
                            for (int offset = (int)baseInstruction.operand(idx); offset > 0; --offset) {
                                if (reference == null) {
                                    throw new InvalidException("unknown label");
                                }
                                reference = reference.parent();
                            }
                            int finalIdx = idx++;
                            reference.addCallback(end -> labelTable.set(finalIdx, (Integer)end));
                        }
                        instruction.withLabelTable(labelTable);
                        break;
                    }
                    case END: {
                        AnnotatedInstruction.Builder former;
                        currentControlFlow.setFinalInstructionNumber(instructions.size(), instruction);
                        currentControlFlow = currentControlFlow.parent();
                        if (!lastInstruction || instructions.size() <= 1 || (former = (AnnotatedInstruction.Builder)instructions.get(instructions.size() - 1)).opcode() != OpCode.END) break;
                        instruction.withScope(former.scope().get());
                    }
                }
                if (lastInstruction && instruction.opcode() != OpCode.END) {
                    throw new MalformedException("END opcode expected, section size mismatch");
                }
                instructions.add(instruction);
            } while (!lastInstruction);
            FunctionBody functionBody = new FunctionBody(locals, instructions.stream().map(ins -> ins.build()).collect(Collectors.toUnmodifiableList()));
            codeSection.addFunctionBody(functionBody);
            ++i;
        }
        return codeSection.build();
    }

    private static DataSection parseDataSection(ByteBuffer buffer) {
        long dataSegmentCount = Encoding.readVarUInt32(buffer);
        DataSection.Builder dataSection = DataSection.builder();
        int i = 0;
        while ((long)i < dataSegmentCount) {
            long mode = Encoding.readVarUInt32(buffer);
            if (mode == 0L) {
                Instruction[] offset = Parser.parseExpression(buffer);
                byte[] data = new byte[(int)Encoding.readVarUInt32(buffer)];
                Encoding.readBytes(buffer, data);
                dataSection.addDataSegment(new ActiveDataSegment(0L, List.of(offset), data));
            } else if (mode == 1L) {
                byte[] data = new byte[(int)Encoding.readVarUInt32(buffer)];
                Encoding.readBytes(buffer, data);
                dataSection.addDataSegment(new PassiveDataSegment(data));
            } else if (mode == 2L) {
                long memoryId = Encoding.readVarUInt32(buffer);
                Instruction[] offset = Parser.parseExpression(buffer);
                byte[] data = new byte[(int)Encoding.readVarUInt32(buffer)];
                Encoding.readBytes(buffer, data);
                dataSection.addDataSegment(new ActiveDataSegment(memoryId, List.of(offset), data));
            } else {
                throw new ChicoryException("Failed to parse data segment with data mode: " + mode);
            }
            ++i;
        }
        return dataSection.build();
    }

    private static DataCountSection parseDataCountSection(ByteBuffer buffer) {
        long dataCount = Encoding.readVarUInt32(buffer);
        return DataCountSection.builder().withDataCount((int)dataCount).build();
    }

    private static Instruction parseInstruction(ByteBuffer buffer) {
        OpCode op;
        int address = buffer.position();
        int b = Encoding.readByte(buffer) & 0xFF;
        if (b >= 252 && b < 255) {
            b = (int)((long)(b << 8) + Encoding.readVarUInt32(buffer));
        }
        if ((op = OpCode.byOpCode(b)) == null) {
            throw new MalformedException("illegal opcode, op value " + String.format("%02X ", b));
        }
        List<WasmEncoding> signature = OpCode.signature(op);
        switch (op) {
            case MEMORY_GROW: 
            case MEMORY_SIZE: {
                byte zero = Encoding.readByte(buffer);
                if (zero == 0) break;
                throw new MalformedException("zero byte expected");
            }
        }
        if (signature.isEmpty()) {
            return new Instruction(address, op, Instruction.EMPTY_OPERANDS);
        }
        ArrayList<Long> operands = new ArrayList<Long>();
        block11: for (WasmEncoding sig : signature) {
            switch (sig) {
                case VARUINT: {
                    operands.add(Encoding.readVarUInt32(buffer));
                    break;
                }
                case VARSINT32: {
                    operands.add(Encoding.readVarSInt32(buffer));
                    break;
                }
                case VARSINT64: {
                    operands.add(Encoding.readVarSInt64(buffer));
                    break;
                }
                case FLOAT64: {
                    operands.add(Encoding.readFloat64(buffer));
                    break;
                }
                case FLOAT32: {
                    operands.add(Encoding.readFloat32(buffer));
                    break;
                }
                case VEC_VARUINT: {
                    int vcount = (int)Encoding.readVarUInt32(buffer);
                    for (int j = 0; j < vcount; ++j) {
                        operands.add(Encoding.readVarUInt32(buffer));
                    }
                    continue block11;
                }
            }
        }
        long[] operandsArray = new long[operands.size()];
        for (int i = 0; i < operands.size(); ++i) {
            operandsArray[i] = (Long)operands.get(i);
        }
        Parser.verifyAlignment(op, operandsArray);
        return new Instruction(address, op, operandsArray);
    }

    private static void verifyAlignment(OpCode op, long[] operands) {
        int align = -1;
        switch (op) {
            case I32_LOAD8_U: 
            case I32_LOAD8_S: 
            case I64_LOAD8_U: 
            case I64_LOAD8_S: 
            case I32_STORE8: 
            case I64_STORE8: {
                align = 8;
                break;
            }
            case I32_LOAD16_U: 
            case I32_LOAD16_S: 
            case I64_LOAD16_U: 
            case I64_LOAD16_S: 
            case I32_STORE16: 
            case I64_STORE16: {
                align = 16;
                break;
            }
            case I32_LOAD: 
            case F32_LOAD: 
            case I64_LOAD32_U: 
            case I64_LOAD32_S: 
            case I64_STORE32: 
            case I32_STORE: 
            case F32_STORE: {
                align = 32;
                break;
            }
            case I64_LOAD: 
            case F64_LOAD: 
            case I64_STORE: 
            case F64_STORE: {
                align = 64;
            }
        }
        if (align > 0 && 1 << (int)operands[0] > align >> 3) {
            throw new InvalidException("alignment must not be larger than natural alignment (" + operands[0] + ")");
        }
    }

    private static Instruction[] parseExpression(ByteBuffer buffer) {
        Instruction i;
        ArrayList<Instruction> expr = new ArrayList<Instruction>();
        while ((i = Parser.parseInstruction(buffer)).opcode() != OpCode.END) {
            expr.add(i);
        }
        return expr.toArray(new Instruction[0]);
    }

    public static final class Builder {
        private Map<String, Function<byte[], CustomSection>> customParsers;
        private BitSet includeSections;

        private Builder() {
        }

        public Builder includeSectionId(int sectionId) {
            if (this.includeSections == null) {
                this.includeSections = new BitSet();
            }
            this.includeSections.set(sectionId);
            return this;
        }

        public Builder withCustomParsers(Map<String, Function<byte[], CustomSection>> customParsers) {
            this.customParsers = customParsers;
            return this;
        }

        public Parser build() {
            if (this.customParsers == null) {
                this.customParsers = DEFAULT_CUSTOM_PARSERS;
            }
            return new Parser(this.includeSections, this.customParsers);
        }
    }

    private static class SectionsValidator {
        private boolean hasStart;

        SectionsValidator() {
        }

        public void validateSectionType(byte sectionId) {
            if (sectionId == 8) {
                if (this.hasStart) {
                    throw new MalformedException("unexpected content after last section");
                }
                this.hasStart = true;
            }
        }
    }
}

