/*
 * Decompiled with CFR 0.152.
 */
package com.dyn.client.v3.messaging.config;

import com.dyn.client.v3.messaging.DynMessagingApi;
import com.dyn.client.v3.messaging.handlers.DynMessagingErrorHandler;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.http.internal.JavaUrlHttpCommandExecutorService;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class DynMessagingHttpApiModule
extends HttpApiModule<DynMessagingApi> {
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(DynMessagingErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(DynMessagingErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(DynMessagingErrorHandler.class);
    }

    protected void configure() {
        super.configure();
        this.bind(JavaUrlHttpCommandExecutorService.class).to(SillyRabbit200sAreForSuccess.class);
    }

    @Singleton
    private static class SillyRabbit200sAreForSuccess
    extends JavaUrlHttpCommandExecutorService {
        @Inject
        private SillyRabbit200sAreForSuccess(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, @Named(value="jclouds.io-worker-threads") ListeningExecutorService ioExecutor, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, Function<URI, Proxy> proxyForURI) throws SecurityException, NoSuchFieldException {
            super(utils, contentMetadataCodec, ioExecutor, retryHandler, ioRetryHandler, errorHandler, wire, verifier, untrustedSSLContextProvider, proxyForURI);
        }

        protected synchronized HttpResponse invoke(HttpURLConnection connection) throws IOException, InterruptedException {
            HttpResponse response = super.invoke(connection);
            if (response.getStatusCode() == 200) {
                byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
                String message = data != null ? new String(data, "UTF-8") : null;
                System.out.println("message: " + message);
                if (message != null && !message.startsWith("{\"response\":{\"status\":200,\"message\":\"OK\",")) {
                    response = response.toBuilder().statusCode(400).build();
                }
            }
            return response;
        }
    }
}

