/*
 * Decompiled with CFR 0.152.
 */
package com.dyn.client.v3.messaging.features;

import com.dyn.client.common.AlwaysAddApiKey;
import com.dyn.client.common.AlwaysAddUserAgent;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AlwaysAddUserAgent.class, AlwaysAddApiKey.class})
public interface SendersApi {
    @Named(value="GetSendersList")
    @GET
    @Path(value="/senders")
    @SelectJson(value={"senders"})
    @Consumes(value={"application/json"})
    public List<Map<String, Object>> list(@QueryParam(value="startindex") int var1);

    @Named(value="GetSenderDetails")
    @GET
    @Path(value="/senders/details")
    @SelectJson(value={"data"})
    @Consumes(value={"application/json"})
    public Map<String, Object> getDetails(@FormParam(value="emailaddress") String var1);

    @Named(value="GetSenderStatus")
    @GET
    @Path(value="/senders/status")
    @SelectJson(value={"data"})
    @Consumes(value={"application/json"})
    public Map<String, Object> getStatus(@FormParam(value="emailaddress") String var1);

    @Named(value="CreateOrUpdateSender")
    @POST
    @Path(value="/senders")
    @SelectJson(value={"data"})
    @Produces(value={"application/x-www-form-urlencoded"})
    @Consumes(value={"application/json"})
    public List<Map<String, Object>> createOrUpdate(@FormParam(value="emailaddress") String var1, @FormParam(value="seeding") String var2);

    @Named(value="DeleteSender")
    @POST
    @Path(value="/senders/delete")
    @SelectJson(value={"data"})
    @Produces(value={"application/x-www-form-urlencoded"})
    @Consumes(value={"application/json"})
    public List<Map<String, Object>> delete(@FormParam(value="emailaddress") String var1);

    @Named(value="SetSenderDKIM")
    @POST
    @Path(value="/senders/dkim")
    @SelectJson(value={"data"})
    @Produces(value={"application/x-www-form-urlencoded"})
    @Consumes(value={"application/json"})
    public Map<String, Object> setDkim(@FormParam(value="emailaddress") String var1, @FormParam(value="dkim") String var2);
}

