/*
 * Decompiled with CFR 0.152.
 */
package com.dyn.client.v3.traffic.binders;

import com.dyn.client.v3.traffic.domain.redirect.HttpRedirect;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.json.Json;
import org.jclouds.rest.Binder;

public class HttpRedirectBinder
implements Binder {
    private final Json json;

    @Inject
    HttpRedirectBinder(Json json) {
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object arg) {
        HttpRedirect in = (HttpRedirect)((Object)HttpRedirect.class.cast(Preconditions.checkNotNull((Object)arg, (Object)"redirect to create")));
        URI path = Uris.uriBuilder((URI)request.getEndpoint()).build(in.getDelegate());
        return (R)((HttpRequest.Builder)request.toBuilder().endpoint(path).payload(this.json.toJson((Object)ImmutableMap.of((Object)"code", (Object)in.getCode(), (Object)"keep_uri", (Object)in.getKeepUri(), (Object)"url", (Object)in.getUrl())))).build();
    }
}

