/*
 * Decompiled with CFR 0.152.
 */
package com.dyn.client.v3.traffic.domain;

import com.dyn.client.v3.traffic.domain.Zone;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.inject.Named;

public final class CreatePrimaryZone {
    private final transient String fqdn;
    @Named(value="rname")
    private final String contact;
    @Named(value="serial_style")
    private final Zone.SerialStyle serialStyle;
    @Named(value="ttl")
    private final int defaultTTL;

    private CreatePrimaryZone(String fqdn, String contact, Zone.SerialStyle serialStyle, int defaultTTL) {
        this.fqdn = (String)Preconditions.checkNotNull((Object)fqdn, (Object)"fqdn");
        this.contact = (String)Preconditions.checkNotNull((Object)contact, (String)"contact for %s", (Object[])new Object[]{fqdn});
        this.defaultTTL = (Integer)Preconditions.checkNotNull((Object)defaultTTL, (String)"defaultTTL for %s", (Object[])new Object[]{fqdn});
        this.serialStyle = (Zone.SerialStyle)((Object)Preconditions.checkNotNull((Object)((Object)serialStyle), (String)"serialStyle for %s", (Object[])new Object[]{serialStyle}));
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public String getContact() {
        return this.contact;
    }

    public int getDefaultTTL() {
        return this.defaultTTL;
    }

    public Zone.SerialStyle getSerialStyle() {
        return this.serialStyle;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fqdn, this.contact});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreatePrimaryZone that = (CreatePrimaryZone)CreatePrimaryZone.class.cast(obj);
        return Objects.equal((Object)this.fqdn, (Object)that.fqdn) && Objects.equal((Object)this.contact, (Object)that.contact);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("fqdn", (Object)this.fqdn).add("contact", (Object)this.contact).add("defaultTTL", this.defaultTTL).add("serialStyle", (Object)this.serialStyle).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return CreatePrimaryZone.builder().from(this);
    }

    public static final class ToFQDN
    implements Function<Object, String> {
        public String apply(Object in) {
            return ((CreatePrimaryZone)CreatePrimaryZone.class.cast(in)).getFQDN();
        }
    }

    public static final class Builder {
        private String fqdn;
        private String contact;
        private int defaultTTL = 3600;
        private Zone.SerialStyle serialStyle = Zone.SerialStyle.INCREMENT;

        public Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public Builder contact(String contact) {
            this.contact = contact;
            return this;
        }

        public Builder defaultTTL(int defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        public Builder serialStyle(Zone.SerialStyle serialStyle) {
            this.serialStyle = serialStyle;
            return this;
        }

        public CreatePrimaryZone build() {
            return new CreatePrimaryZone(this.fqdn, this.contact, this.serialStyle, this.defaultTTL);
        }

        public Builder from(CreatePrimaryZone in) {
            return this.fqdn(in.fqdn).contact(in.contact).serialStyle(in.serialStyle).defaultTTL(in.defaultTTL);
        }
    }
}

