/*
 * Decompiled with CFR 0.152.
 */
package com.dyn.client.v3.traffic.domain;

import com.dyn.client.v3.traffic.domain.Record;
import com.dyn.client.v3.traffic.domain.RecordId;
import com.dyn.client.v3.traffic.domain.Zone;
import com.dyn.client.v3.traffic.domain.rdata.SOAData;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;

public final class SOARecord
extends Record<SOAData> {
    @Named(value="serial_style")
    private final Zone.SerialStyle serialStyle;

    @ConstructorProperties(value={"zone", "fqdn", "record_type", "record_id", "ttl", "rdata", "serial_style"})
    private SOARecord(String zone, String fqdn, String type, long id, int ttl, SOAData rdata, Zone.SerialStyle serialStyle) {
        super(zone, fqdn, type, id, ttl, rdata);
        this.serialStyle = (Zone.SerialStyle)((Object)Preconditions.checkNotNull((Object)((Object)serialStyle), (String)"serialStyle of %s", (Object[])new Object[]{id}));
    }

    public Zone.SerialStyle getSerialStyle() {
        return this.serialStyle;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("serialStyle", (Object)this.serialStyle);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return SOARecord.builder().from(this);
    }

    public static final class Builder
    extends Record.Builder<SOAData, Builder> {
        private Zone.SerialStyle serialStyle;

        public Builder serialStyle(Zone.SerialStyle serialStyle) {
            this.serialStyle = serialStyle;
            return this;
        }

        @Override
        public SOARecord build() {
            return new SOARecord(this.zone, this.fqdn, this.type, this.id, this.ttl, (SOAData)((Object)this.rdata), this.serialStyle);
        }

        @Override
        public Builder from(RecordId in) {
            if (in instanceof SOARecord) {
                SOARecord record = (SOARecord)SOARecord.class.cast(in);
                this.serialStyle(record.serialStyle);
            }
            return (Builder)super.from(in);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

