/*
 * Decompiled with CFR 0.152.
 */
package com.dyn.client.v3.traffic.domain.redirect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;

public class HttpRedirect
extends ForwardingMap<String, Object> {
    private final String url;
    private final int code;
    private final String keepUri;
    private final String fqdn;
    private final String zone;
    private final transient ImmutableMap<String, Object> delegate;

    @ConstructorProperties(value={"url", "code", "keep_uri", "fqdn", "zone"})
    private HttpRedirect(String url, int code, String keepUri, String fqdn, String zone) {
        this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
        Preconditions.checkArgument((code == 301 || code == 302 ? 1 : 0) != 0, (String)"code of %s must be 301 or 302", (Object[])new Object[]{code});
        Preconditions.checkArgument(("Y".equals(keepUri) || "N".equals(keepUri) ? 1 : 0) != 0, (String)"code of %s must be 'Y' or 'N'", (Object[])new Object[]{keepUri});
        this.code = code;
        this.keepUri = keepUri;
        this.fqdn = (String)Preconditions.checkNotNull((Object)fqdn, (Object)"fqdn");
        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"zone");
        this.delegate = ImmutableMap.builder().put((Object)"url", (Object)url).put((Object)"code", (Object)code).put((Object)"keep_uri", (Object)keepUri).put((Object)"fqdn", (Object)fqdn).put((Object)"zone", (Object)zone).build();
    }

    public String getUrl() {
        return this.url;
    }

    public int getCode() {
        return this.code;
    }

    public String getKeepUri() {
        return this.keepUri;
    }

    public String getFqdn() {
        return this.fqdn;
    }

    public String getZone() {
        return this.zone;
    }

    public ImmutableMap<String, Object> getDelegate() {
        return this.delegate;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Map<String, Object> delegate() {
        return this.delegate;
    }

    public static final class Builder {
        private String url;
        private int code;
        private boolean keepUri;
        private String fqdn;
        private String zone;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder code(int code) {
            this.code = code;
            return this;
        }

        public Builder keepUri(boolean keepUri) {
            this.keepUri = keepUri;
            return this;
        }

        public Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public Builder zone(String zone) {
            this.zone = zone;
            return this;
        }

        public HttpRedirect build() {
            return new HttpRedirect(this.url, this.code, this.keepUri ? "Y" : "N", this.fqdn, this.zone);
        }
    }
}

