/*
 * Decompiled with CFR 0.152.
 */
package com.dyn.client.v3.traffic.features;

import com.dyn.client.common.AlwaysAddContentType;
import com.dyn.client.common.AlwaysAddUserAgent;
import com.dyn.client.v3.traffic.DynTrafficExceptions;
import com.dyn.client.v3.traffic.binders.CreateHttpRedirectBinder;
import com.dyn.client.v3.traffic.domain.Job;
import com.dyn.client.v3.traffic.domain.redirect.HttpRedirect;
import com.dyn.client.v3.traffic.filters.SessionManager;
import com.dyn.client.v3.traffic.functions.ExtractLastPathComponent;
import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Headers(keys={"API-Version"}, values={"{jclouds.api-version}"})
@RequestFilters(value={AlwaysAddUserAgent.class, AlwaysAddContentType.class, SessionManager.class})
public interface HttpRedirectApi {
    @Named(value="GetAllHttpRedirects")
    @GET
    @Path(value="/HTTPRedirect/{zone}/")
    @SelectJson(value={"data"})
    @Transform(value=ExtractLastPathComponent.class)
    public FluentIterable<String> list() throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="CreateHttpRedirect")
    @POST
    @Path(value="/HTTPRedirect/{zone}/{fqdn}/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Job scheduleCreate(@BinderParam(value=CreateHttpRedirectBinder.class) HttpRedirect var1) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="UpdateHttpRedirect")
    @PUT
    @Path(value="/HTTPRedirect/{zone}/{fqdn}/")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Job scheduleUpdate(@BinderParam(value=CreateHttpRedirectBinder.class) HttpRedirect var1) throws DynTrafficExceptions.JobStillRunningException;

    @Nullable
    @Named(value="DeleteHttpRedirect")
    @DELETE
    @Path(value="/HTTPRedirect/{zone}/{fqdn}/")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Job scheduleDelete(@PathParam(value="fqdn") String var1) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetHttpRedirect")
    @GET
    @Path(value="/HTTPRedirect/{zone}/{fqdn}/")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public HttpRedirect getHttpRedirect(@PathParam(value="fqdn") String var1) throws DynTrafficExceptions.JobStillRunningException;
}

