/*
 * Decompiled with CFR 0.152.
 */
package com.dyn.client.v3.traffic.features;

import com.dyn.client.common.AlwaysAddContentType;
import com.dyn.client.common.AlwaysAddUserAgent;
import com.dyn.client.v3.traffic.DynTrafficExceptions;
import com.dyn.client.v3.traffic.binders.CreateRecordBinder;
import com.dyn.client.v3.traffic.binders.RecordIdBinder;
import com.dyn.client.v3.traffic.domain.CreateRecord;
import com.dyn.client.v3.traffic.domain.Job;
import com.dyn.client.v3.traffic.domain.Record;
import com.dyn.client.v3.traffic.domain.RecordId;
import com.dyn.client.v3.traffic.domain.SOARecord;
import com.dyn.client.v3.traffic.domain.rdata.AAAAData;
import com.dyn.client.v3.traffic.domain.rdata.AData;
import com.dyn.client.v3.traffic.domain.rdata.CNAMEData;
import com.dyn.client.v3.traffic.domain.rdata.MXData;
import com.dyn.client.v3.traffic.domain.rdata.NSData;
import com.dyn.client.v3.traffic.domain.rdata.PTRData;
import com.dyn.client.v3.traffic.domain.rdata.SPFData;
import com.dyn.client.v3.traffic.domain.rdata.SRVData;
import com.dyn.client.v3.traffic.domain.rdata.SSHFPData;
import com.dyn.client.v3.traffic.domain.rdata.TXTData;
import com.dyn.client.v3.traffic.filters.SessionManager;
import com.dyn.client.v3.traffic.functions.ToRecordIds;
import com.google.common.collect.FluentIterable;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;

@Headers(keys={"API-Version"}, values={"{jclouds.api-version}"})
@RequestFilters(value={AlwaysAddUserAgent.class, AlwaysAddContentType.class, SessionManager.class})
public interface RecordApi {
    @Named(value="GetAllRecord")
    @GET
    @Path(value="/AllRecord/{zone}")
    @ResponseParser(value=ToRecordIds.class)
    public FluentIterable<RecordId> list() throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetRecord")
    @GET
    @Path(value="/AllRecord/{zone}/{fqdn}")
    @ResponseParser(value=ToRecordIds.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<RecordId> listByFQDN(@PathParam(value="fqdn") String var1) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetRecord")
    @GET
    @Path(value="/{type}Record/{zone}/{fqdn}")
    @ResponseParser(value=ToRecordIds.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<RecordId> listByFQDNAndType(@PathParam(value="fqdn") String var1, @PathParam(value="type") String var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="CreateRecord")
    @POST
    @Path(value="/{type}Record/{zone}/{fqdn}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Job scheduleCreate(@BinderParam(value=CreateRecordBinder.class) CreateRecord<?> var1) throws DynTrafficExceptions.JobStillRunningException;

    @Nullable
    @Named(value="DeleteRecord")
    @DELETE
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    public Job scheduleDelete(@BinderParam(value=RecordIdBinder.class) RecordId var1) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetRecord")
    @GET
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<? extends Map<String, Object>> get(@BinderParam(value=RecordIdBinder.class) RecordId var1) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetAAAARecord")
    @GET
    @Path(value="/AAAARecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<AAAAData> getAAAA(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetARecord")
    @GET
    @Path(value="/ARecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<AData> getA(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetCNAMERecord")
    @GET
    @Path(value="/CNAMERecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<CNAMEData> getCNAME(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetMXRecord")
    @GET
    @Path(value="/MXRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<MXData> getMX(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetNSRecord")
    @GET
    @Path(value="/NSRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<NSData> getNS(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetPTRRecord")
    @GET
    @Path(value="/PTRRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<PTRData> getPTR(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetSOARecord")
    @GET
    @Path(value="/SOARecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SOARecord getSOA(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetSPFRecord")
    @GET
    @Path(value="/SPFRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<SPFData> getSPF(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetSRVRecord")
    @GET
    @Path(value="/SRVRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<SRVData> getSRV(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetSSHFPRecord")
    @GET
    @Path(value="/SSHFPRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<SSHFPData> getSSHFP(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;

    @Named(value="GetTXTRecord")
    @GET
    @Path(value="/TXTRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<TXTData> getTXT(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynTrafficExceptions.JobStillRunningException;
}

