/*
 * Decompiled with CFR 0.152.
 */
package dps.commons.configuration;

import dps.logging.HasLogger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.PostConstruct;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.beanutils.BeanUtils;

public abstract class XmlConfiguration
implements HasLogger {
    protected abstract String getSettingsFile();

    @PostConstruct
    void init() {
        boolean loaded = false;
        try (InputStream settingsInputStream = this.getClass().getClassLoader().getResourceAsStream(this.getSettingsFile());){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object settings = unmarshaller.unmarshal(settingsInputStream);
            this.logInfo("settings loaded: " + settings);
            BeanUtils.copyProperties((Object)this, (Object)settings);
            loaded = true;
        }
        catch (IOException | IllegalAccessException | InvocationTargetException | JAXBException e) {
            this.logSevere("Couldn't load settings file", e);
        }
        if (!loaded) {
            throw new IllegalArgumentException("Couldn't initialize settings");
        }
    }
}

