/*
 * Decompiled with CFR 0.152.
 */
package dps.commons.startup;

import dps.commons.startup.Startup;
import dps.logging.HasLogger;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Singleton;

@Dependent
public class StartupInit
implements HasLogger {
    public void init() {
        this.logInfo("Loading Startup Classes");
        BeanManager beanManager = CDI.current().getBeanManager();
        Set beans = beanManager.getBeans(Object.class, new Annotation[0]);
        for (Bean bean : beans) {
            Class beanClass = bean.getBeanClass();
            if (bean.getScope() != ApplicationScoped.class && bean.getScope() != Dependent.class && bean.getScope() != Singleton.class || beanClass.getAnnotation(Startup.class) == null) continue;
            Object o = CDI.current().select(beanClass, new Annotation[0]).get();
            this.logInfo("initialized: " + o.toString());
        }
    }
}

