/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment;

import com.dynatrace.agent.events.EventModifier;
import com.dynatrace.agent.events.enrichment.AttributeAggregator;
import com.dynatrace.agent.events.enrichment.AttributeDataSource;
import com.dynatrace.agent.events.enrichment.AttributeSupplierKt;
import com.dynatrace.agent.events.enrichment.BasicMetricsFormatter;
import com.dynatrace.agent.events.enrichment.BasicMetricsSupplier;
import com.dynatrace.agent.events.enrichment.EnrichedJsonContainer;
import com.dynatrace.agent.events.enrichment.EnrichmentAttribute;
import com.dynatrace.agent.events.enrichment.EnrichmentPipelineKt;
import com.dynatrace.agent.events.enrichment.FormattedBasicMetrics;
import com.dynatrace.agent.events.enrichment.JsonObjectExtensionsKt;
import com.dynatrace.agent.events.enrichment.ModifiedJsonMerger;
import com.dynatrace.agent.events.enrichment.NetworkMetricsSupplier;
import com.dynatrace.agent.events.enrichment.ProtectedAttributesSupplier;
import com.dynatrace.agent.events.enrichment.SessionInformationSupplier;
import com.dynatrace.agent.events.enrichment.TimeMetrics;
import com.dynatrace.agent.events.enrichment.TimeMetricsSupplier;
import com.dynatrace.agent.events.enrichment.ViewContextSupplier;
import com.dynatrace.agent.metrics.AggregatedMetricsProviders;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.agent.view.ViewContext;
import com.dynatrace.agent.view.ViewContextStorage;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a7\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0010\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\u0010\t\u001a$\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0000\u001aW\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0010\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\u0010\u001c\u001a$\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00012\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0000\u00a8\u0006 "}, d2={"applyModifications", "Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;", "enrichedJsonContainer", "eventContext", "", "", "modifiers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/dynatrace/agent/events/EventModifier;", "(Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;[Ljava/lang/Object;Ljava/util/concurrent/ConcurrentLinkedQueue;)Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;", "enrichJsonWithAttributes", "inputJson", "Lorg/json/JSONObject;", "enrichmentAttributes", "", "", "Lcom/dynatrace/agent/events/enrichment/EnrichmentAttribute;", "enrichRumEvent", "rumEvent", "timeMetrics", "Lcom/dynatrace/agent/events/enrichment/TimeMetrics;", "attributeDataSource", "Lcom/dynatrace/agent/events/enrichment/AttributeDataSource;", "sessionInformationMetrics", "Lcom/dynatrace/agent/metrics/SessionInformationMetrics;", "viewContextStorage", "Lcom/dynatrace/agent/view/ViewContextStorage;", "eventModifiers", "(Lorg/json/JSONObject;Lcom/dynatrace/agent/events/enrichment/TimeMetrics;Lcom/dynatrace/agent/events/enrichment/AttributeDataSource;Lcom/dynatrace/agent/metrics/SessionInformationMetrics;Lcom/dynatrace/agent/view/ViewContextStorage;Ljava/util/concurrent/ConcurrentLinkedQueue;[Ljava/lang/Object;)Lorg/json/JSONObject;", "integrateProtectedAttributes", "jsonContainer", "protectedAttributes", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nEnrichmentPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnrichmentPipeline.kt\ncom/dynatrace/agent/events/enrichment/EnrichmentPipelineKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1549#2:281\n1620#2,3:282\n1#3:285\n*S KotlinDebug\n*F\n+ 1 EnrichmentPipeline.kt\ncom/dynatrace/agent/events/enrichment/EnrichmentPipelineKt\n*L\n192#1:281\n192#1:282,3\n*E\n"})
public final class EnrichmentPipelineKt {
    @Nullable
    public static final JSONObject enrichRumEvent(@NotNull JSONObject rumEvent, @NotNull TimeMetrics timeMetrics, @NotNull AttributeDataSource attributeDataSource, @NotNull SessionInformationMetrics sessionInformationMetrics, @NotNull ViewContextStorage viewContextStorage, @NotNull ConcurrentLinkedQueue<EventModifier> eventModifiers, @Nullable Object[] eventContext) {
        List list;
        ViewContext context;
        List list2;
        Intrinsics.checkNotNullParameter((Object)rumEvent, (String)"rumEvent");
        Intrinsics.checkNotNullParameter((Object)timeMetrics, (String)"timeMetrics");
        Intrinsics.checkNotNullParameter((Object)attributeDataSource, (String)"attributeDataSource");
        Intrinsics.checkNotNullParameter((Object)sessionInformationMetrics, (String)"sessionInformationMetrics");
        Intrinsics.checkNotNullParameter((Object)viewContextStorage, (String)"viewContextStorage");
        Intrinsics.checkNotNullParameter(eventModifiers, (String)"eventModifiers");
        AggregatedMetricsProviders metricProviders = attributeDataSource.getAggregatedMetricsProviders();
        FormattedBasicMetrics formattedBasicMetrics = new BasicMetricsFormatter(metricProviders.getBasicMetrics()).collectFormattedMetrics();
        BasicMetricsSupplier basicMetricsSupplier = new BasicMetricsSupplier(formattedBasicMetrics);
        NetworkMetricsSupplier networkMetricsSupplier = new NetworkMetricsSupplier(metricProviders.getNetworkMetrics());
        List $this$enrichRumEvent_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$enrichRumEvent_u24lambda_u242.add(basicMetricsSupplier);
        $this$enrichRumEvent_u24lambda_u242.add(networkMetricsSupplier);
        $this$enrichRumEvent_u24lambda_u242.add(new TimeMetricsSupplier(timeMetrics));
        if (attributeDataSource.isApiReported()) {
            $this$enrichRumEvent_u24lambda_u242.add(EnrichmentPipelineKt::enrichRumEvent$lambda$2$lambda$1);
        }
        if ((context = viewContextStorage.provideContext()) != null) {
            $this$enrichRumEvent_u24lambda_u242.add(new ViewContextSupplier(context));
        }
        List list3 = CollectionsKt.build((List)list2);
        AttributeAggregator overridableAttributeGenerator = new AttributeAggregator(list3);
        Utility.devLog("dtxEnrichment", "rum event: " + rumEvent);
        EnrichedJsonContainer enrichedJson = EnrichmentPipelineKt.enrichJsonWithAttributes(rumEvent, overridableAttributeGenerator.aggregatedAttributes());
        Utility.devLog("dtxEnrichment", "rum event after basic enrichment: overridden attributes: " + enrichedJson.getOverriddenAttributes() + "; event: " + enrichedJson.getEnrichedJson());
        EnrichedJsonContainer enrichedJsonContainer = EnrichmentPipelineKt.applyModifications(enrichedJson, eventContext, eventModifiers);
        if (enrichedJsonContainer == null) {
            return null;
        }
        EnrichedJsonContainer modifiedJson = enrichedJsonContainer;
        Utility.devLog("dtxEnrichment", "rum event after modifications: overridden attributes: " + modifiedJson.getOverriddenAttributes() + "; event: " + modifiedJson.getEnrichedJson());
        ProtectedAttributesSupplier protectedAttributesSupplier = new ProtectedAttributesSupplier(attributeDataSource.getApplicationId(), attributeDataSource.getAgentVersion());
        SessionInformationSupplier sessionInformationSupplier = new SessionInformationSupplier(sessionInformationMetrics);
        List $this$enrichRumEvent_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        $this$enrichRumEvent_u24lambda_u243.add(protectedAttributesSupplier);
        $this$enrichRumEvent_u24lambda_u243.add(sessionInformationSupplier);
        List list4 = CollectionsKt.build((List)list);
        AttributeAggregator protectedAttributeAggregator = new AttributeAggregator(list4);
        JSONObject enrichedRumEvent = EnrichmentPipelineKt.integrateProtectedAttributes(modifiedJson, protectedAttributeAggregator.aggregatedAttributes());
        Utility.devLog("dtxEnrichment", "rum event after full enrichment: " + enrichedRumEvent);
        return enrichedRumEvent;
    }

    @NotNull
    public static final EnrichedJsonContainer enrichJsonWithAttributes(@NotNull JSONObject inputJson, @NotNull Map<String, EnrichmentAttribute> enrichmentAttributes) {
        Intrinsics.checkNotNullParameter((Object)inputJson, (String)"inputJson");
        Intrinsics.checkNotNullParameter(enrichmentAttributes, (String)"enrichmentAttributes");
        JSONObject json = JsonObjectExtensionsKt.deepCopy(inputJson);
        ArrayList<EnrichmentAttribute> overriddenByJson = new ArrayList<EnrichmentAttribute>();
        for (Map.Entry<String, EnrichmentAttribute> entry : enrichmentAttributes.entrySet()) {
            String key = entry.getKey();
            EnrichmentAttribute attribute = entry.getValue();
            Object value = json.opt(key);
            if (value != null && !value.equals(attribute.getValue())) {
                Utility.devLog("dtxEnrichment", "auto-enrichment value overwritten: " + attribute + " is overwritten with custom value: " + value);
                overriddenByJson.add(attribute);
                continue;
            }
            json.put(key, attribute.getValue());
        }
        return new EnrichedJsonContainer(json, (List<EnrichmentAttribute>)overriddenByJson);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JSONObject integrateProtectedAttributes(@NotNull EnrichedJsonContainer jsonContainer, @NotNull Map<String, EnrichmentAttribute> protectedAttributes) {
        JSONObject jSONObject;
        List<EnrichmentAttribute> overriddenAttributes;
        Object key;
        Intrinsics.checkNotNullParameter((Object)jsonContainer, (String)"jsonContainer");
        Intrinsics.checkNotNullParameter(protectedAttributes, (String)"protectedAttributes");
        JSONObject enrichedJson = jsonContainer.getEnrichedJson();
        for (Map.Entry<String, EnrichmentAttribute> jSONObject2 : protectedAttributes.entrySet()) {
            key = jSONObject2.getKey();
            EnrichmentAttribute protectedAttribute = jSONObject2.getValue();
            if (enrichedJson.has((String)key)) {
                Utility.devLog("dtxEnrichment", "protected attribute integration: encountered key '" + (String)key + "' which is protected and will be overwritten with " + protectedAttribute);
            }
            enrichedJson.put((String)key, protectedAttribute.getValue());
        }
        if (enrichedJson.remove("dt.rum.overridden_keys") != null) {
            Utility.devLog("dtxEnrichment", "protected attribute integration: encountered key 'dt.rum.overridden_keys' which is protected and will be removed");
        }
        if (!((Collection)(overriddenAttributes = jsonContainer.getOverriddenAttributes())).isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            key = overriddenAttributes;
            String string = "dt.rum.overridden_keys";
            JSONObject jSONObject2 = enrichedJson;
            boolean $i$f$map = false;
            void var7_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EnrichmentAttribute enrichmentAttribute = (EnrichmentAttribute)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey());
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            JSONObject jSONObject3 = jSONObject2.put(string, (Object)new JSONArray(collection2));
            Intrinsics.checkNotNull((Object)jSONObject3);
            jSONObject = jSONObject3;
        } else {
            jSONObject = enrichedJson;
        }
        return jSONObject;
    }

    @Nullable
    public static final EnrichedJsonContainer applyModifications(@NotNull EnrichedJsonContainer enrichedJsonContainer, @Nullable Object[] eventContext, @NotNull ConcurrentLinkedQueue<EventModifier> modifiers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)enrichedJsonContainer, (String)"enrichedJsonContainer");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        if (modifiers.isEmpty()) {
            return enrichedJsonContainer;
        }
        StringBuilder stringBuilder = new StringBuilder().append("apply modifications: with ").append(modifiers.size()).append(" modifier(s); context: ");
        Object object2 = eventContext;
        if (eventContext == null || (object2 = ArraysKt.joinToString$default((Object[])object2, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)applyModifications.1.INSTANCE, (int)24, null)) == null) {
            object2 = "null";
        }
        Utility.devLog("dtxEnrichment", stringBuilder.append((String)object2).toString());
        JSONObject modifiableCopy = JsonObjectExtensionsKt.deepCopy(enrichedJsonContainer.getEnrichedJson());
        boolean modifierCausedException = false;
        Object object3 = modifiers.iterator();
        while (object3.hasNext()) {
            JSONObject jSONObject;
            EventModifier modifier = object3.next();
            try {
                jSONObject = modifier.modifyEvent(modifiableCopy, eventContext);
            }
            catch (Exception throwable) {
                Utility.devLog("dtxEnrichment", "apply modifications: event modifier caused exception", throwable);
                modifierCausedException = true;
                jSONObject = modifiableCopy;
            }
            if ((modifiableCopy = jSONObject) != null) continue;
            Utility.devLog("dtxEnrichment", "apply modifications: event dropped by event modifier");
            break;
        }
        if (modifiableCopy == null) {
            object = null;
        } else {
            Object $this$applyModifications_u24lambda_u245 = object3 = new ModifiedJsonMerger(enrichedJsonContainer).merge(modifiableCopy);
            boolean bl = false;
            if (modifierCausedException) {
                ((EnrichedJsonContainer)$this$applyModifications_u24lambda_u245).getEnrichedJson().put("dt.rum.has_enrich_api_exception", true);
            }
            object = object3;
        }
        return object;
    }

    private static final List enrichRumEvent$lambda$2$lambda$1() {
        List list;
        List $this$enrichRumEvent_u24lambda_u242_u24lambda_u241_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        AttributeSupplierKt.addAttribute($this$enrichRumEvent_u24lambda_u242_u24lambda_u241_u24lambda_u240, "is_api_reported", true);
        return CollectionsKt.build((List)list);
    }
}

