/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment;

import com.dynatrace.agent.events.enrichment.AttributeSanitizer;
import com.dynatrace.agent.events.enrichment.JsonAttribute;
import com.dynatrace.agent.events.enrichment.SanitationContext;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0017\u001a\u00020\t2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0006H\u0000\u001a\f\u0010\u001c\u001a\u00020\u001b*\u00020\u0006H\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\"\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0014\u0010\f\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0014\u0010\u000e\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0014\u0010\u0010\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0014\u0010\u0012\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\"\u0014\u0010\u0015\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000b\u00a8\u0006\u001f"}, d2={"JSON_CUSTOM_FIELD_LIMIT", "", "MAX_ATTRIBUTE_KEY_SIZE", "MAX_STRING_VALUE_SIZE", "knownCharacteristics", "", "", "[Ljava/lang/String;", "removeAttributeWithExceedingKeySize", "Lcom/dynatrace/agent/events/enrichment/AttributeSanitizer;", "getRemoveAttributeWithExceedingKeySize", "()Lcom/dynatrace/agent/events/enrichment/AttributeSanitizer;", "removeCharacteristicAttributes", "getRemoveCharacteristicAttributes", "removeNestedJsonObjectAndArrays", "getRemoveNestedJsonObjectAndArrays", "removeNonBooleanCharacteristicAttributes", "getRemoveNonBooleanCharacteristicAttributes", "removeRestrictedNamespaceAttributes", "getRemoveRestrictedNamespaceAttributes", "restrictedNamespaces", "trimTooLongStringValues", "getTrimTooLongStringValues", "removeForbiddenKeys", "forbiddenKeys", "([Ljava/lang/String;)Lcom/dynatrace/agent/events/enrichment/AttributeSanitizer;", "isCharacteristic", "", "isInRestrictedNamespace", "trimFields", "Lcom/dynatrace/agent/events/enrichment/SanitationContext;", "com.dynatrace.agent_release"})
public final class JsonAttributeSanitationKt {
    private static final int MAX_ATTRIBUTE_KEY_SIZE = 100;
    private static final int MAX_STRING_VALUE_SIZE = 5000;
    public static final int JSON_CUSTOM_FIELD_LIMIT = 50;
    @NotNull
    private static final String[] restrictedNamespaces;
    @NotNull
    private static final String[] knownCharacteristics;
    @NotNull
    private static final AttributeSanitizer removeRestrictedNamespaceAttributes;
    @NotNull
    private static final AttributeSanitizer removeCharacteristicAttributes;
    @NotNull
    private static final AttributeSanitizer removeNonBooleanCharacteristicAttributes;
    @NotNull
    private static final AttributeSanitizer removeNestedJsonObjectAndArrays;
    @NotNull
    private static final AttributeSanitizer removeAttributeWithExceedingKeySize;
    @NotNull
    private static final AttributeSanitizer trimTooLongStringValues;

    public static final boolean isInRestrictedNamespace(@NotNull String $this$isInRestrictedNamespace) {
        Intrinsics.checkNotNullParameter((Object)$this$isInRestrictedNamespace, (String)"<this>");
        for (String namespace : restrictedNamespaces) {
            if (!Intrinsics.areEqual((Object)$this$isInRestrictedNamespace, (Object)namespace) && !StringsKt.startsWith$default((String)$this$isInRestrictedNamespace, (String)(namespace + '.'), (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isCharacteristic(@NotNull String $this$isCharacteristic) {
        Intrinsics.checkNotNullParameter((Object)$this$isCharacteristic, (String)"<this>");
        return ArraysKt.contains((Object[])knownCharacteristics, (Object)$this$isCharacteristic);
    }

    @NotNull
    public static final AttributeSanitizer getRemoveRestrictedNamespaceAttributes() {
        return removeRestrictedNamespaceAttributes;
    }

    @NotNull
    public static final AttributeSanitizer getRemoveCharacteristicAttributes() {
        return removeCharacteristicAttributes;
    }

    @NotNull
    public static final AttributeSanitizer getRemoveNonBooleanCharacteristicAttributes() {
        return removeNonBooleanCharacteristicAttributes;
    }

    @NotNull
    public static final AttributeSanitizer removeForbiddenKeys(String ... forbiddenKeys) {
        Intrinsics.checkNotNullParameter((Object)forbiddenKeys, (String)"forbiddenKeys");
        return arg_0 -> JsonAttributeSanitationKt.removeForbiddenKeys$lambda$3(forbiddenKeys, arg_0);
    }

    @NotNull
    public static final AttributeSanitizer getRemoveNestedJsonObjectAndArrays() {
        return removeNestedJsonObjectAndArrays;
    }

    @NotNull
    public static final AttributeSanitizer getRemoveAttributeWithExceedingKeySize() {
        return removeAttributeWithExceedingKeySize;
    }

    @NotNull
    public static final AttributeSanitizer getTrimTooLongStringValues() {
        return trimTooLongStringValues;
    }

    @NotNull
    public static final SanitationContext trimFields(@NotNull SanitationContext $this$trimFields) {
        Intrinsics.checkNotNullParameter((Object)$this$trimFields, (String)"<this>");
        Iterator iterator = $this$trimFields.getSanitizedJson().keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        List sortedList = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.asSequence((Iterator)iterator), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)a;
                boolean bl = false;
                Comparable comparable = Intrinsics.areEqual((Object)it, (Object)"start_time") || Intrinsics.areEqual((Object)it, (Object)"duration") ? (Comparable)((Object)"") : (Comparable)((Object)it);
                it = (String)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(Intrinsics.areEqual((Object)it, (Object)"start_time") || Intrinsics.areEqual((Object)it, (Object)"duration") ? (Comparable)((Object)"") : (Comparable)((Object)it)));
            }
        }));
        if (sortedList.size() > 50) {
            ArrayList<JsonAttribute> overflowingAttributes = new ArrayList<JsonAttribute>();
            ListIterator listIterator = sortedList.listIterator(50);
            while (listIterator.hasNext()) {
                Object removedValue;
                String key = (String)listIterator.next();
                Intrinsics.checkNotNull((Object)$this$trimFields.getSanitizedJson().remove(key));
                Intrinsics.checkNotNull((Object)key);
                overflowingAttributes.add(new JsonAttribute(key, removedValue));
            }
            Utility.devLog("dtxEnrichment", "sanitation: json contains too many attributes: " + sortedList.size() + "; dropped attributes: " + overflowingAttributes);
            $this$trimFields.getDroppedAttributes().addAll((Collection<JsonAttribute>)overflowingAttributes);
        }
        return $this$trimFields;
    }

    private static final JsonAttribute removeRestrictedNamespaceAttributes$lambda$0(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        if (JsonAttributeSanitationKt.isInRestrictedNamespace(jsonAttribute.getKey())) {
            Utility.devLog("dtxEnrichment", "sanitation: key '" + jsonAttribute.getKey() + "' is in restricted namespace and thus dropped");
            jsonAttribute2 = null;
        } else {
            jsonAttribute2 = jsonAttribute;
        }
        return jsonAttribute2;
    }

    private static final JsonAttribute removeCharacteristicAttributes$lambda$1(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        if (JsonAttributeSanitationKt.isCharacteristic(jsonAttribute.getKey())) {
            Utility.devLog("dtxEnrichment", "sanitation: key '" + jsonAttribute.getKey() + "' is a reserved characteristic and thus dropped");
            jsonAttribute2 = null;
        } else {
            jsonAttribute2 = jsonAttribute;
        }
        return jsonAttribute2;
    }

    private static final JsonAttribute removeNonBooleanCharacteristicAttributes$lambda$2(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        if (JsonAttributeSanitationKt.isCharacteristic(jsonAttribute.getKey()) && !(jsonAttribute.getValue() instanceof Boolean)) {
            Utility.devLog("dtxEnrichment", "sanitation: key '" + jsonAttribute.getKey() + "' is considered a characteristic but has invalid type (" + jsonAttribute.getValue().getClass() + ") and thus its dropped");
            jsonAttribute2 = null;
        } else {
            jsonAttribute2 = jsonAttribute;
        }
        return jsonAttribute2;
    }

    private static final JsonAttribute removeForbiddenKeys$lambda$3(String[] $forbiddenKeys, JsonAttribute attribute) {
        JsonAttribute jsonAttribute;
        Intrinsics.checkNotNullParameter((Object)$forbiddenKeys, (String)"$forbiddenKeys");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (ArraysKt.contains((Object[])$forbiddenKeys, (Object)attribute.getKey())) {
            Utility.devLog("dtxEnrichment", "sanitation: key '" + attribute.getKey() + "' is among forbidden keys " + ArraysKt.toList((Object[])$forbiddenKeys) + " and thus dropped");
            jsonAttribute = null;
        } else {
            jsonAttribute = attribute;
        }
        return jsonAttribute;
    }

    private static final JsonAttribute removeNestedJsonObjectAndArrays$lambda$4(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        if (jsonAttribute.getValue() instanceof JSONObject || jsonAttribute.getValue() instanceof JSONArray) {
            Utility.devLog("dtxEnrichment", "sanitation: key '" + jsonAttribute.getKey() + "' is a nested object or array and thus dropped");
            jsonAttribute2 = null;
        } else {
            jsonAttribute2 = jsonAttribute;
        }
        return jsonAttribute2;
    }

    private static final JsonAttribute removeAttributeWithExceedingKeySize$lambda$5(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        if (jsonAttribute.getKey().length() > 100) {
            Utility.devLog("dtxEnrichment", "sanitation: dropped a key because it was too long; limit: 100; actual length: " + jsonAttribute.getKey().length() + "; key: '" + jsonAttribute.getKey() + '\'');
            jsonAttribute2 = null;
        } else {
            jsonAttribute2 = jsonAttribute;
        }
        return jsonAttribute2;
    }

    private static final JsonAttribute trimTooLongStringValues$lambda$6(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        if (jsonAttribute.getValue() instanceof String && ((String)jsonAttribute.getValue()).length() > 5000) {
            Utility.devLog("dtxEnrichment", "sanitation: value of key '" + jsonAttribute.getKey() + "' is too long and thus is trimmed; original length: " + ((String)jsonAttribute.getValue()).length() + "; ");
            String string = jsonAttribute.getKey();
            String string2 = ((String)jsonAttribute.getValue()).substring(0, 5000);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            jsonAttribute2 = new JsonAttribute(string, string2);
        } else {
            jsonAttribute2 = jsonAttribute;
        }
        return jsonAttribute2;
    }

    static {
        String[] stringArray = new String[]{"dt", "os", "geo", "client", "browser", "device", "performance", "time_correction"};
        restrictedNamespaces = stringArray;
        stringArray = new String[]{"has_error", "has_anr", "has_crash", "has_exception", "has_failed_request", "has_request", "has_navigation", "has_user_interaction", "is_visibility_change", "is_appstart", "is_api_reported", "is_self_monitoring", "is_internal"};
        knownCharacteristics = stringArray;
        removeRestrictedNamespaceAttributes = JsonAttributeSanitationKt::removeRestrictedNamespaceAttributes$lambda$0;
        removeCharacteristicAttributes = JsonAttributeSanitationKt::removeCharacteristicAttributes$lambda$1;
        removeNonBooleanCharacteristicAttributes = JsonAttributeSanitationKt::removeNonBooleanCharacteristicAttributes$lambda$2;
        removeNestedJsonObjectAndArrays = JsonAttributeSanitationKt::removeNestedJsonObjectAndArrays$lambda$4;
        removeAttributeWithExceedingKeySize = JsonAttributeSanitationKt::removeAttributeWithExceedingKeySize$lambda$5;
        trimTooLongStringValues = JsonAttributeSanitationKt::trimTooLongStringValues$lambda$6;
    }
}

