/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment;

import com.dynatrace.agent.events.enrichment.AttributeSanitizer;
import com.dynatrace.agent.events.enrichment.JsonAttribute;
import com.dynatrace.agent.events.enrichment.JsonAttributeKt;
import com.dynatrace.agent.events.enrichment.SanitationContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0004H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001f\u0010\t\u001a\u00020\n*\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"copyJsonValue", "", "value", "deepCopy", "Lorg/json/JSONArray;", "Lorg/json/JSONObject;", "put", "jsonAttribute", "Lcom/dynatrace/agent/events/enrichment/JsonAttribute;", "sanitizedDeepCopy", "Lcom/dynatrace/agent/events/enrichment/SanitationContext;", "attributeSanitizers", "", "Lcom/dynatrace/agent/events/enrichment/AttributeSanitizer;", "(Lorg/json/JSONObject;[Lcom/dynatrace/agent/events/enrichment/AttributeSanitizer;)Lcom/dynatrace/agent/events/enrichment/SanitationContext;", "com.dynatrace.agent_release"})
public final class JsonObjectExtensionsKt {
    @NotNull
    public static final JSONArray deepCopy(@NotNull JSONArray $this$deepCopy) {
        Intrinsics.checkNotNullParameter((Object)$this$deepCopy, (String)"<this>");
        JSONArray copiedJsonArray = new JSONArray();
        int n = $this$deepCopy.length();
        for (int i = 0; i < n; ++i) {
            Object object = $this$deepCopy.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            copiedJsonArray.put(JsonObjectExtensionsKt.copyJsonValue(object));
        }
        return copiedJsonArray;
    }

    @NotNull
    public static final JSONObject deepCopy(@NotNull JSONObject $this$deepCopy) {
        Intrinsics.checkNotNullParameter((Object)$this$deepCopy, (String)"<this>");
        JSONObject copiedJson = new JSONObject();
        Iterator iterator = $this$deepCopy.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            Object object = $this$deepCopy.get(key);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            copiedJson.put(key, JsonObjectExtensionsKt.copyJsonValue(object));
        }
        return copiedJson;
    }

    @NotNull
    public static final Object copyJsonValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        return object instanceof JSONArray ? JsonObjectExtensionsKt.deepCopy((JSONArray)value) : (object instanceof JSONObject ? JsonObjectExtensionsKt.deepCopy((JSONObject)value) : value);
    }

    @NotNull
    public static final SanitationContext sanitizedDeepCopy(@NotNull JSONObject $this$sanitizedDeepCopy, @NotNull AttributeSanitizer[] attributeSanitizers) {
        Intrinsics.checkNotNullParameter((Object)$this$sanitizedDeepCopy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)attributeSanitizers, (String)"attributeSanitizers");
        JSONObject copiedJson = new JSONObject();
        List droppedAttributes = new ArrayList();
        Iterator iterator = $this$sanitizedDeepCopy.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            Intrinsics.checkNotNull((Object)key);
            Object object = $this$sanitizedDeepCopy.get(key);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            JsonAttribute attribute = new JsonAttribute(key, JsonObjectExtensionsKt.copyJsonValue(object));
            JsonAttribute sanitizedCopy = JsonAttributeKt.applySanitizers(attribute, attributeSanitizers);
            if (sanitizedCopy != null) {
                JsonObjectExtensionsKt.put(copiedJson, sanitizedCopy);
                continue;
            }
            droppedAttributes.add(attribute);
        }
        return new SanitationContext(copiedJson, droppedAttributes);
    }

    @NotNull
    public static final JSONObject put(@NotNull JSONObject $this$put, @NotNull JsonAttribute jsonAttribute) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        JSONObject jSONObject = $this$put.put(jsonAttribute.getKey(), jsonAttribute.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }
}

