/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

public final class ReplayConfiguration {
    public static final ReplayConfiguration DEFAULT_REPLAY_CONFIGURATION = ReplayConfiguration.builder().build();
    public static final boolean DEFAULT_REPLAY_CAPTURE = false;
    public static final boolean DEFAULT_REPLAY_CRASHES_ENABLED = false;
    public static final boolean DEFAULT_REPLAY_FULL_SESSION_CONFIG_RECEIVED = false;
    public static final int DEFAULT_REPLAY_TRAFFIC_CONTROL_PERCENTAGE = 0;
    public static final int DEFAULT_RETENTION_TIME = 0;
    public static final int DEFAULT_PROTOCOL_VERSION = 1;
    public static final int DEFAULT_REPLAY_SELFMONITORING = 0;
    public static final boolean DEFAULT_REPLAY_PIXEL_COPY_ENABLED = false;
    private final boolean capture;
    private final boolean fullSessionConfigReceived;
    private final boolean crashesEnabled;
    private final int trafficControlPercentage;
    private final int retentionTimeInMinutes;
    private final int protocolVersion;
    private final int selfMonitoring;
    private final boolean pixelCopyEnabled;

    private ReplayConfiguration(Builder builder) {
        this.capture = builder.capture;
        this.fullSessionConfigReceived = builder.fullSessionConfigReceived;
        this.crashesEnabled = builder.crashesEnabled;
        this.trafficControlPercentage = builder.trafficControlPercentage;
        this.retentionTimeInMinutes = builder.retentionTimeInMinutes;
        this.protocolVersion = builder.protocolVersion;
        this.selfMonitoring = builder.selfMonitoring;
        this.pixelCopyEnabled = builder.pixelCopyEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isCaptureOn() {
        return this.capture;
    }

    public boolean getFullSessionConfigReceived() {
        return this.fullSessionConfigReceived;
    }

    public boolean getCrashesEnabled() {
        return this.crashesEnabled;
    }

    public int getTrafficControlPercentage() {
        return this.trafficControlPercentage;
    }

    public int getRetentionTimeInMinutes() {
        return this.retentionTimeInMinutes;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getSelfMonitoring() {
        return this.selfMonitoring;
    }

    public boolean isPixelCopyEnabled() {
        return this.pixelCopyEnabled;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayConfiguration that = (ReplayConfiguration)o;
        return this.capture == that.capture && this.fullSessionConfigReceived == that.fullSessionConfigReceived && this.retentionTimeInMinutes == that.retentionTimeInMinutes && this.crashesEnabled == that.crashesEnabled && this.protocolVersion == that.protocolVersion && this.selfMonitoring == that.selfMonitoring && this.trafficControlPercentage == that.trafficControlPercentage && this.pixelCopyEnabled == that.pixelCopyEnabled;
    }

    public int hashCode() {
        int result = this.capture ? 1 : 0;
        result = 31 * result + (this.fullSessionConfigReceived ? 1 : 0);
        result = 31 * result + (this.crashesEnabled ? 1 : 0);
        result = 31 * result + this.trafficControlPercentage;
        result = 31 * result + (this.retentionTimeInMinutes ^ this.retentionTimeInMinutes >>> 32);
        result = 31 * result + this.protocolVersion;
        result = 31 * result + this.selfMonitoring;
        result = 31 * result + (this.pixelCopyEnabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ReplayConfiguration{capture=" + this.capture + ", fullSessionConfigReceived=" + this.fullSessionConfigReceived + ", crashesEnabled=" + this.crashesEnabled + ", trafficControlPercentage=" + this.trafficControlPercentage + ", retentionTime=" + this.retentionTimeInMinutes + ", protocolVersion=" + this.protocolVersion + ", selfMonitoring=" + this.selfMonitoring + ", pixelCopy=" + this.pixelCopyEnabled + '}';
    }

    public static class Builder {
        private boolean capture;
        private boolean fullSessionConfigReceived;
        private boolean crashesEnabled;
        private int trafficControlPercentage;
        private int retentionTimeInMinutes;
        private int protocolVersion;
        private int selfMonitoring;
        private boolean pixelCopyEnabled;

        public Builder() {
            this.capture = false;
            this.fullSessionConfigReceived = false;
            this.crashesEnabled = false;
            this.trafficControlPercentage = 0;
            this.retentionTimeInMinutes = 0;
            this.protocolVersion = 1;
            this.selfMonitoring = 0;
            this.pixelCopyEnabled = false;
        }

        public Builder(ReplayConfiguration oldReplayConfiguration) {
            this.capture = oldReplayConfiguration.capture;
            this.fullSessionConfigReceived = oldReplayConfiguration.fullSessionConfigReceived;
            this.crashesEnabled = oldReplayConfiguration.crashesEnabled;
            this.trafficControlPercentage = oldReplayConfiguration.trafficControlPercentage;
            this.retentionTimeInMinutes = oldReplayConfiguration.retentionTimeInMinutes;
            this.protocolVersion = oldReplayConfiguration.protocolVersion;
            this.selfMonitoring = oldReplayConfiguration.selfMonitoring;
            this.pixelCopyEnabled = oldReplayConfiguration.pixelCopyEnabled;
        }

        public Builder withCapture(boolean capture) {
            this.capture = capture;
            return this;
        }

        public Builder withFullSessionConfigReceived(boolean fullSessionConfigReceived) {
            this.fullSessionConfigReceived = fullSessionConfigReceived;
            return this;
        }

        public Builder withCrashesEnabled(boolean crashesEnabled) {
            this.crashesEnabled = crashesEnabled;
            return this;
        }

        public Builder withTrafficControlPercentage(int trafficControlPercentage) {
            this.trafficControlPercentage = trafficControlPercentage;
            return this;
        }

        public Builder withRetentionTimeInMinutes(int retentionTimeInMinutes) {
            this.retentionTimeInMinutes = retentionTimeInMinutes;
            return this;
        }

        public Builder withProtocolVersion(int protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder withSelfMonitoring(int selfMonitoring) {
            this.selfMonitoring = selfMonitoring;
            return this;
        }

        public Builder withPixelCopyEnabled(boolean pixelCopyEnabled) {
            this.pixelCopyEnabled = pixelCopyEnabled;
            return this;
        }

        public ReplayConfiguration build() {
            return new ReplayConfiguration(this);
        }
    }
}

