/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment;

import com.dynatrace.agent.events.EventModifier;
import com.dynatrace.agent.events.enrichment.AttributeAggregator;
import com.dynatrace.agent.events.enrichment.AttributeSupplier;
import com.dynatrace.agent.events.enrichment.BasicMetricsFormatter;
import com.dynatrace.agent.events.enrichment.BasicMetricsSupplier;
import com.dynatrace.agent.events.enrichment.EnrichedJsonContainer;
import com.dynatrace.agent.events.enrichment.EnrichmentAttribute;
import com.dynatrace.agent.events.enrichment.EnrichmentPipelineKt;
import com.dynatrace.agent.events.enrichment.FormattedBasicMetrics;
import com.dynatrace.agent.events.enrichment.JsonObjectExtensionsKt;
import com.dynatrace.agent.events.enrichment.NetworkMetricsSupplier;
import com.dynatrace.agent.events.enrichment.merge.ModifiedJsonMerger;
import com.dynatrace.agent.events.enrichment.merge.ModifiedJsonMergerV16;
import com.dynatrace.agent.metrics.AggregatedMetricsProviders;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u001a7\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0010\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a$\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0000\u001aG\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0010\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\u0010\u001c\u001a\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0000\u001a\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0001H\u0000\u001a$\u0010\"\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00012\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0000\u001a \u0010$\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'H\u0002\u00a8\u0006("}, d2={"applyModifications", "Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;", "enrichedJsonContainer", "eventContext", "", "", "modifiers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/dynatrace/agent/events/EventModifier;", "(Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;[Ljava/lang/Object;Ljava/util/concurrent/ConcurrentLinkedQueue;)Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;", "collectBasicMetricSuppliers", "", "Lcom/dynatrace/agent/events/enrichment/AttributeSupplier;", "metricsProviders", "Lcom/dynatrace/agent/metrics/AggregatedMetricsProviders;", "enrichJsonWithAttributes", "inputJson", "Lorg/json/JSONObject;", "enrichmentAttributes", "", "", "Lcom/dynatrace/agent/events/enrichment/EnrichmentAttribute;", "enrichRumEvent", "rumEvent", "overridableAttributeAggregator", "Lcom/dynatrace/agent/events/enrichment/AttributeAggregator;", "protectedAttributeAggregator", "eventModifiers", "(Lorg/json/JSONObject;Lcom/dynatrace/agent/events/enrichment/AttributeAggregator;Lcom/dynatrace/agent/events/enrichment/AttributeAggregator;Ljava/util/concurrent/ConcurrentLinkedQueue;[Ljava/lang/Object;)Lorg/json/JSONObject;", "findExistingOverriddenKeys", "", "json", "integrateOverriddenKeys", "jsonContainer", "integrateProtectedAttributes", "protectedAttributes", "merge", "modifiableCopy", "modifierCausedException", "", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nEnrichmentPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnrichmentPipeline.kt\ncom/dynatrace/agent/events/enrichment/EnrichmentPipelineKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n295#2,2:334\n1557#2:336\n1628#2,3:337\n*S KotlinDebug\n*F\n+ 1 EnrichmentPipeline.kt\ncom/dynatrace/agent/events/enrichment/EnrichmentPipelineKt\n*L\n125#1:334,2\n201#1:336\n201#1:337,3\n*E\n"})
public final class EnrichmentPipelineKt {
    @Nullable
    public static final JSONObject enrichRumEvent(@NotNull JSONObject rumEvent, @NotNull AttributeAggregator overridableAttributeAggregator, @NotNull AttributeAggregator protectedAttributeAggregator, @NotNull ConcurrentLinkedQueue<EventModifier> eventModifiers, @Nullable Object[] eventContext) {
        Intrinsics.checkNotNullParameter((Object)rumEvent, (String)"rumEvent");
        Intrinsics.checkNotNullParameter((Object)overridableAttributeAggregator, (String)"overridableAttributeAggregator");
        Intrinsics.checkNotNullParameter((Object)protectedAttributeAggregator, (String)"protectedAttributeAggregator");
        Intrinsics.checkNotNullParameter(eventModifiers, (String)"eventModifiers");
        Utility.devLog("dtxEnrichment", "rum event: " + rumEvent);
        EnrichedJsonContainer enrichedJson = EnrichmentPipelineKt.enrichJsonWithAttributes(rumEvent, overridableAttributeAggregator.aggregatedAttributes());
        EnrichedJsonContainer jsonWithProtectedAttributes = EnrichedJsonContainer.copy$default(enrichedJson, EnrichmentPipelineKt.integrateProtectedAttributes(enrichedJson, protectedAttributeAggregator.aggregatedAttributes()), null, 2, null);
        Utility.devLog("dtxEnrichment", "rum event after basic enrichment: overridden attributes: " + enrichedJson.getOverriddenAttributes() + "; event: " + enrichedJson.getEnrichedJson());
        EnrichedJsonContainer enrichedJsonContainer = EnrichmentPipelineKt.applyModifications(jsonWithProtectedAttributes, eventContext, eventModifiers);
        if (enrichedJsonContainer == null) {
            return null;
        }
        EnrichedJsonContainer modifiedJson = enrichedJsonContainer;
        Utility.devLog("dtxEnrichment", "rum event after modifications: overridden attributes: " + modifiedJson.getOverriddenAttributes() + "; event: " + modifiedJson.getEnrichedJson());
        JSONObject enrichedRumEvent = EnrichmentPipelineKt.integrateOverriddenKeys(modifiedJson);
        Utility.devLog("dtxEnrichment", "rum event after full enrichment: " + enrichedRumEvent);
        return enrichedRumEvent;
    }

    @NotNull
    public static final EnrichedJsonContainer enrichJsonWithAttributes(@NotNull JSONObject inputJson, @NotNull Map<String, EnrichmentAttribute> enrichmentAttributes) {
        Intrinsics.checkNotNullParameter((Object)inputJson, (String)"inputJson");
        Intrinsics.checkNotNullParameter(enrichmentAttributes, (String)"enrichmentAttributes");
        JSONObject json = JsonObjectExtensionsKt.deepCopy(inputJson);
        List<EnrichmentAttribute> overriddenByJson = EnrichmentPipelineKt.findExistingOverriddenKeys(json);
        json.remove("dt.rum.overridden_keys");
        for (Map.Entry<String, EnrichmentAttribute> entry : enrichmentAttributes.entrySet()) {
            String key = entry.getKey();
            EnrichmentAttribute attribute = entry.getValue();
            Object value = json.opt(key);
            if (value != null && !value.equals(attribute.getValue())) {
                Object v0;
                block4: {
                    Utility.devLog("dtxEnrichment", "auto-enrichment value overwritten: " + attribute + " is overwritten with custom value: " + value);
                    Iterable $this$firstOrNull$iv = overriddenByJson;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        EnrichmentAttribute it = (EnrichmentAttribute)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getKey(), (Object)key)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                EnrichmentAttribute existingOverriddenKeyOrNull = v0;
                if (existingOverriddenKeyOrNull != null) {
                    Utility.devLog("dtxEnrichment", "key '" + key + "' already in overridden keys list. Replacing it.");
                    overriddenByJson.remove(existingOverriddenKeyOrNull);
                    overriddenByJson.add(attribute);
                    continue;
                }
                overriddenByJson.add(attribute);
                continue;
            }
            json.put(key, attribute.getValue());
        }
        return new EnrichedJsonContainer(json, overriddenByJson);
    }

    @NotNull
    public static final List<EnrichmentAttribute> findExistingOverriddenKeys(@NotNull JSONObject json) {
        ArrayList<EnrichmentAttribute> arrayList;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JSONArray jSONArray = json.optJSONArray("dt.rum.overridden_keys");
        if (jSONArray == null) {
            return new ArrayList();
        }
        JSONArray overriddenKeysArray = jSONArray;
        ArrayList<EnrichmentAttribute> $this$findExistingOverriddenKeys_u24lambda_u241 = arrayList = new ArrayList<EnrichmentAttribute>();
        boolean bl = false;
        int n = overriddenKeysArray.length();
        for (int i = 0; i < n; ++i) {
            if (overriddenKeysArray.get(i) instanceof String) {
                String string = overriddenKeysArray.getString(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                $this$findExistingOverriddenKeys_u24lambda_u241.add(new EnrichmentAttribute(string, "unknown"));
                continue;
            }
            Utility.devLog("dtxEnrichment", "dropped existing overridden_key because it was no String: " + overriddenKeysArray.get(i));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JSONObject integrateOverriddenKeys(@NotNull EnrichedJsonContainer jsonContainer) {
        JSONObject jSONObject;
        List<EnrichmentAttribute> overriddenAttributes;
        Intrinsics.checkNotNullParameter((Object)jsonContainer, (String)"jsonContainer");
        JSONObject enrichedJson = jsonContainer.getEnrichedJson();
        if (enrichedJson.remove("dt.rum.overridden_keys") != null) {
            Utility.devLog("dtxEnrichment", "protected attribute integration: encountered key 'dt.rum.overridden_keys' which is protected and will be removed");
        }
        if (!((Collection)(overriddenAttributes = jsonContainer.getOverriddenAttributes())).isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = overriddenAttributes;
            String string = "dt.rum.overridden_keys";
            JSONObject jSONObject2 = enrichedJson;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EnrichmentAttribute enrichmentAttribute = (EnrichmentAttribute)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey());
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            JSONObject jSONObject3 = jSONObject2.put(string, (Object)new JSONArray(collection2));
            Intrinsics.checkNotNull((Object)jSONObject3);
            jSONObject = jSONObject3;
        } else {
            jSONObject = enrichedJson;
        }
        return jSONObject;
    }

    @NotNull
    public static final JSONObject integrateProtectedAttributes(@NotNull EnrichedJsonContainer jsonContainer, @NotNull Map<String, EnrichmentAttribute> protectedAttributes) {
        Intrinsics.checkNotNullParameter((Object)jsonContainer, (String)"jsonContainer");
        Intrinsics.checkNotNullParameter(protectedAttributes, (String)"protectedAttributes");
        JSONObject enrichedJson = jsonContainer.getEnrichedJson();
        for (Map.Entry<String, EnrichmentAttribute> entry : protectedAttributes.entrySet()) {
            String key = entry.getKey();
            EnrichmentAttribute protectedAttribute = entry.getValue();
            if (enrichedJson.has(key)) {
                Utility.devLog("dtxEnrichment", "protected attribute integration: encountered key '" + key + "' which is protected and will be overwritten with " + protectedAttribute);
            }
            enrichedJson.put(key, protectedAttribute.getValue());
        }
        return enrichedJson;
    }

    @Nullable
    public static final EnrichedJsonContainer applyModifications(@NotNull EnrichedJsonContainer enrichedJsonContainer, @Nullable Object[] eventContext, @NotNull ConcurrentLinkedQueue<EventModifier> modifiers) {
        Intrinsics.checkNotNullParameter((Object)enrichedJsonContainer, (String)"enrichedJsonContainer");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        if (modifiers.isEmpty()) {
            return enrichedJsonContainer;
        }
        StringBuilder stringBuilder = new StringBuilder().append("apply modifications: with ").append(modifiers.size()).append(" modifier(s); context: ");
        Object object = eventContext;
        if (eventContext == null || (object = ArraysKt.joinToString$default((Object[])object, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)applyModifications.1.INSTANCE, (int)24, null)) == null) {
            object = "null";
        }
        Utility.devLog("dtxEnrichment", stringBuilder.append((String)object).toString());
        JSONObject modifiableCopy = JsonObjectExtensionsKt.deepCopy(enrichedJsonContainer.getEnrichedJson());
        boolean modifierCausedException = false;
        for (EventModifier modifier : modifiers) {
            JSONObject jSONObject;
            try {
                jSONObject = modifier.modifyEvent(modifiableCopy, eventContext);
            }
            catch (Exception throwable) {
                Utility.devLog("dtxEnrichment", "apply modifications: event modifier caused exception");
                modifierCausedException = true;
                jSONObject = modifiableCopy;
            }
            if ((modifiableCopy = jSONObject) != null) continue;
            Utility.devLog("dtxEnrichment", "apply modifications: event dropped by event modifier");
            break;
        }
        return modifiableCopy == null ? null : EnrichmentPipelineKt.merge(enrichedJsonContainer, modifiableCopy, modifierCausedException);
    }

    @NotNull
    public static final List<AttributeSupplier> collectBasicMetricSuppliers(@NotNull AggregatedMetricsProviders metricsProviders) {
        Intrinsics.checkNotNullParameter((Object)metricsProviders, (String)"metricsProviders");
        FormattedBasicMetrics formattedBasicMetrics = new BasicMetricsFormatter(metricsProviders.getBasicMetrics()).collectFormattedMetrics();
        BasicMetricsSupplier basicMetricsSupplier = new BasicMetricsSupplier(formattedBasicMetrics);
        NetworkMetricsSupplier networkMetricsSupplier = new NetworkMetricsSupplier(metricsProviders.getNetworkMetrics());
        Object[] objectArray = new AttributeSupplier[]{basicMetricsSupplier, networkMetricsSupplier};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final EnrichedJsonContainer merge(EnrichedJsonContainer enrichedJsonContainer, JSONObject modifiableCopy, boolean modifierCausedException) {
        EnrichedJsonContainer enrichedJsonContainer2;
        if (JsonObjectExtensionsKt.hasCharacteristic(enrichedJsonContainer.getEnrichedJson(), "characteristics.has_session_properties")) {
            EnrichedJsonContainer enrichedJsonContainer3;
            EnrichedJsonContainer $this$merge_u24lambda_u243 = enrichedJsonContainer3 = new ModifiedJsonMergerV16(enrichedJsonContainer).merge(modifiableCopy);
            boolean bl = false;
            if (modifierCausedException) {
                $this$merge_u24lambda_u243.getEnrichedJson().put("dt.rum.api.has_enrich_exception", true);
            }
            enrichedJsonContainer2 = enrichedJsonContainer3;
        } else {
            EnrichedJsonContainer enrichedJsonContainer4;
            EnrichedJsonContainer $this$merge_u24lambda_u244 = enrichedJsonContainer4 = new ModifiedJsonMerger(enrichedJsonContainer).merge(modifiableCopy);
            boolean bl = false;
            if (modifierCausedException) {
                $this$merge_u24lambda_u244.getEnrichedJson().put("dt.rum.api.has_enrich_exception", true);
            }
            enrichedJsonContainer2 = enrichedJsonContainer4;
        }
        return enrichedJsonContainer2;
    }
}

