/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.exitreason.convertor;

import android.app.ApplicationExitInfo;
import com.dynatrace.agent.exitreason.convertor.JsonExitReasonEventConvertor;
import com.dynatrace.android.agent.util.Utility;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/agent/exitreason/convertor/JsonExitReasonEventConvertor;", "", "()V", "convertANR", "Lorg/json/JSONObject;", "applicationExitInfo", "Landroid/app/ApplicationExitInfo;", "convertNativeCrash", "extractNativeThreadsInfo", "", "tombstone", "LTombstone;", "extractThreadsInfo", "input", "generateBaseJson", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nJsonExitReasonEventConvertor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonExitReasonEventConvertor.kt\ncom/dynatrace/agent/exitreason/convertor/JsonExitReasonEventConvertor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n1#2:189\n216#3:190\n217#3:194\n1872#4,3:191\n*S KotlinDebug\n*F\n+ 1 JsonExitReasonEventConvertor.kt\ncom/dynatrace/agent/exitreason/convertor/JsonExitReasonEventConvertor\n*L\n151#1:190\n151#1:194\n154#1:191,3\n*E\n"})
public final class JsonExitReasonEventConvertor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JSONObject convertANR(@NotNull ApplicationExitInfo applicationExitInfo) {
        JSONObject jSONObject;
        block10: {
            Intrinsics.checkNotNullParameter((Object)applicationExitInfo, (String)"applicationExitInfo");
            Utility.devLog("dtxCrashTracker", "anr " + applicationExitInfo);
            try {
                InputStream inputStream;
                JSONObject jsonObject = this.generateBaseJson();
                jsonObject.put("characteristics.has_anr", true);
                if (applicationExitInfo.getDescription() != null) {
                    jsonObject.put("exception.message", (Object)applicationExitInfo.getDescription());
                }
                if ((inputStream = applicationExitInfo.getTraceInputStream()) == null) break block10;
                Closeable closeable = inputStream;
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    object2 = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object inputText = object2;
                String threadsInfo = this.extractThreadsInfo((String)inputText);
                if (((CharSequence)threadsInfo).length() > 0) {
                    jsonObject.put("exception.stack_trace", (Object)threadsInfo);
                } else {
                    Utility.devLog("dtxCrashTracker", "anr threads don't match pattern");
                }
            }
            catch (JSONException e) {
                Utility.devLog("dtxCrashTracker", "anr event cannot be created");
                jSONObject = null;
            }
        }
        return jSONObject;
    }

    @Nullable
    public final JSONObject convertNativeCrash(@NotNull ApplicationExitInfo applicationExitInfo) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)applicationExitInfo, (String)"applicationExitInfo");
        Utility.devLog("dtxCrashTracker", "native crash " + applicationExitInfo);
        try {
            JSONObject jsonObject = this.generateBaseJson();
            jsonObject.put("characteristics.has_crash", true);
            InputStream inputStream = applicationExitInfo.getTraceInputStream();
            String message = applicationExitInfo.getDescription();
            if (inputStream != null) {
                Tombstone tombstone = (Tombstone)((Object)Tombstone.ADAPTER.decode(inputStream));
                Signal signal = tombstone.getSignal_info();
                Intrinsics.checkNotNull((Object)((Object)signal));
                jsonObject.put("crash_signal_name", (Object)signal.getName());
                message = ((CharSequence)tombstone.getAbort_message()).length() > 0 ? tombstone.getAbort_message() : (!((Collection)tombstone.getCauses()).isEmpty() ? CollectionsKt.joinToString$default((Iterable)tombstone.getCauses(), (CharSequence)". ", null, null, (int)0, null, (Function1)convertNativeCrash.1.INSTANCE, (int)30, null) : message);
                String threadsInfo = this.extractNativeThreadsInfo(tombstone);
                if (((CharSequence)threadsInfo).length() > 0) {
                    jsonObject.put("exception.stack_trace", (Object)threadsInfo);
                } else {
                    Utility.devLog("dtxCrashTracker", "native crash threads cannot be extracted");
                }
            }
            if (message != null) {
                jsonObject.put("exception.message", (Object)message);
            }
        }
        catch (JSONException e) {
            Utility.devLog("dtxCrashTracker", "native crash event cannot be created");
            jSONObject = null;
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    private final String extractNativeThreadsInfo(Tombstone tombstone) {
        SortedMap sortedMap = MapsKt.toSortedMap(tombstone.getThreads());
        StringBuilder builder = new StringBuilder();
        builder.append("*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***");
        builder.append("\n");
        Map $this$forEach$iv = sortedMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Thread thread = (Thread)((Object)entry.getValue());
            builder.append(thread.getName() + ':');
            builder.append("\n");
            Iterable $this$forEachIndexed$iv = thread.getCurrent_backtrace();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void backtraceFrame;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BacktraceFrame backtraceFrame2 = (BacktraceFrame)((Object)item$iv);
                int index = n;
                boolean bl2 = false;
                builder.append("      #" + StringsKt.padStart((String)String.valueOf(index), (int)2, (char)'0') + " pc " + HexExtensionsKt.toHexString$default((long)backtraceFrame.getRel_pc(), null, (int)1, null) + ' ' + backtraceFrame.getFile_name() + " (" + backtraceFrame.getFunction_name() + '+' + backtraceFrame.getFunction_offset() + ") (BuildId: " + backtraceFrame.getBuild_id() + ')');
                builder.append("\n");
            }
            builder.append("\n");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String extractThreadsInfo(String input) {
        Regex regex = new Regex("(?ms)^\".*?(?=\\n\\s*(?:DumpLatency|\\s*$))");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)input, (int)0, (int)2, null), (Function1)extractThreadsInfo.1.INSTANCE), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final JSONObject generateBaseJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("characteristics.has_error", true);
        jsonObject.put("error.is_fatal", true);
        return jsonObject;
    }
}

