/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.useraction;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.dynatrace.agent.RumEventDispatcher;
import com.dynatrace.agent.common.time.TimeProvider;
import com.dynatrace.agent.metrics.AggregatedMetricsProviders;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.agent.useraction.OneAgentUserInteractionManager;
import com.dynatrace.agent.useraction.model.TouchAction;
import com.dynatrace.agent.useraction.model.TouchEvent;
import com.dynatrace.agent.useraction.model.TouchEventKt;
import com.dynatrace.agent.useraction.model.UserInteraction;
import com.dynatrace.agent.useraction.model.UserInteractionKt;
import com.dynatrace.agent.useraction.util.UserInteractionLogger;
import com.dynatrace.agent.useraction.util.UserInteractionUtilKt;
import com.dynatrace.agent.util.CoroutineHandler;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0017H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/dynatrace/agent/useraction/OneAgentUserInteractionManagerImpl;", "Lcom/dynatrace/agent/useraction/OneAgentUserInteractionManager;", "Lcom/dynatrace/agent/util/CoroutineHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "userInteractionLogger", "Lcom/dynatrace/agent/useraction/util/UserInteractionLogger;", "timeProvider", "Lcom/dynatrace/agent/common/time/TimeProvider;", "rumEventDispatcher", "Lcom/dynatrace/agent/RumEventDispatcher;", "metricsProviders", "Lcom/dynatrace/agent/metrics/AggregatedMetricsProviders;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/dynatrace/agent/useraction/util/UserInteractionLogger;Lcom/dynatrace/agent/common/time/TimeProvider;Lcom/dynatrace/agent/RumEventDispatcher;Lcom/dynatrace/agent/metrics/AggregatedMetricsProviders;)V", "touchEventJob", "Lkotlinx/coroutines/Job;", "touchList", "", "Lcom/dynatrace/agent/useraction/model/TouchEvent;", "addTouchEvent", "", "touchEvent", "createUserInteraction", "Lcom/dynatrace/agent/useraction/model/UserInteraction;", "rootView", "Landroid/view/ViewGroup;", "interactView", "Landroid/view/View;", "onMotionEvent", "event", "Landroid/view/MotionEvent;", "onViewClick", "view", "processTouchEventsWithNoInteraction", "track", "userInteraction", "Companion", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nOneAgentUserInteractionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OneAgentUserInteractionManagerImpl.kt\ncom/dynatrace/agent/useraction/OneAgentUserInteractionManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n774#2:111\n865#2,2:112\n774#2:114\n865#2,2:115\n*S KotlinDebug\n*F\n+ 1 OneAgentUserInteractionManagerImpl.kt\ncom/dynatrace/agent/useraction/OneAgentUserInteractionManagerImpl\n*L\n79#1:111\n79#1:112,2\n80#1:114\n80#1:115,2\n*E\n"})
public final class OneAgentUserInteractionManagerImpl
extends CoroutineHandler
implements OneAgentUserInteractionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserInteractionLogger userInteractionLogger;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final RumEventDispatcher rumEventDispatcher;
    @NotNull
    private final AggregatedMetricsProviders metricsProviders;
    @NotNull
    private final List<TouchEvent> touchList;
    @Nullable
    private Job touchEventJob;
    private static final long NO_INTERACTION_DELAY = 500L;

    public OneAgentUserInteractionManagerImpl(@NotNull CoroutineScope coroutineScope, @NotNull UserInteractionLogger userInteractionLogger, @NotNull TimeProvider timeProvider, @NotNull RumEventDispatcher rumEventDispatcher, @NotNull AggregatedMetricsProviders metricsProviders) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)userInteractionLogger, (String)"userInteractionLogger");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)rumEventDispatcher, (String)"rumEventDispatcher");
        Intrinsics.checkNotNullParameter((Object)metricsProviders, (String)"metricsProviders");
        super(coroutineScope);
        this.userInteractionLogger = userInteractionLogger;
        this.timeProvider = timeProvider;
        this.rumEventDispatcher = rumEventDispatcher;
        this.metricsProviders = metricsProviders;
        this.touchList = new ArrayList();
    }

    @Override
    public void onMotionEvent(@NotNull View rootView, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(rootView instanceof ViewGroup)) {
            return;
        }
        Job job = this.touchEventJob;
        boolean bl = job != null ? job.isActive() : false;
        if (bl) {
            this.processTouchEventsWithNoInteraction((ViewGroup)rootView);
        }
        float x = event.getX(0);
        float y = event.getY(0);
        this.addTouchEvent(new TouchEvent(UserInteractionUtilKt.getActionName(event), x, y));
        if (event.getAction() == 1) {
            this.touchEventJob = this.launchWithDelay(500L, (Function0<Unit>)((Function0)new Function0<Unit>(this, rootView){
                final /* synthetic */ OneAgentUserInteractionManagerImpl this$0;
                final /* synthetic */ View $rootView;
                {
                    this.this$0 = $receiver;
                    this.$rootView = $rootView;
                    super(0);
                }

                public final void invoke() {
                    OneAgentUserInteractionManagerImpl.access$processTouchEventsWithNoInteraction(this.this$0, (ViewGroup)this.$rootView);
                }
            }));
        }
    }

    @Override
    public void onViewClick(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Job job = this.touchEventJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        View view2 = view.getRootView();
        ViewGroup viewGroup = view2 instanceof ViewGroup ? (ViewGroup)view2 : null;
        if (viewGroup == null) {
            return;
        }
        ViewGroup rootView = viewGroup;
        UserInteraction userInteraction = this.createUserInteraction(rootView, view);
        if (userInteraction == null) {
            return;
        }
        UserInteraction userInteraction2 = userInteraction;
        this.userInteractionLogger.logUserInteraction(userInteraction2);
        this.track(userInteraction2);
        this.touchList.clear();
    }

    private final void processTouchEventsWithNoInteraction(ViewGroup rootView) {
        Job job = this.touchEventJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        UserInteraction userInteraction = this.createUserInteraction(rootView, null);
        if (userInteraction == null) {
            return;
        }
        UserInteraction userInteraction2 = userInteraction;
        this.userInteractionLogger.logUserInteraction(userInteraction2);
        this.track(userInteraction2);
        this.touchList.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final UserInteraction createUserInteraction(ViewGroup rootView, View interactView) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        TouchEvent touchEvent = (TouchEvent)CollectionsKt.lastOrNull(this.touchList);
        if (touchEvent == null) {
            return null;
        }
        TouchEvent lastMotionEvent = touchEvent;
        View topView = UserInteractionUtilKt.findTopView(rootView, (int)lastMotionEvent.getX(), (int)lastMotionEvent.getY());
        Iterable $this$filter$iv = this.touchList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            TouchEvent it = (TouchEvent)element$iv$iv;
            boolean bl = false;
            if (!(it.getAction() == TouchAction.MOVE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validMoveEvents = TouchEventKt.filterDistantTouches$default((List)destination$iv$iv, 0, 1, null);
        Iterable $this$filter$iv2 = this.touchList;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TouchEvent it = (TouchEvent)element$iv$iv;
            boolean bl = false;
            if (!(it.getAction() != TouchAction.MOVE || validMoveEvents.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List finalTouchEvents = (List)destination$iv$iv2;
        return new UserInteraction(finalTouchEvents, topView, interactView);
    }

    private final void track(UserInteraction userInteraction) {
        SessionInformationMetrics sessionInformationMetrics = this.metricsProviders.getBasicMetrics().getSessionForInternalEvent();
        if (sessionInformationMetrics.isGrailEventsCanBeCaptured()) {
            RumEventDispatcher rumEventDispatcher = this.rumEventDispatcher;
            JSONObject jSONObject = UserInteractionKt.toJSONObject(userInteraction);
            long l = this.timeProvider.millisSinceEpoch();
            rumEventDispatcher.dispatchEvent(jSONObject, l, 0L, sessionInformationMetrics, false, null);
        } else {
            Utility.devLog("dtxUserAction", "Touch UIA cannot be tracked, isGrailEventsCanBeCaptured == false");
        }
    }

    private final void addTouchEvent(TouchEvent touchEvent) {
        this.userInteractionLogger.logTouchEvent(touchEvent);
        this.touchList.add(touchEvent);
    }

    public static final /* synthetic */ void access$processTouchEventsWithNoInteraction(OneAgentUserInteractionManagerImpl $this, ViewGroup rootView) {
        $this.processTouchEventsWithNoInteraction(rootView);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/dynatrace/agent/useraction/OneAgentUserInteractionManagerImpl$Companion;", "", "()V", "NO_INTERACTION_DELAY", "", "com.dynatrace.agent_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

