/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.communication.network.response;

import com.dynatrace.agent.communication.LocalServerData;
import com.dynatrace.agent.communication.api.ServerDataUpdate;
import com.dynatrace.agent.communication.network.response.JsonExtensionKt;
import com.dynatrace.agent.communication.network.response.ParsedResponse;
import com.dynatrace.agent.communication.network.response.ServerConfigurationManagerV4;
import com.dynatrace.agent.storage.db.EndPointInfo;
import com.dynatrace.android.agent.conf.ReplayConfiguration;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.conf.ServerConfigurationParser;
import com.dynatrace.android.agent.util.Utility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J'\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/agent/communication/network/response/ConfigurationsParser;", "", "v3configParser", "Lcom/dynatrace/android/agent/conf/ServerConfigurationParser;", "v4configParser", "Lcom/dynatrace/agent/communication/network/response/ServerConfigurationManagerV4;", "(Lcom/dynatrace/android/agent/conf/ServerConfigurationParser;Lcom/dynatrace/agent/communication/network/response/ServerConfigurationManagerV4;)V", "fromJSON", "Lcom/dynatrace/android/agent/conf/ServerConfiguration;", "oldServerConfig", "json", "", "parse", "Lcom/dynatrace/agent/communication/api/ServerDataUpdate;", "jsonBody", "serverData", "Lcom/dynatrace/agent/communication/LocalServerData;", "endPointInfo", "Lcom/dynatrace/agent/storage/db/EndPointInfo;", "parse$com_dynatrace_agent_release", "com.dynatrace.agent_release"})
public final class ConfigurationsParser {
    @NotNull
    private final ServerConfigurationParser v3configParser;
    @NotNull
    private final ServerConfigurationManagerV4 v4configParser;

    public ConfigurationsParser(@NotNull ServerConfigurationParser v3configParser, @NotNull ServerConfigurationManagerV4 v4configParser) {
        Intrinsics.checkNotNullParameter((Object)v3configParser, (String)"v3configParser");
        Intrinsics.checkNotNullParameter((Object)v4configParser, (String)"v4configParser");
        this.v3configParser = v3configParser;
        this.v4configParser = v4configParser;
    }

    @Nullable
    public final ServerDataUpdate parse$com_dynatrace_agent_release(@NotNull String jsonBody, @NotNull LocalServerData serverData, @NotNull EndPointInfo endPointInfo) {
        ServerDataUpdate serverDataUpdate;
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        Intrinsics.checkNotNullParameter((Object)serverData, (String)"serverData");
        Intrinsics.checkNotNullParameter((Object)endPointInfo, (String)"endPointInfo");
        ParsedResponse response = this.v4configParser.parseResponseOrNull$com_dynatrace_agent_release(serverData.getConfig().getRevision(), endPointInfo.getApplicationId(), jsonBody);
        if (response == null) {
            serverDataUpdate = null;
        } else {
            ServerDataUpdate serverDataUpdate2;
            try {
                ServerConfiguration v3Config = this.fromJSON(serverData.getConfigV3(), jsonBody);
                serverDataUpdate2 = new ServerDataUpdate(response.getState(), response.getConfiguration(), v3Config);
            }
            catch (Exception e) {
                Utility.devLog("dtxCommunication", "config v3 parsing: invalid JSON", e);
                serverDataUpdate2 = null;
            }
            serverDataUpdate = serverDataUpdate2;
        }
        return serverDataUpdate;
    }

    private final ServerConfiguration fromJSON(ServerConfiguration oldServerConfig, String json) throws Exception {
        Object object = new JSONTokener(json).nextValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONObject");
        JSONObject rootObject = (JSONObject)object;
        JSONObject dynamicJsonObject = rootObject.getJSONObject("dynamicConfig");
        if (!dynamicJsonObject.has("bp3Config")) {
            Utility.devLog("dtxCommunication", "config v3 parsing: BPv3 config missing");
            return null;
        }
        boolean isFullConfig = rootObject.has("revision") && rootObject.has("appConfig") && rootObject.has("environmentConfig");
        ServerConfiguration.Builder newConfig = null;
        Long revision = JsonExtensionKt.getLongOrNull(rootObject, "revision");
        if (!isFullConfig || revision == null || revision <= oldServerConfig.getTimestamp()) {
            ServerConfiguration.Builder builder = oldServerConfig.newBuilder(true);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
            newConfig = builder;
        } else {
            ServerConfiguration.Builder builder = ServerConfiguration.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            newConfig = builder;
            newConfig.withTimestamp(revision);
            ReplayConfiguration.Builder replayConfigBuilder = ReplayConfiguration.builder();
            JSONObject agentJsonObject = rootObject.getJSONObject("environmentConfig").getJSONObject("bp3Config");
            this.v3configParser.parseMobileAgentConfigV3(newConfig, replayConfigBuilder, agentJsonObject);
            JSONObject appJsonObject = rootObject.getJSONObject("appConfig").getJSONObject("bp3Config");
            this.v3configParser.parseAppConfigV3(newConfig, replayConfigBuilder, appJsonObject);
            newConfig.withReplayConfiguration(replayConfigBuilder.build());
        }
        this.v3configParser.parseDynamicConfigV3(newConfig, dynamicJsonObject.getJSONObject("bp3Config"));
        return newConfig.build();
    }
}

