/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment;

import android.location.Location;
import com.dynatrace.agent.events.enrichment.AppMetrics;
import com.dynatrace.agent.events.enrichment.AppVersionMetrics;
import com.dynatrace.agent.events.enrichment.BasicMetricsFormatterKt;
import com.dynatrace.agent.events.enrichment.DeviceMetrics;
import com.dynatrace.agent.events.enrichment.FormattedBasicMetrics;
import com.dynatrace.agent.events.enrichment.GeoLocationMetrics;
import com.dynatrace.agent.events.enrichment.OperatingSystemMetrics;
import com.dynatrace.agent.metrics.AppVersion;
import com.dynatrace.agent.metrics.BasicMetricsProvider;
import com.dynatrace.agent.metrics.DynamicBasicMetrics;
import com.dynatrace.agent.metrics.StaticBasicMetrics;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/dynatrace/agent/events/enrichment/BasicMetricsFormatter;", "", "basicMetricsProvider", "Lcom/dynatrace/agent/metrics/BasicMetricsProvider;", "(Lcom/dynatrace/agent/metrics/BasicMetricsProvider;)V", "staticMetrics", "Lcom/dynatrace/agent/metrics/StaticBasicMetrics;", "collectFormattedMetrics", "Lcom/dynatrace/agent/events/enrichment/FormattedBasicMetrics;", "com.dynatrace.agent_release"})
public final class BasicMetricsFormatter {
    @NotNull
    private final BasicMetricsProvider basicMetricsProvider;
    @NotNull
    private final StaticBasicMetrics staticMetrics;

    public BasicMetricsFormatter(@NotNull BasicMetricsProvider basicMetricsProvider) {
        Intrinsics.checkNotNullParameter((Object)basicMetricsProvider, (String)"basicMetricsProvider");
        this.basicMetricsProvider = basicMetricsProvider;
        this.staticMetrics = this.basicMetricsProvider.obtainStaticBasicMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FormattedBasicMetrics collectFormattedMetrics() {
        GeoLocationMetrics geoLocationMetrics;
        AppVersionMetrics appVersionMetrics;
        AppVersion rawVersion;
        DynamicBasicMetrics dynamicMetrics = this.basicMetricsProvider.obtainDynamicBasicMetrics();
        Integer screenWidth = BasicMetricsFormatterKt.validScreenDimensionOrNull(dynamicMetrics.getDeviceScreenWidth());
        Integer screenHeight = BasicMetricsFormatterKt.validScreenDimensionOrNull(dynamicMetrics.getDeviceScreenHeight());
        boolean validDimensions = screenWidth != null && screenHeight != null;
        AppVersion appVersion = this.staticMetrics.getAppVersion();
        if (appVersion != null) {
            rawVersion = appVersion;
            boolean bl = false;
            appVersionMetrics = new AppVersionMetrics(String.valueOf(rawVersion.getVersionCode()), rawVersion.getVersionName());
        } else {
            appVersionMetrics = null;
        }
        AppVersionMetrics formattedVersion = appVersionMetrics;
        DeviceMetrics deviceMetrics = new DeviceMetrics(validDimensions ? screenWidth : null, validDimensions ? screenHeight : null, this.staticMetrics.getDeviceManufacturer(), this.staticMetrics.getDeviceModelIdentifier(), this.staticMetrics.getDeviceIsRooted(), BasicMetricsFormatterKt.toDeviceOrientation(dynamicMetrics.getDeviceOrientation()), BasicMetricsFormatterKt.validBatteryLevelOrNull(dynamicMetrics.getDeviceBatteryLevel()));
        OperatingSystemMetrics operatingSystemMetrics = new OperatingSystemMetrics(this.staticMetrics.getOsName(), this.staticMetrics.getOsVersion());
        AppMetrics appMetrics = new AppMetrics(formattedVersion, this.staticMetrics.getBundle());
        Location location = dynamicMetrics.getGeoLocation();
        if (location != null) {
            void location2;
            rawVersion = location;
            AppMetrics appMetrics2 = appMetrics;
            OperatingSystemMetrics operatingSystemMetrics2 = operatingSystemMetrics;
            DeviceMetrics deviceMetrics2 = deviceMetrics;
            boolean bl = false;
            GeoLocationMetrics geoLocationMetrics2 = new GeoLocationMetrics(new BigDecimal(location2.getLatitude()).setScale(2, RoundingMode.HALF_UP).doubleValue(), new BigDecimal(location2.getLongitude()).setScale(2, RoundingMode.HALF_UP).doubleValue());
            deviceMetrics = deviceMetrics2;
            operatingSystemMetrics = operatingSystemMetrics2;
            appMetrics = appMetrics2;
            geoLocationMetrics = geoLocationMetrics2;
        } else {
            geoLocationMetrics = null;
        }
        GeoLocationMetrics geoLocationMetrics3 = geoLocationMetrics;
        AppMetrics appMetrics3 = appMetrics;
        OperatingSystemMetrics operatingSystemMetrics3 = operatingSystemMetrics;
        DeviceMetrics deviceMetrics3 = deviceMetrics;
        return new FormattedBasicMetrics(deviceMetrics3, operatingSystemMetrics3, appMetrics3, geoLocationMetrics3);
    }
}

