/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment.merge;

import com.dynatrace.agent.events.enrichment.EnrichedJsonContainer;
import com.dynatrace.agent.events.enrichment.EnrichmentAttribute;
import com.dynatrace.agent.events.enrichment.JsonObjectExtensionsKt;
import com.dynatrace.agent.events.enrichment.sanitation.AttributeRetentionRule;
import com.dynatrace.agent.events.enrichment.sanitation.AttributeSanitizer;
import com.dynatrace.agent.events.enrichment.sanitation.JsonAttribute;
import com.dynatrace.agent.events.enrichment.sanitation.JsonAttributeKt;
import com.dynatrace.agent.events.enrichment.sanitation.JsonAttributeSanitationKt;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\fJ\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010%\u001a\u00020\u001aH\u0002J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180'*\u00020\f2\u0006\u0010 \u001a\u00020\fH\u0002J\u0014\u0010(\u001a\u00020\u0005*\u00020\u001c2\u0006\u0010)\u001a\u00020\fH\u0002J\f\u0010*\u001a\u00020\u0005*\u00020\u0013H\u0002J\u0014\u0010+\u001a\u00020\u0005*\u00020\u00132\u0006\u0010,\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/dynatrace/agent/events/enrichment/merge/ModifiedJsonMerger;", "", "baseJsonContainer", "Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;", "isSessionPropertiesEvent", "", "(Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;Z)V", "addedAttributes", "", "allowedNamespace", "Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeRetentionRule;", "baseJson", "Lorg/json/JSONObject;", "changedAttributeSanitizers", "", "Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeSanitizer;", "[Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeSanitizer;", "droppedAttributes", "", "", "isTooManyAttributesAdded", "()Z", "newAttributeSanitizers", "overriddenAttributes", "Lcom/dynatrace/agent/events/enrichment/EnrichmentAttribute;", "addNewAttribute", "", "sanitizedAttribute", "Lcom/dynatrace/agent/events/enrichment/sanitation/JsonAttribute;", "drop", "key", "merge", "modifiedJson", "mergeModifiedAttribute", "jsonAttribute", "mergeNewAttribute", "overwriteAttribute", "setHasDroppedFieldsFlag", "findRemovedAttributes", "", "hasChanged", "fromJson", "isAllowedToBeRemoved", "isNewTo", "jsonObject", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nModifiedJsonMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifiedJsonMerger.kt\ncom/dynatrace/agent/events/enrichment/merge/ModifiedJsonMerger\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1317#2,2:220\n1863#3,2:222\n*S KotlinDebug\n*F\n+ 1 ModifiedJsonMerger.kt\ncom/dynatrace/agent/events/enrichment/merge/ModifiedJsonMerger\n*L\n96#1:220,2\n205#1:222,2\n*E\n"})
public final class ModifiedJsonMerger {
    private final boolean isSessionPropertiesEvent;
    @NotNull
    private final JSONObject baseJson;
    @NotNull
    private final List<EnrichmentAttribute> overriddenAttributes;
    @NotNull
    private final List<String> droppedAttributes;
    private int addedAttributes;
    @NotNull
    private final AttributeRetentionRule allowedNamespace;
    @NotNull
    private final AttributeSanitizer[] changedAttributeSanitizers;
    @NotNull
    private final AttributeSanitizer[] newAttributeSanitizers;

    public ModifiedJsonMerger(@NotNull EnrichedJsonContainer baseJsonContainer, boolean isSessionPropertiesEvent) {
        Intrinsics.checkNotNullParameter((Object)baseJsonContainer, (String)"baseJsonContainer");
        this.isSessionPropertiesEvent = isSessionPropertiesEvent;
        this.baseJson = baseJsonContainer.getEnrichedJson();
        this.overriddenAttributes = CollectionsKt.toMutableList((Collection)baseJsonContainer.getOverriddenAttributes());
        this.droppedAttributes = new ArrayList();
        this.allowedNamespace = this.isSessionPropertiesEvent ? JsonAttributeSanitationKt.getSessionPropertiesNamespace() : JsonAttributeSanitationKt.getEventPropertiesNamespace();
        AttributeSanitizer[] attributeSanitizerArray = new AttributeSanitizer[3];
        AttributeRetentionRule[] attributeRetentionRuleArray = new AttributeRetentionRule[]{this.allowedNamespace, JsonAttributeSanitationKt.getFieldsAllowedInModificationApi()};
        attributeSanitizerArray[0] = JsonAttributeSanitationKt.removeAllAttributes(attributeRetentionRuleArray);
        attributeSanitizerArray[1] = JsonAttributeSanitationKt.getRemoveNestedJsonObjectAndArrays();
        attributeSanitizerArray[2] = JsonAttributeSanitationKt.getTrimTooLongStringValues();
        this.changedAttributeSanitizers = attributeSanitizerArray;
        attributeSanitizerArray = new AttributeSanitizer[5];
        attributeRetentionRuleArray = new AttributeRetentionRule[]{this.allowedNamespace};
        attributeSanitizerArray[0] = JsonAttributeSanitationKt.removeAllAttributes(attributeRetentionRuleArray);
        attributeSanitizerArray[1] = JsonAttributeSanitationKt.getRemoveAttributeWithExceedingKeySize();
        attributeSanitizerArray[2] = JsonAttributeSanitationKt.getRemoveAttributesWithInvalidKeys();
        attributeSanitizerArray[3] = JsonAttributeSanitationKt.getRemoveNestedJsonObjectAndArrays();
        attributeSanitizerArray[4] = JsonAttributeSanitationKt.getTrimTooLongStringValues();
        this.newAttributeSanitizers = attributeSanitizerArray;
    }

    private final boolean isTooManyAttributesAdded() {
        return this.addedAttributes >= 50;
    }

    @NotNull
    public final EnrichedJsonContainer merge(@NotNull JSONObject modifiedJson) {
        Intrinsics.checkNotNullParameter((Object)modifiedJson, (String)"modifiedJson");
        this.overriddenAttributes.addAll((Collection<EnrichmentAttribute>)this.findRemovedAttributes(this.baseJson, modifiedJson));
        Iterator iterator = modifiedJson.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Sequence $this$forEach$iv = SequencesKt.sorted((Sequence)SequencesKt.asSequence((Iterator)iterator));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            Object object = modifiedJson.get(key);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Object copiedValue = JsonObjectExtensionsKt.copyJsonValue(object);
            Intrinsics.checkNotNull((Object)key);
            JsonAttribute attribute = new JsonAttribute(key, copiedValue);
            if (this.isNewTo(key, this.baseJson)) {
                this.mergeNewAttribute(attribute);
                continue;
            }
            this.mergeModifiedAttribute(attribute);
        }
        this.setHasDroppedFieldsFlag();
        return new EnrichedJsonContainer(this.baseJson, this.overriddenAttributes);
    }

    private final void mergeNewAttribute(JsonAttribute jsonAttribute) {
        block3: {
            Unit unit;
            block2: {
                if (!this.isTooManyAttributesAdded()) break block2;
                Utility.devLog("dtxEnrichment", "merge modifications: adding more than 50 attributes using event modifiers is not allowed; dropping: '" + jsonAttribute.getKey() + '\'');
                this.drop(jsonAttribute.getKey());
                break block3;
            }
            JsonAttribute jsonAttribute2 = JsonAttributeKt.applySanitizers(jsonAttribute, this.newAttributeSanitizers);
            if (jsonAttribute2 != null) {
                JsonAttribute sanitizedAttribute = jsonAttribute2;
                boolean bl = false;
                this.addNewAttribute(sanitizedAttribute);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            ModifiedJsonMerger $this$mergeNewAttribute_u24lambda_u242 = this;
            boolean bl = false;
            $this$mergeNewAttribute_u24lambda_u242.drop(jsonAttribute.getKey());
        }
    }

    private final void mergeModifiedAttribute(JsonAttribute jsonAttribute) {
        block3: {
            Unit unit;
            if (!this.hasChanged(jsonAttribute, this.baseJson)) break block3;
            JsonAttribute jsonAttribute2 = JsonAttributeKt.applySanitizers(jsonAttribute, this.changedAttributeSanitizers);
            if (jsonAttribute2 != null) {
                JsonAttribute sanitizedAttribute = jsonAttribute2;
                boolean bl = false;
                this.overwriteAttribute(jsonAttribute.getKey(), sanitizedAttribute);
                Utility.devLog("dtxEnrichment", "merge modifications: attribute '" + jsonAttribute.getKey() + "' is overwritten by " + sanitizedAttribute);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                ModifiedJsonMerger $this$mergeModifiedAttribute_u24lambda_u244 = this;
                boolean bl = false;
                $this$mergeModifiedAttribute_u24lambda_u244.drop(jsonAttribute.getKey());
            }
        }
    }

    private final void setHasDroppedFieldsFlag() {
        boolean alreadyHasDroppedFields = this.baseJson.optBoolean("dt.rum.api.has_dropped_fields");
        if (!((Collection)this.droppedAttributes).isEmpty() || alreadyHasDroppedFields) {
            this.baseJson.put("dt.rum.api.has_dropped_fields", true);
        }
    }

    private final void drop(String key) {
        this.droppedAttributes.add(key);
    }

    private final void addNewAttribute(JsonAttribute sanitizedAttribute) {
        JsonObjectExtensionsKt.put(this.baseJson, sanitizedAttribute);
        int n = this.addedAttributes;
        this.addedAttributes = n + 1;
    }

    private final void overwriteAttribute(String key, JsonAttribute sanitizedAttribute) {
        Object object = this.baseJson.get(key);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        EnrichmentAttribute existingAttribute = new EnrichmentAttribute(key, object);
        JsonObjectExtensionsKt.put(this.baseJson, sanitizedAttribute);
        this.overriddenAttributes.add(existingAttribute);
    }

    private final boolean isNewTo(String $this$isNewTo, JSONObject jsonObject) {
        return !jsonObject.has($this$isNewTo);
    }

    private final boolean hasChanged(JsonAttribute $this$hasChanged, JSONObject fromJson) {
        return !Intrinsics.areEqual((Object)fromJson.get($this$hasChanged.getKey()), (Object)$this$hasChanged.getValue());
    }

    private final List<EnrichmentAttribute> findRemovedAttributes(JSONObject $this$findRemovedAttributes, JSONObject modifiedJson) {
        List overriddenAttributes = new ArrayList();
        List keysToRemove = new ArrayList();
        Iterator iterator = $this$findRemovedAttributes.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            if (modifiedJson.has(key)) continue;
            Intrinsics.checkNotNull((Object)key);
            if (this.isAllowedToBeRemoved(key)) {
                Object object = $this$findRemovedAttributes.get(key);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                EnrichmentAttribute attribute = new EnrichmentAttribute(key, object);
                overriddenAttributes.add(attribute);
                keysToRemove.add(key);
                Utility.devLog("dtxEnrichment", "merge modifications: attribute '" + key + "' has been removed by event modifier");
                continue;
            }
            Utility.devLog("dtxEnrichment", "merge modifications: removing of protected attribute '" + key + "' is not allowed and thus ignored");
        }
        Iterable $this$forEach$iv = keysToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            $this$findRemovedAttributes.remove(key);
        }
        return overriddenAttributes;
    }

    private final boolean isAllowedToBeRemoved(String $this$isAllowedToBeRemoved) {
        return this.isSessionPropertiesEvent ? StringsKt.startsWith$default((String)$this$isAllowedToBeRemoved, (String)"session_properties.", (boolean)false, (int)2, null) : StringsKt.startsWith$default((String)$this$isAllowedToBeRemoved, (String)"event_properties.", (boolean)false, (int)2, null);
    }
}

