/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment.sanitation;

import com.dynatrace.agent.events.enrichment.sanitation.AttributeRetentionRule;
import com.dynatrace.agent.events.enrichment.sanitation.AttributeSanitizer;
import com.dynatrace.agent.events.enrichment.sanitation.JsonAttribute;
import com.dynatrace.agent.events.enrichment.sanitation.SanitationContext;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001b\u0010!\u001a\u00020\u00162\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050#H\u0000\u00a2\u0006\u0002\u0010$\u001a\f\u0010%\u001a\u00020&*\u00020'H\u0002\u001a\f\u0010(\u001a\u00020)*\u00020)H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0014\u0010\n\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0014\u0010\u0019\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\"\u0014\u0010\u001b\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0014\u0010\u001d\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0007\"\u0014\u0010\u001f\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018\u00a8\u0006*"}, d2={"JSON_CUSTOM_FIELD_LIMIT", "", "MAX_ATTRIBUTE_KEY_SIZE", "MAX_STRING_VALUE_SIZE", "eventPropertiesNamespace", "Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeRetentionRule;", "getEventPropertiesNamespace", "()Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeRetentionRule;", "fieldsAllowedInGenerationApi", "getFieldsAllowedInGenerationApi", "fieldsAllowedInModificationApi", "getFieldsAllowedInModificationApi", "generationApiFields", "", "", "getGenerationApiFields", "()Ljava/util/List;", "keyRegex", "Lkotlin/text/Regex;", "modificationApiFields", "getModificationApiFields", "removeAttributeWithExceedingKeySize", "Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeSanitizer;", "getRemoveAttributeWithExceedingKeySize", "()Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeSanitizer;", "removeAttributesWithInvalidKeys", "getRemoveAttributesWithInvalidKeys", "removeNestedJsonObjectAndArrays", "getRemoveNestedJsonObjectAndArrays", "sessionPropertiesNamespace", "getSessionPropertiesNamespace", "trimTooLongStringValues", "getTrimTooLongStringValues", "removeAllAttributes", "keep", "", "([Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeRetentionRule;)Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeSanitizer;", "isPrimitive", "", "", "trimFields", "Lcom/dynatrace/agent/events/enrichment/sanitation/SanitationContext;", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nJsonAttributeSanitation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonAttributeSanitation.kt\ncom/dynatrace/agent/events/enrichment/sanitation/JsonAttributeSanitationKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,215:1\n12574#2,2:216\n*S KotlinDebug\n*F\n+ 1 JsonAttributeSanitation.kt\ncom/dynatrace/agent/events/enrichment/sanitation/JsonAttributeSanitationKt\n*L\n165#1:216,2\n*E\n"})
public final class JsonAttributeSanitationKt {
    private static final int MAX_ATTRIBUTE_KEY_SIZE = 100;
    private static final int MAX_STRING_VALUE_SIZE = 5000;
    public static final int JSON_CUSTOM_FIELD_LIMIT = 50;
    @NotNull
    private static final Regex keyRegex = new Regex("^[a-z0-9]+(?:\\.[a-z][a-z0-9]*|_[a-z0-9]+)*$");
    @NotNull
    private static final List<String> generationApiFields = CollectionsKt.listOf((Object)"duration");
    @NotNull
    private static final List<String> modificationApiFields;
    @NotNull
    private static final AttributeRetentionRule sessionPropertiesNamespace;
    @NotNull
    private static final AttributeRetentionRule eventPropertiesNamespace;
    @NotNull
    private static final AttributeRetentionRule fieldsAllowedInGenerationApi;
    @NotNull
    private static final AttributeRetentionRule fieldsAllowedInModificationApi;
    @NotNull
    private static final AttributeSanitizer removeNestedJsonObjectAndArrays;
    @NotNull
    private static final AttributeSanitizer removeAttributeWithExceedingKeySize;
    @NotNull
    private static final AttributeSanitizer removeAttributesWithInvalidKeys;
    @NotNull
    private static final AttributeSanitizer trimTooLongStringValues;

    @NotNull
    public static final List<String> getGenerationApiFields() {
        return generationApiFields;
    }

    @NotNull
    public static final List<String> getModificationApiFields() {
        return modificationApiFields;
    }

    @NotNull
    public static final AttributeRetentionRule getSessionPropertiesNamespace() {
        return sessionPropertiesNamespace;
    }

    @NotNull
    public static final AttributeRetentionRule getEventPropertiesNamespace() {
        return eventPropertiesNamespace;
    }

    @NotNull
    public static final AttributeRetentionRule getFieldsAllowedInGenerationApi() {
        return fieldsAllowedInGenerationApi;
    }

    @NotNull
    public static final AttributeRetentionRule getFieldsAllowedInModificationApi() {
        return fieldsAllowedInModificationApi;
    }

    @NotNull
    public static final AttributeSanitizer getRemoveNestedJsonObjectAndArrays() {
        return removeNestedJsonObjectAndArrays;
    }

    @NotNull
    public static final AttributeSanitizer getRemoveAttributeWithExceedingKeySize() {
        return removeAttributeWithExceedingKeySize;
    }

    @NotNull
    public static final AttributeSanitizer getRemoveAttributesWithInvalidKeys() {
        return removeAttributesWithInvalidKeys;
    }

    @NotNull
    public static final AttributeSanitizer getTrimTooLongStringValues() {
        return trimTooLongStringValues;
    }

    @NotNull
    public static final AttributeSanitizer removeAllAttributes(@NotNull AttributeRetentionRule[] keep) {
        Intrinsics.checkNotNullParameter((Object)keep, (String)"keep");
        return arg_0 -> JsonAttributeSanitationKt.removeAllAttributes$lambda$9(keep, arg_0);
    }

    @NotNull
    public static final SanitationContext trimFields(@NotNull SanitationContext $this$trimFields) {
        Intrinsics.checkNotNullParameter((Object)$this$trimFields, (String)"<this>");
        Iterator iterator = $this$trimFields.getSanitizedJson().keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        List sortedList = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.asSequence((Iterator)iterator), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)a;
                boolean bl = false;
                Comparable comparable = Intrinsics.areEqual((Object)it, (Object)"start_time") || Intrinsics.areEqual((Object)it, (Object)"duration") ? (Comparable)((Object)"") : (Comparable)((Object)it);
                it = (String)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(Intrinsics.areEqual((Object)it, (Object)"start_time") || Intrinsics.areEqual((Object)it, (Object)"duration") ? (Comparable)((Object)"") : (Comparable)((Object)it)));
            }
        }));
        if (sortedList.size() > 50) {
            ArrayList<JsonAttribute> overflowingAttributes = new ArrayList<JsonAttribute>();
            ListIterator listIterator = sortedList.listIterator(50);
            while (listIterator.hasNext()) {
                Object removedValue;
                String key = (String)listIterator.next();
                Intrinsics.checkNotNull((Object)$this$trimFields.getSanitizedJson().remove(key));
                Intrinsics.checkNotNull((Object)key);
                overflowingAttributes.add(new JsonAttribute(key, removedValue));
            }
            Utility.devLog("dtxEnrichment", "sanitation: json contains too many attributes: " + sortedList.size() + "; dropped attributes: " + overflowingAttributes);
            $this$trimFields.getDroppedAttributes().addAll((Collection<JsonAttribute>)overflowingAttributes);
        }
        return $this$trimFields;
    }

    private static final boolean isPrimitive(Object $this$isPrimitive) {
        return $this$isPrimitive instanceof Integer || $this$isPrimitive instanceof Long || $this$isPrimitive instanceof Float || $this$isPrimitive instanceof Double || $this$isPrimitive instanceof Boolean;
    }

    private static final boolean sessionPropertiesNamespace$lambda$0(JsonAttribute jsonAttribute) {
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        return StringsKt.startsWith$default((String)jsonAttribute.getKey(), (String)"session_properties.", (boolean)false, (int)2, null);
    }

    private static final boolean eventPropertiesNamespace$lambda$1(JsonAttribute jsonAttribute) {
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        return StringsKt.startsWith$default((String)jsonAttribute.getKey(), (String)"event_properties.", (boolean)false, (int)2, null);
    }

    private static final boolean fieldsAllowedInGenerationApi$lambda$2(JsonAttribute jsonAttribute) {
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        return generationApiFields.contains(jsonAttribute.getKey());
    }

    private static final boolean fieldsAllowedInModificationApi$lambda$3(JsonAttribute jsonAttribute) {
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        return modificationApiFields.contains(jsonAttribute.getKey());
    }

    private static final JsonAttribute removeNestedJsonObjectAndArrays$lambda$4(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        if (jsonAttribute.getValue() instanceof JSONObject || jsonAttribute.getValue() instanceof JSONArray) {
            Utility.devLog("dtxEnrichment", "sanitation: key '" + jsonAttribute.getKey() + "' is a nested object or array and thus dropped");
            jsonAttribute2 = null;
        } else {
            jsonAttribute2 = jsonAttribute;
        }
        return jsonAttribute2;
    }

    private static final JsonAttribute removeAttributeWithExceedingKeySize$lambda$5(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        if (jsonAttribute.getKey().length() > 100) {
            Utility.devLog("dtxEnrichment", "sanitation: dropped a key because it was too long; limit: 100; actual length: " + jsonAttribute.getKey().length() + "; key: '" + jsonAttribute.getKey() + '\'');
            jsonAttribute2 = null;
        } else {
            jsonAttribute2 = jsonAttribute;
        }
        return jsonAttribute2;
    }

    private static final JsonAttribute removeAttributesWithInvalidKeys$lambda$6(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        MatchResult match = keyRegex.matchEntire((CharSequence)jsonAttribute.getKey());
        if (match == null) {
            Utility.devLog("dtxEnrichment", "sanitation: dropped a key because it does not conform to expected pattern; key: " + jsonAttribute.getKey());
            jsonAttribute2 = null;
        } else {
            jsonAttribute2 = jsonAttribute;
        }
        return jsonAttribute2;
    }

    private static final JsonAttribute trimTooLongStringValues$lambda$7(JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        Object value = jsonAttribute.getValue();
        if (JsonAttributeSanitationKt.isPrimitive(value)) {
            return jsonAttribute;
        }
        String stringified = jsonAttribute.getValue().toString();
        if (stringified.length() < 5000) {
            jsonAttribute2 = jsonAttribute;
        } else {
            Utility.devLog("dtxEnrichment", "sanitation: value of key '" + jsonAttribute.getKey() + "' is too long and thus is trimmed; original length: " + stringified.length() + "; ");
            String truncatedValue = StringsKt.take((String)stringified, (int)5000);
            jsonAttribute2 = new JsonAttribute(jsonAttribute.getKey(), truncatedValue);
        }
        return jsonAttribute2;
    }

    private static final JsonAttribute removeAllAttributes$lambda$9(AttributeRetentionRule[] $keep, JsonAttribute jsonAttribute) {
        JsonAttribute jsonAttribute2;
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$keep, (String)"$keep");
            Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
            AttributeRetentionRule[] $this$any$iv = $keep;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                AttributeRetentionRule element$iv;
                AttributeRetentionRule rule = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!rule.shouldKeep(jsonAttribute)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            jsonAttribute2 = jsonAttribute;
        } else {
            Utility.devLog("dtxEnrichment", "sanitation: key '" + jsonAttribute.getKey() + "' is outside of allowed namespace and thus dropped");
            jsonAttribute2 = null;
        }
        return jsonAttribute2;
    }

    static {
        Object[] objectArray = new String[]{"url.full", "exception.stack_trace"};
        modificationApiFields = CollectionsKt.listOf((Object[])objectArray);
        sessionPropertiesNamespace = JsonAttributeSanitationKt::sessionPropertiesNamespace$lambda$0;
        eventPropertiesNamespace = JsonAttributeSanitationKt::eventPropertiesNamespace$lambda$1;
        fieldsAllowedInGenerationApi = JsonAttributeSanitationKt::fieldsAllowedInGenerationApi$lambda$2;
        fieldsAllowedInModificationApi = JsonAttributeSanitationKt::fieldsAllowedInModificationApi$lambda$3;
        removeNestedJsonObjectAndArrays = JsonAttributeSanitationKt::removeNestedJsonObjectAndArrays$lambda$4;
        removeAttributeWithExceedingKeySize = JsonAttributeSanitationKt::removeAttributeWithExceedingKeySize$lambda$5;
        removeAttributesWithInvalidKeys = JsonAttributeSanitationKt::removeAttributesWithInvalidKeys$lambda$6;
        trimTooLongStringValues = JsonAttributeSanitationKt::trimTooLongStringValues$lambda$7;
    }
}

