/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.exitreason.convertor;

import android.app.ApplicationExitInfo;
import androidx.annotation.RequiresApi;
import com.dynatrace.agent.exitreason.convertor.ExitReasonConverter;
import com.dynatrace.android.agent.util.Utility;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0002J\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0001\u00a2\u0006\u0002\b\u0011J,\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013*\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0019\u001a\u00020\u0018*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0002J(\u0010\u001b\u001a\u00020\u0018*\u00020\u00042\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u001e\u001a\u00020\tH\u0002J\u0014\u0010\u001f\u001a\u00020\u0018*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010 \u001a\u00020\u0018*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006!"}, d2={"Lcom/dynatrace/agent/exitreason/convertor/ExitReasonConverter;", "", "()V", "convertAnr", "Lorg/json/JSONObject;", "applicationExitInfo", "Landroid/app/ApplicationExitInfo;", "convertNativeCrash", "extractNativeThreadsInfo", "", "tombstone", "LTombstone;", "extractThreadsInfo", "input", "generateBaseJson", "parseNativeCrash", "exitInfoDescription", "parseNativeCrash$com_dynatrace_agent_release", "moveRootThreadToTop", "", "", "LThread;", "keyToMove", "putExceptionType", "", "putMessage", "fallbackMessage", "putOptional", "key", "optionalValue", "droppedLog", "putSignalCrashName", "putStackTrace", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nExitReasonConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExitReasonConverter.kt\ncom/dynatrace/agent/exitreason/convertor/ExitReasonConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,296:1\n1#2:297\n216#3:298\n217#3:302\n1872#4,3:299\n*S KotlinDebug\n*F\n+ 1 ExitReasonConverter.kt\ncom/dynatrace/agent/exitreason/convertor/ExitReasonConverter\n*L\n241#1:298\n241#1:302\n244#1:299,3\n*E\n"})
public final class ExitReasonConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=30)
    @Nullable
    public final JSONObject convertAnr(@NotNull ApplicationExitInfo applicationExitInfo) {
        JSONObject jSONObject;
        block10: {
            Intrinsics.checkNotNullParameter((Object)applicationExitInfo, (String)"applicationExitInfo");
            Utility.devLog("dtxCrashTracker", "anr " + applicationExitInfo);
            try {
                InputStream inputStream;
                JSONObject jsonObject = this.generateBaseJson();
                jsonObject.put("characteristics.has_anr", true);
                if (applicationExitInfo.getDescription() != null) {
                    jsonObject.put("exception.message", (Object)applicationExitInfo.getDescription());
                }
                if ((inputStream = applicationExitInfo.getTraceInputStream()) == null) break block10;
                Closeable closeable = inputStream;
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    object2 = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object inputText = object2;
                String threadsInfo = this.extractThreadsInfo((String)inputText);
                if (((CharSequence)threadsInfo).length() > 0) {
                    jsonObject.put("exception.stack_trace", (Object)threadsInfo);
                } else {
                    Utility.devLog("dtxCrashTracker", "anr threads don't match pattern");
                }
            }
            catch (JSONException e) {
                Utility.devLog("dtxCrashTracker", "anr event cannot be created");
                jSONObject = null;
            }
        }
        return jSONObject;
    }

    @RequiresApi(value=30)
    @Nullable
    public final JSONObject convertNativeCrash(@NotNull ApplicationExitInfo applicationExitInfo) {
        Intrinsics.checkNotNullParameter((Object)applicationExitInfo, (String)"applicationExitInfo");
        Utility.devLog("dtxCrashTracker", "native crash " + applicationExitInfo);
        try {
            JSONObject jSONObject;
            Tombstone tombstone;
            Tombstone tombstone2;
            InputStream inputStream = applicationExitInfo.getTraceInputStream();
            if (inputStream != null) {
                InputStream stream = inputStream;
                boolean bl = false;
                tombstone2 = (Tombstone)((Object)Tombstone.ADAPTER.decode(stream));
            } else {
                tombstone2 = tombstone = null;
            }
            if (tombstone != null) {
                jSONObject = this.parseNativeCrash$com_dynatrace_agent_release(tombstone, applicationExitInfo.getDescription());
            } else {
                JSONObject jSONObject2;
                JSONObject $this$convertNativeCrash_u24lambda_u242 = jSONObject2 = this.generateBaseJson();
                boolean bl = false;
                $this$convertNativeCrash_u24lambda_u242.put("characteristics.has_crash", true);
                this.putOptional($this$convertNativeCrash_u24lambda_u242, "exception.message", applicationExitInfo.getDescription(), "applicationExitInfo.description is null");
                jSONObject = jSONObject2;
            }
            return jSONObject;
        }
        catch (Exception e) {
            Utility.devLog("dtxCrashTracker", "native crash event cannot be created");
            return null;
        }
    }

    @RequiresApi(value=30)
    @NotNull
    public final JSONObject parseNativeCrash$com_dynatrace_agent_release(@NotNull Tombstone tombstone, @Nullable String exitInfoDescription) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)((Object)tombstone), (String)"tombstone");
        JSONObject $this$parseNativeCrash_u24lambda_u243 = jSONObject = this.generateBaseJson();
        boolean bl = false;
        $this$parseNativeCrash_u24lambda_u243.put("characteristics.has_crash", true);
        this.putMessage($this$parseNativeCrash_u24lambda_u243, tombstone, exitInfoDescription);
        this.putSignalCrashName($this$parseNativeCrash_u24lambda_u243, tombstone);
        this.putExceptionType($this$parseNativeCrash_u24lambda_u243, tombstone);
        this.putStackTrace($this$parseNativeCrash_u24lambda_u243, tombstone);
        return jSONObject;
    }

    private final void putMessage(JSONObject $this$putMessage, Tombstone tombstone, String fallbackMessage) {
        Object object;
        String message2 = ((CharSequence)tombstone.getAbort_message()).length() > 0 ? tombstone.getAbort_message() : (!((Collection)tombstone.getCauses()).isEmpty() ? CollectionsKt.joinToString$default((Iterable)tombstone.getCauses(), (CharSequence)". ", null, null, (int)0, null, (Function1)putMessage.message.1.INSTANCE, (int)30, null) : (((object = tombstone.getSignal_info()) != null && (object = object.getName()) != null ? ((CharSequence)object).length() > 0 : false) ? tombstone.getSignal_info().getName() : (tombstone.getSignal_info() != null && tombstone.getSignal_info().getNumber() != 0 ? "signal " + tombstone.getSignal_info().getNumber() : fallbackMessage)));
        ExitReasonConverter.putOptional$default(this, $this$putMessage, "exception.message", message2, null, 4, null);
    }

    private final void putSignalCrashName(JSONObject $this$putSignalCrashName, Tombstone tombstone) {
        String string;
        Signal signal = tombstone.getSignal_info();
        if (signal != null) {
            Signal signalInfo = signal;
            boolean bl = false;
            string = ((CharSequence)signalInfo.getName()).length() > 0 ? signalInfo.getName() : (signalInfo.getNumber() != 0 ? "signal " + signalInfo.getNumber() : null);
        } else {
            string = null;
        }
        String signalName = string;
        ExitReasonConverter.putOptional$default(this, $this$putSignalCrashName, "crash_signal_name", signalName, null, 4, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void putExceptionType(JSONObject $this$putExceptionType, Tombstone tombstone) {
        prefix = "terminating with uncaught exception of type ";
        it = var6_4 = tombstone.getAbort_message();
        $i$a$-takeIf-ExitReasonConverter$putExceptionType$exceptionType$1 = false;
        v0 = var5_7 = (((CharSequence)it).length() > 0 != false && StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null) != false) != false ? var6_4 : null;
        if (var5_7 == null) ** GOTO lbl-1000
        v1 = var5_7.substring(prefix.length());
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
        var6_4 = v1;
        if (var6_4 != null) {
            v2 = StringsKt.substringBefore$default((String)var6_4, (String)": ", null, (int)2, null);
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        exceptionType = v2;
        ExitReasonConverter.putOptional$default(this, $this$putExceptionType, "exception.type", exceptionType, null, 4, null);
    }

    private final void putStackTrace(JSONObject $this$putStackTrace, Tombstone tombstone) {
        this.putOptional($this$putStackTrace, "exception.stack_trace", this.extractNativeThreadsInfo(tombstone), "native crash threads cannot be extracted");
    }

    private final void putOptional(JSONObject $this$putOptional, String key, String optionalValue, String droppedLog) {
        if (optionalValue == null) {
            Utility.devLog("dtxCrashTracker", droppedLog);
        } else {
            $this$putOptional.put(key, (Object)optionalValue);
        }
    }

    static /* synthetic */ void putOptional$default(ExitReasonConverter exitReasonConverter, JSONObject jSONObject, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "key " + string + " dropped because extracted value is 'null'";
        }
        exitReasonConverter.putOptional(jSONObject, string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    private final String extractNativeThreadsInfo(Tombstone tombstone) {
        Map<Integer, Thread> threads = tombstone.getThreads();
        if (threads.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***");
        builder.append("\n");
        builder.append("ABI: " + tombstone.getArch().name());
        builder.append("\n");
        builder.append("Process uptime: " + tombstone.getProcess_uptime() + 's');
        builder.append("\n");
        if (!((Collection)tombstone.getCommand_line()).isEmpty()) {
            builder.append("Cmdline: " + tombstone.getCommand_line());
            builder.append("\n");
        }
        Thread thread = threads.get(tombstone.getTid());
        builder.append("pid: " + tombstone.getPid() + ", tid: " + tombstone.getTid() + ", name: " + (thread != null ? thread.getName() : null));
        builder.append("\n");
        Signal signal = tombstone.getSignal_info();
        if (signal != null) {
            Signal signal2 = signal;
            boolean bl = false;
            builder.append("signal " + signal2.getNumber() + " (" + signal2.getName() + "), code " + signal2.getCode() + " (" + signal2.getCode_name() + "), fault addr " + HexExtensionsKt.toHexString$default((long)signal2.getFault_address(), null, (int)1, null));
            builder.append("\n");
        }
        Map<Integer, Thread> $this$forEach$iv = this.moveRootThreadToTop(MapsKt.toMutableMap(threads), tombstone.getTid());
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Thread>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Thread> element$iv;
            Map.Entry<Integer, Thread> entry = element$iv = iterator.next();
            boolean bl = false;
            Thread thread2 = entry.getValue();
            builder.append(thread2.getName() + ':');
            builder.append("\n");
            Iterable $this$forEachIndexed$iv = thread2.getCurrent_backtrace();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void backtraceFrame;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BacktraceFrame backtraceFrame2 = (BacktraceFrame)((Object)item$iv);
                int index = n;
                boolean bl2 = false;
                builder.append("      #" + StringsKt.padStart((String)String.valueOf(index), (int)2, (char)'0') + " pc " + HexExtensionsKt.toHexString$default((long)backtraceFrame.getRel_pc(), null, (int)1, null) + ' ' + backtraceFrame.getFile_name() + " (" + backtraceFrame.getFunction_name() + '+' + backtraceFrame.getFunction_offset() + ") (BuildId: " + backtraceFrame.getBuild_id() + ')');
                builder.append("\n");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private final Map<Integer, Thread> moveRootThreadToTop(Map<Integer, Thread> $this$moveRootThreadToTop, int keyToMove) {
        LinkedHashMap sortedMap = new LinkedHashMap();
        Thread threadToMove = $this$moveRootThreadToTop.get(keyToMove);
        if (threadToMove != null) {
            Integer object = keyToMove;
            ((Map)sortedMap).put(object, threadToMove);
        }
        for (Map.Entry<Integer, Thread> entry : $this$moveRootThreadToTop.entrySet()) {
            int key = ((Number)entry.getKey()).intValue();
            Thread value = entry.getValue();
            if (key == keyToMove) continue;
            Integer n = key;
            ((Map)sortedMap).put(n, value);
        }
        return sortedMap;
    }

    private final String extractThreadsInfo(String input) {
        Regex regex = new Regex("(?ms)^\".*?(?=\\n\\s*(?:DumpLatency|\\s*$))");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)input, (int)0, (int)2, null), (Function1)extractThreadsInfo.1.INSTANCE), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final JSONObject generateBaseJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("characteristics.has_error", true);
        jsonObject.put("error.is_fatal", true);
        return jsonObject;
    }
}

