/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.lifecycle.callback;

import android.app.Activity;
import android.app.Application;
import com.dynatrace.agent.OneAgentConfiguration;
import com.dynatrace.agent.api.ViewContextApi;
import com.dynatrace.agent.lifecycle.callback.BaseActivityLifecycleCallbacks;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u0010\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\fR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/dynatrace/agent/lifecycle/callback/CurrentViewTracker;", "Lcom/dynatrace/agent/lifecycle/callback/BaseActivityLifecycleCallbacks;", "viewContextApi", "Lcom/dynatrace/agent/api/ViewContextApi;", "applicationContext", "Landroid/app/Application;", "oneAgentConfiguration", "Lcom/dynatrace/agent/OneAgentConfiguration;", "(Lcom/dynatrace/agent/api/ViewContextApi;Landroid/app/Application;Lcom/dynatrace/agent/OneAgentConfiguration;)V", "alreadyAdded", "", "onActivityPaused", "", "activity", "Landroid/app/Activity;", "onActivityResumed", "setUp", "tearDown", "com.dynatrace.agent_release"})
public final class CurrentViewTracker
extends BaseActivityLifecycleCallbacks {
    @NotNull
    private final ViewContextApi viewContextApi;
    @NotNull
    private final Application applicationContext;
    @NotNull
    private final OneAgentConfiguration oneAgentConfiguration;
    private boolean alreadyAdded;

    public CurrentViewTracker(@NotNull ViewContextApi viewContextApi, @NotNull Application applicationContext, @NotNull OneAgentConfiguration oneAgentConfiguration) {
        Intrinsics.checkNotNullParameter((Object)viewContextApi, (String)"viewContextApi");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)oneAgentConfiguration, (String)"oneAgentConfiguration");
        this.viewContextApi = viewContextApi;
        this.applicationContext = applicationContext;
        this.oneAgentConfiguration = oneAgentConfiguration;
    }

    public final void setUp() {
        if (this.oneAgentConfiguration.getActivityMonitoring() && !this.alreadyAdded) {
            this.applicationContext.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.alreadyAdded = true;
        }
    }

    public final void tearDown() {
        this.applicationContext.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.alreadyAdded = false;
    }

    @Override
    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.viewContextApi.startView(activity.getComponentName().getClassName());
    }

    @Override
    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.viewContextApi.stopView();
    }
}

