/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.userinteraction.util;

import com.dynatrace.agent.RumEventDispatcher;
import com.dynatrace.agent.common.time.TimeProvider;
import com.dynatrace.agent.metrics.AggregatedMetricsProviders;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.android.agent.util.Utility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/agent/userinteraction/util/UserInteractionTracker;", "", "rumEventDispatcher", "Lcom/dynatrace/agent/RumEventDispatcher;", "metricsProviders", "Lcom/dynatrace/agent/metrics/AggregatedMetricsProviders;", "timeProvider", "Lcom/dynatrace/agent/common/time/TimeProvider;", "(Lcom/dynatrace/agent/RumEventDispatcher;Lcom/dynatrace/agent/metrics/AggregatedMetricsProviders;Lcom/dynatrace/agent/common/time/TimeProvider;)V", "track", "", "userInteractionJson", "Lorg/json/JSONObject;", "track$com_dynatrace_agent_release", "com.dynatrace.agent_release"})
public final class UserInteractionTracker {
    @NotNull
    private final RumEventDispatcher rumEventDispatcher;
    @NotNull
    private final AggregatedMetricsProviders metricsProviders;
    @NotNull
    private final TimeProvider timeProvider;

    public UserInteractionTracker(@NotNull RumEventDispatcher rumEventDispatcher, @NotNull AggregatedMetricsProviders metricsProviders, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)rumEventDispatcher, (String)"rumEventDispatcher");
        Intrinsics.checkNotNullParameter((Object)metricsProviders, (String)"metricsProviders");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.rumEventDispatcher = rumEventDispatcher;
        this.metricsProviders = metricsProviders;
        this.timeProvider = timeProvider;
    }

    public final void track$com_dynatrace_agent_release(@NotNull JSONObject userInteractionJson) {
        Intrinsics.checkNotNullParameter((Object)userInteractionJson, (String)"userInteractionJson");
        SessionInformationMetrics sessionInformationMetrics = this.metricsProviders.getBasicMetrics().getSessionForInternalEvent();
        if (sessionInformationMetrics.isGrailEventsCanBeCaptured()) {
            RumEventDispatcher rumEventDispatcher = this.rumEventDispatcher;
            long l = this.timeProvider.millisSinceEpoch();
            rumEventDispatcher.dispatchEvent(userInteractionJson, l, 0L, sessionInformationMetrics, false, null);
        } else {
            Utility.devLog("dtxUserAction", "User Interaction cannot be tracked, isGrailEventsCanBeCaptured == false");
        }
    }
}

