/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.userinteraction.util;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.dynatrace.agent.userinteraction.model.TouchAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0000\u001a\u001c\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u000b"}, d2={"findTopView", "Landroid/view/View;", "Landroid/view/ViewGroup;", "x", "", "y", "getActionName", "Lcom/dynatrace/agent/userinteraction/model/TouchAction;", "Landroid/view/MotionEvent;", "isPointInBounds", "", "com.dynatrace.agent_release"})
public final class UserInteractionUtilKt {
    @NotNull
    public static final View findTopView(@NotNull ViewGroup $this$findTopView, int x, int y) {
        View view;
        Intrinsics.checkNotNullParameter((Object)$this$findTopView, (String)"<this>");
        if (!UserInteractionUtilKt.isPointInBounds((View)$this$findTopView, x, y)) {
            return (View)$this$findTopView;
        }
        View topView = null;
        for (int i = $this$findTopView.getChildCount() - 1; -1 < i; --i) {
            View child = $this$findTopView.getChildAt(i);
            Intrinsics.checkNotNull((Object)child);
            if (!UserInteractionUtilKt.isPointInBounds(child, x, y)) continue;
            topView = child instanceof ViewGroup ? UserInteractionUtilKt.findTopView((ViewGroup)child, x, y) : child;
            break;
        }
        if ((view = topView) == null) {
            view = (View)$this$findTopView;
        }
        return view;
    }

    private static final boolean isPointInBounds(View $this$isPointInBounds, int x, int y) {
        int[] location = new int[2];
        $this$isPointInBounds.getLocationOnScreen(location);
        int viewX = location[0];
        int viewY = location[1];
        return x >= viewX && x <= viewX + $this$isPointInBounds.getWidth() && y >= viewY && y <= viewY + $this$isPointInBounds.getHeight();
    }

    @NotNull
    public static final TouchAction getActionName(@NotNull MotionEvent $this$getActionName) {
        TouchAction touchAction;
        Intrinsics.checkNotNullParameter((Object)$this$getActionName, (String)"<this>");
        switch ($this$getActionName.getAction()) {
            case 0: {
                touchAction = TouchAction.DOWN;
                break;
            }
            case 1: {
                touchAction = TouchAction.UP;
                break;
            }
            case 2: {
                touchAction = TouchAction.MOVE;
                break;
            }
            case 5: {
                touchAction = TouchAction.POINTER_DOWN;
                break;
            }
            case 6: {
                touchAction = TouchAction.POINTER_UP;
                break;
            }
            default: {
                touchAction = TouchAction.UNKNOWN;
            }
        }
        return touchAction;
    }
}

