/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.lifecycle;

import com.dynatrace.agent.RumEventDispatcher;
import com.dynatrace.agent.common.time.TimeProvider;
import com.dynatrace.agent.di.SessionInformationProvider;
import com.dynatrace.agent.lifecycle.VisibilityManager;
import com.dynatrace.agent.lifecycle.model.VisibilityStatus;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.android.agent.util.Utility;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/dynatrace/agent/lifecycle/VisibilityManagerImpl;", "Lcom/dynatrace/agent/lifecycle/VisibilityManager;", "timeProvider", "Lcom/dynatrace/agent/common/time/TimeProvider;", "rumEventDispatcher", "Lcom/dynatrace/agent/RumEventDispatcher;", "sessionInformationProvider", "Lcom/dynatrace/agent/di/SessionInformationProvider;", "<init>", "(Lcom/dynatrace/agent/common/time/TimeProvider;Lcom/dynatrace/agent/RumEventDispatcher;Lcom/dynatrace/agent/di/SessionInformationProvider;)V", "appActivitiesIds", "", "", "changingConfiguration", "", "visibilityStatus", "Lcom/dynatrace/agent/lifecycle/model/VisibilityStatus;", "onActivityStarted", "", "activityId", "onActivityPaused", "onActivityStopped", "isChangingConfig", "getVisibilityStatus", "track", "visibility", "com.dynatrace.agent_release"})
public final class VisibilityManagerImpl
implements VisibilityManager {
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final RumEventDispatcher rumEventDispatcher;
    @NotNull
    private final SessionInformationProvider sessionInformationProvider;
    @NotNull
    private final Set<Integer> appActivitiesIds;
    private boolean changingConfiguration;
    @NotNull
    private VisibilityStatus visibilityStatus;

    public VisibilityManagerImpl(@NotNull TimeProvider timeProvider, @NotNull RumEventDispatcher rumEventDispatcher, @NotNull SessionInformationProvider sessionInformationProvider) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)rumEventDispatcher, (String)"rumEventDispatcher");
        Intrinsics.checkNotNullParameter((Object)sessionInformationProvider, (String)"sessionInformationProvider");
        this.timeProvider = timeProvider;
        this.rumEventDispatcher = rumEventDispatcher;
        this.sessionInformationProvider = sessionInformationProvider;
        this.appActivitiesIds = new LinkedHashSet();
        this.visibilityStatus = VisibilityStatus.BACKGROUND;
    }

    @Override
    public void onActivityStarted(int activityId) {
        this.appActivitiesIds.add(activityId);
        if (this.appActivitiesIds.size() == 1 && !this.changingConfiguration) {
            this.visibilityStatus = VisibilityStatus.FOREGROUND;
            this.track(VisibilityStatus.FOREGROUND);
        }
    }

    @Override
    public void onActivityPaused(int activityId) {
        this.appActivitiesIds.add(activityId);
    }

    @Override
    public void onActivityStopped(int activityId, boolean isChangingConfig) {
        this.changingConfiguration = isChangingConfig;
        this.appActivitiesIds.remove(activityId);
        if (this.appActivitiesIds.isEmpty() && !this.changingConfiguration) {
            this.visibilityStatus = VisibilityStatus.BACKGROUND;
            this.track(VisibilityStatus.BACKGROUND);
        }
    }

    @Override
    @NotNull
    public VisibilityStatus getVisibilityStatus() {
        return this.visibilityStatus;
    }

    private final void track(VisibilityStatus visibility) {
        JSONObject jSONObject;
        SessionInformationMetrics sessionInformationMetrics = this.sessionInformationProvider.collectSessionInfo();
        if (!sessionInformationMetrics.isGrailEventsCanBeCaptured()) {
            Utility.devLog("dtxLifecycle", "visibility event cannot be tracked, isGrailEventsCanBeCaptured == false");
            return;
        }
        if (!sessionInformationMetrics.getSessionActive()) {
            Utility.devLog("dtxLifecycle", "visibility event cannot be tracked, session is disabled");
            return;
        }
        RumEventDispatcher rumEventDispatcher = this.rumEventDispatcher;
        JSONObject $this$track_u24lambda_u240 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$track_u24lambda_u240.put("characteristics.has_visibility_change", true);
        $this$track_u24lambda_u240.put("visibility.state", (Object)visibility.getKeyValue());
        JSONObject jSONObject2 = jSONObject;
        long l = this.timeProvider.millisSinceEpoch();
        rumEventDispatcher.dispatchEvent(jSONObject2, l, 0L, sessionInformationMetrics, false, null);
    }
}

