/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.userinteraction.handler;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.dynatrace.agent.userinteraction.handler.UserInteractionHandler;
import com.dynatrace.agent.userinteraction.model.ComposeHitEvent;
import com.dynatrace.agent.userinteraction.model.TouchEvent;
import com.dynatrace.agent.userinteraction.model.TouchUserInteraction;
import com.dynatrace.agent.userinteraction.model.TouchUserInteractionGenerator;
import com.dynatrace.agent.userinteraction.model.TouchUserInteractionKt;
import com.dynatrace.agent.userinteraction.util.UserInteractionLogger;
import com.dynatrace.agent.userinteraction.util.UserInteractionTracker;
import com.dynatrace.agent.userinteraction.util.UserInteractionUtilKt;
import com.dynatrace.agent.util.CoroutineHandler;
import com.dynatrace.android.agent.useraction.model.ComposeLayout;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001dJ#\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0000\u00a2\u0006\u0002\b#J\u001c\u0010$\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/dynatrace/agent/userinteraction/handler/TouchUserInteractionHandler;", "Lcom/dynatrace/agent/util/CoroutineHandler;", "Lcom/dynatrace/agent/userinteraction/handler/UserInteractionHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "userInteractionLogger", "Lcom/dynatrace/agent/userinteraction/util/UserInteractionLogger;", "userInteractionTracker", "Lcom/dynatrace/agent/userinteraction/util/UserInteractionTracker;", "touchUserInteractionGenerator", "Lcom/dynatrace/agent/userinteraction/model/TouchUserInteractionGenerator;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/dynatrace/agent/userinteraction/util/UserInteractionLogger;Lcom/dynatrace/agent/userinteraction/util/UserInteractionTracker;Lcom/dynatrace/agent/userinteraction/model/TouchUserInteractionGenerator;)V", "touchList", "", "Lcom/dynatrace/agent/userinteraction/model/TouchEvent;", "composeHitEvent", "Lcom/dynatrace/agent/userinteraction/model/ComposeHitEvent;", "touchEventJob", "Lkotlinx/coroutines/Job;", "onMotionEvent", "", "rootView", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "onMotionEvent$com_dynatrace_agent_release", "onViewClick", "view", "onViewClick$com_dynatrace_agent_release", "onComposeHit", "hitArea", "Lcom/dynatrace/android/agent/useraction/model/ComposeLayout;", "overlappedAreas", "", "onComposeHit$com_dynatrace_agent_release", "processTouchEvents", "Landroid/view/ViewGroup;", "interactView", "Companion", "com.dynatrace.agent_release"})
public final class TouchUserInteractionHandler
extends CoroutineHandler
implements UserInteractionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserInteractionLogger userInteractionLogger;
    @NotNull
    private final UserInteractionTracker userInteractionTracker;
    @NotNull
    private final TouchUserInteractionGenerator touchUserInteractionGenerator;
    @NotNull
    private final List<TouchEvent> touchList;
    @Nullable
    private ComposeHitEvent composeHitEvent;
    @Nullable
    private Job touchEventJob;
    private static final long NO_INTERACTION_DELAY = 500L;

    public TouchUserInteractionHandler(@NotNull CoroutineScope coroutineScope, @NotNull UserInteractionLogger userInteractionLogger, @NotNull UserInteractionTracker userInteractionTracker, @NotNull TouchUserInteractionGenerator touchUserInteractionGenerator) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)userInteractionLogger, (String)"userInteractionLogger");
        Intrinsics.checkNotNullParameter((Object)userInteractionTracker, (String)"userInteractionTracker");
        Intrinsics.checkNotNullParameter((Object)touchUserInteractionGenerator, (String)"touchUserInteractionGenerator");
        super(coroutineScope);
        this.userInteractionLogger = userInteractionLogger;
        this.userInteractionTracker = userInteractionTracker;
        this.touchUserInteractionGenerator = touchUserInteractionGenerator;
        this.touchList = new ArrayList();
    }

    public final void onMotionEvent$com_dynatrace_agent_release(@NotNull View rootView, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(rootView instanceof ViewGroup)) {
            return;
        }
        Job job = this.touchEventJob;
        boolean bl = job != null ? job.isActive() : false;
        if (bl) {
            this.processTouchEvents((ViewGroup)rootView, null);
        }
        float x = event.getX(0);
        float y = event.getY(0);
        TouchEvent touchEvent = new TouchEvent(UserInteractionUtilKt.getActionName(event), x, y);
        this.userInteractionLogger.logTouchEvent$com_dynatrace_agent_release(touchEvent);
        this.touchList.add(touchEvent);
        if (event.getAction() == 1) {
            this.touchEventJob = this.launchWithDelay(500L, (Function0<Unit>)((Function0)() -> TouchUserInteractionHandler.onMotionEvent$lambda$0(this, rootView)));
        }
    }

    public final void onViewClick$com_dynatrace_agent_release(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        View view2 = view.getRootView();
        ViewGroup viewGroup = view2 instanceof ViewGroup ? (ViewGroup)view2 : null;
        if (viewGroup == null) {
            return;
        }
        ViewGroup rootView = viewGroup;
        this.processTouchEvents(rootView, view);
    }

    public final void onComposeHit$com_dynatrace_agent_release(@NotNull ComposeLayout hitArea, @NotNull List<ComposeLayout> overlappedAreas) {
        Intrinsics.checkNotNullParameter((Object)hitArea, (String)"hitArea");
        Intrinsics.checkNotNullParameter(overlappedAreas, (String)"overlappedAreas");
        this.composeHitEvent = new ComposeHitEvent(hitArea, overlappedAreas);
    }

    private final void processTouchEvents(ViewGroup rootView, View interactView) {
        Job job = this.touchEventJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        if (rootView != null) {
            TouchUserInteraction userInteraction;
            TouchUserInteraction touchUserInteraction = this.touchUserInteractionGenerator.generateCompose(this.touchList, this.composeHitEvent);
            if (touchUserInteraction == null) {
                touchUserInteraction = this.touchUserInteractionGenerator.generateNative(this.touchList, rootView, interactView);
            }
            TouchUserInteraction touchUserInteraction2 = userInteraction = touchUserInteraction;
            if (touchUserInteraction2 != null) {
                TouchUserInteraction it = touchUserInteraction2;
                boolean bl = false;
                this.userInteractionLogger.logTouchUserInteraction$com_dynatrace_agent_release(userInteraction);
                this.userInteractionTracker.track$com_dynatrace_agent_release(TouchUserInteractionKt.toJSONObject(userInteraction));
            }
        }
        this.touchList.clear();
        this.composeHitEvent = null;
    }

    private static final Unit onMotionEvent$lambda$0(TouchUserInteractionHandler this$0, View $rootView) {
        this$0.processTouchEvents((ViewGroup)$rootView, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/agent/userinteraction/handler/TouchUserInteractionHandler$Companion;", "", "<init>", "()V", "NO_INTERACTION_DELAY", "", "com.dynatrace.agent_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

