/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.common.connectivity;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import com.dynatrace.agent.common.connectivity.LocalBuild;
import com.dynatrace.agent.common.connectivity.NetworkConnectivityChecker;
import com.dynatrace.agent.common.connectivity.NetworkType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dynatrace/agent/common/connectivity/NetworkConnectivityCheckerImpl;", "Lcom/dynatrace/agent/common/connectivity/NetworkConnectivityChecker;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "getNetworkType", "Lcom/dynatrace/agent/common/connectivity/NetworkType;", "isNetworkConnected", "", "getNetworkTypePreSdk23", "com.dynatrace.agent_release"})
public final class NetworkConnectivityCheckerImpl
implements NetworkConnectivityChecker {
    @Nullable
    private final ConnectivityManager connectivityManager;

    public NetworkConnectivityCheckerImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        this.connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        if (this.connectivityManager == null) {
            return NetworkType.NONE;
        }
        return LocalBuild.INSTANCE.getVersionSdk() >= 23 ? this.getNetworkType(this.connectivityManager) : this.getNetworkTypePreSdk23(this.connectivityManager);
    }

    @Override
    public boolean isNetworkConnected() {
        return this.getNetworkType() != NetworkType.NONE;
    }

    private final NetworkType getNetworkType(ConnectivityManager connectivityManager) {
        Object object;
        block5: {
            block4: {
                Network network = connectivityManager.getActiveNetwork();
                if (network == null) {
                    return NetworkType.NONE;
                }
                Network activeNetwork = network;
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(activeNetwork);
                object = networkCapabilities;
                if (object == null) break block4;
                NetworkCapabilities it = object;
                boolean bl = false;
                NetworkType networkType = networkCapabilities.hasTransport(1) ? NetworkType.WIFI : (networkCapabilities.hasTransport(0) ? NetworkType.CELLULAR : (networkCapabilities.hasTransport(3) ? NetworkType.ETHERNET : NetworkType.OTHER));
                object = networkType;
                if (networkType != null) break block5;
            }
            object = NetworkType.NONE;
        }
        return object;
    }

    private final NetworkType getNetworkTypePreSdk23(ConnectivityManager connectivityManager) {
        NetworkType networkType;
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            switch (networkInfo.getType()) {
                case 1: {
                    networkType = NetworkType.WIFI;
                    break;
                }
                case 0: {
                    networkType = NetworkType.CELLULAR;
                    break;
                }
                case 9: {
                    networkType = NetworkType.ETHERNET;
                    break;
                }
                default: {
                    networkType = NetworkType.OTHER;
                    break;
                }
            }
        } else {
            networkType = NetworkType.NONE;
        }
        return networkType;
    }
}

