/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.lifecycle;

import com.dynatrace.agent.OneAgentStartupEventDispatcher;
import com.dynatrace.agent.common.time.TimeProvider;
import com.dynatrace.agent.di.SessionInformationProvider;
import com.dynatrace.agent.lifecycle.AppStartupManager;
import com.dynatrace.agent.lifecycle.model.AppStartupPhase;
import com.dynatrace.agent.lifecycle.model.AppStartupPhaseWithTiming;
import com.dynatrace.agent.lifecycle.model.AppStartupType;
import com.dynatrace.agent.lifecycle.model.VisibilityStatus;
import com.dynatrace.agent.lifecycle.util.AppStartupLogger;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/dynatrace/agent/lifecycle/AppStartupManagerImpl;", "Lcom/dynatrace/agent/lifecycle/AppStartupManager;", "timeProvider", "Lcom/dynatrace/agent/common/time/TimeProvider;", "appStartupLogger", "Lcom/dynatrace/agent/lifecycle/util/AppStartupLogger;", "rumEventDispatcher", "Lcom/dynatrace/agent/OneAgentStartupEventDispatcher;", "sessionInformationProvider", "Lcom/dynatrace/agent/di/SessionInformationProvider;", "visibilityStatusProvider", "Lkotlin/Function0;", "Lcom/dynatrace/agent/lifecycle/model/VisibilityStatus;", "<init>", "(Lcom/dynatrace/agent/common/time/TimeProvider;Lcom/dynatrace/agent/lifecycle/util/AppStartupLogger;Lcom/dynatrace/agent/OneAgentStartupEventDispatcher;Lcom/dynatrace/agent/di/SessionInformationProvider;Lkotlin/jvm/functions/Function0;)V", "phases", "", "Lcom/dynatrace/agent/lifecycle/model/AppStartupPhaseWithTiming;", "isProcessingStartup", "", "phasesOrder", "", "Lcom/dynatrace/agent/lifecycle/model/AppStartupPhase;", "onStartupPhase", "", "startupPhase", "canProcessPhase", "getStartupType", "Lcom/dynatrace/agent/lifecycle/model/AppStartupType;", "processStartupPhases", "onStartupEnd", "appStartupType", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nAppStartupManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppStartupManagerImpl.kt\ncom/dynatrace/agent/lifecycle/AppStartupManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1872#2,3:141\n*S KotlinDebug\n*F\n+ 1 AppStartupManagerImpl.kt\ncom/dynatrace/agent/lifecycle/AppStartupManagerImpl\n*L\n115#1:141,3\n*E\n"})
public final class AppStartupManagerImpl
implements AppStartupManager {
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final AppStartupLogger appStartupLogger;
    @NotNull
    private final OneAgentStartupEventDispatcher rumEventDispatcher;
    @NotNull
    private final SessionInformationProvider sessionInformationProvider;
    @NotNull
    private final Function0<VisibilityStatus> visibilityStatusProvider;
    @NotNull
    private final List<AppStartupPhaseWithTiming> phases;
    private boolean isProcessingStartup;
    @NotNull
    private final List<AppStartupPhase> phasesOrder;

    public AppStartupManagerImpl(@NotNull TimeProvider timeProvider, @NotNull AppStartupLogger appStartupLogger, @NotNull OneAgentStartupEventDispatcher rumEventDispatcher, @NotNull SessionInformationProvider sessionInformationProvider, @NotNull Function0<? extends VisibilityStatus> visibilityStatusProvider) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)appStartupLogger, (String)"appStartupLogger");
        Intrinsics.checkNotNullParameter((Object)rumEventDispatcher, (String)"rumEventDispatcher");
        Intrinsics.checkNotNullParameter((Object)sessionInformationProvider, (String)"sessionInformationProvider");
        Intrinsics.checkNotNullParameter(visibilityStatusProvider, (String)"visibilityStatusProvider");
        this.timeProvider = timeProvider;
        this.appStartupLogger = appStartupLogger;
        this.rumEventDispatcher = rumEventDispatcher;
        this.sessionInformationProvider = sessionInformationProvider;
        this.visibilityStatusProvider = visibilityStatusProvider;
        this.phases = new ArrayList();
        AppStartupPhase[] appStartupPhaseArray = new AppStartupPhase[]{AppStartupPhase.APPLICATION_CREATE, AppStartupPhase.ACTIVITY_CREATE, AppStartupPhase.ACTIVITY_START, AppStartupPhase.ACTIVITY_RESUMED};
        this.phasesOrder = CollectionsKt.listOf((Object[])appStartupPhaseArray);
    }

    @Override
    public void onStartupPhase(@NotNull AppStartupPhase startupPhase) {
        int lastPhaseIndex;
        Intrinsics.checkNotNullParameter((Object)((Object)startupPhase), (String)"startupPhase");
        if (!this.canProcessPhase()) {
            return;
        }
        if (!((Collection)this.phases).isEmpty() && (lastPhaseIndex = this.phasesOrder.indexOf((Object)((AppStartupPhaseWithTiming)CollectionsKt.last(this.phases)).getPhase())) != CollectionsKt.getLastIndex(this.phasesOrder) && this.phasesOrder.get(lastPhaseIndex + 1) != startupPhase) {
            AppStartupType appStartupType = this.getStartupType();
            if (appStartupType != null) {
                AppStartupType startupType = appStartupType;
                boolean bl = false;
                this.appStartupLogger.logApplicationStartupCancel(startupType);
            }
            this.phases.clear();
        }
        this.phases.add(new AppStartupPhaseWithTiming(startupPhase, this.timeProvider.millisSinceEpoch()));
        this.processStartupPhases();
    }

    private final boolean canProcessPhase() {
        if (this.visibilityStatusProvider.invoke() == VisibilityStatus.BACKGROUND) {
            this.isProcessingStartup = true;
        }
        return this.isProcessingStartup;
    }

    private final AppStartupType getStartupType() {
        AppStartupType appStartupType;
        switch (WhenMappings.$EnumSwitchMapping$0[((AppStartupPhaseWithTiming)CollectionsKt.first(this.phases)).getPhase().ordinal()]) {
            case 1: {
                appStartupType = AppStartupType.COLD;
                break;
            }
            case 2: {
                appStartupType = AppStartupType.WARM;
                break;
            }
            case 3: {
                appStartupType = AppStartupType.HOT;
                break;
            }
            case 4: {
                appStartupType = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AppStartupType appStartupType2 = appStartupType;
        return appStartupType2;
    }

    private final void processStartupPhases() {
        AppStartupType appStartupType = this.getStartupType();
        if (appStartupType == null) {
            return;
        }
        AppStartupType startupType = appStartupType;
        if (this.phases.size() == 1) {
            long startTime = ((AppStartupPhaseWithTiming)CollectionsKt.first(this.phases)).getStart();
            this.appStartupLogger.logApplicationStartupBegin(startupType, startTime);
        } else if (this.phases.size() > 1) {
            AppStartupPhase previousPhase = this.phases.get(this.phases.size() - 2).getPhase();
            long previousStartTime = this.phases.get(this.phases.size() - 2).getStart();
            long lastStartTime = ((AppStartupPhaseWithTiming)CollectionsKt.last(this.phases)).getStart();
            this.appStartupLogger.logPhase(startupType, previousPhase, previousStartTime, lastStartTime);
            if (((AppStartupPhaseWithTiming)CollectionsKt.last(this.phases)).getPhase() == AppStartupPhase.ACTIVITY_RESUMED) {
                this.isProcessingStartup = false;
                this.onStartupEnd(startupType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onStartupEnd(AppStartupType appStartupType) {
        JSONObject jSONObject;
        SessionInformationMetrics sessionInformationMetrics = this.sessionInformationProvider.collectSessionInfo();
        if (!sessionInformationMetrics.isGrailEventsCanBeCaptured()) {
            Utility.devLog("dtxLifecycle", "startup event cannot be tracked, isGrailEventsCanBeCaptured == false");
            this.phases.clear();
            return;
        }
        if (!sessionInformationMetrics.getSessionActive()) {
            Utility.devLog("dtxLifecycle", "startup event cannot be tracked, session is disabled");
            this.phases.clear();
            return;
        }
        long startTime = ((AppStartupPhaseWithTiming)CollectionsKt.first(this.phases)).getStart();
        long endTime = ((AppStartupPhaseWithTiming)CollectionsKt.last(this.phases)).getStart();
        this.appStartupLogger.logApplicationStartup(appStartupType, startTime, endTime);
        JSONObject $this$onStartupEnd_u24lambda_u242 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$onStartupEnd_u24lambda_u242.put("characteristics.has_app_start", true);
        $this$onStartupEnd_u24lambda_u242.put("app_start.type", (Object)appStartupType.getValue());
        Iterable $this$forEachIndexed$iv = this.phases;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void phaseWithTiming;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AppStartupPhaseWithTiming appStartupPhaseWithTiming = (AppStartupPhaseWithTiming)item$iv;
            int index = n;
            boolean bl2 = false;
            AppStartupPhaseWithTiming appStartupPhaseWithTiming2 = (AppStartupPhaseWithTiming)CollectionsKt.getOrNull(this.phases, (int)(index + 1));
            if (appStartupPhaseWithTiming2 == null) {
                continue;
            }
            long nextPhaseStart = appStartupPhaseWithTiming2.getStart();
            if (phaseWithTiming.getPhase() == AppStartupPhase.ACTIVITY_RESUMED) continue;
            $this$onStartupEnd_u24lambda_u242.put("app_start." + phaseWithTiming.getPhase().getValue() + ".start_time", phaseWithTiming.getStart() - startTime);
            $this$onStartupEnd_u24lambda_u242.put("app_start." + phaseWithTiming.getPhase().getValue() + ".end_time", nextPhaseStart - startTime);
        }
        JSONObject appStartupEvent = jSONObject;
        this.rumEventDispatcher.dispatchNativeEvent(appStartupEvent, startTime, endTime - startTime, sessionInformationMetrics);
        this.phases.clear();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AppStartupPhase.values().length];
            try {
                nArray[AppStartupPhase.APPLICATION_CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppStartupPhase.ACTIVITY_CREATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppStartupPhase.ACTIVITY_START.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppStartupPhase.ACTIVITY_RESUMED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

