/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.userinteraction.util;

import com.dynatrace.agent.RumEventDispatcher;
import com.dynatrace.agent.common.time.TimeProvider;
import com.dynatrace.agent.di.SessionInformationProvider;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.android.agent.util.Utility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/agent/userinteraction/util/UserInteractionTracker;", "", "rumEventDispatcher", "Lcom/dynatrace/agent/RumEventDispatcher;", "sessionInformationProvider", "Lcom/dynatrace/agent/di/SessionInformationProvider;", "timeProvider", "Lcom/dynatrace/agent/common/time/TimeProvider;", "<init>", "(Lcom/dynatrace/agent/RumEventDispatcher;Lcom/dynatrace/agent/di/SessionInformationProvider;Lcom/dynatrace/agent/common/time/TimeProvider;)V", "track", "", "userInteractionJson", "Lorg/json/JSONObject;", "track$com_dynatrace_agent_release", "com.dynatrace.agent_release"})
public final class UserInteractionTracker {
    @NotNull
    private final RumEventDispatcher rumEventDispatcher;
    @NotNull
    private final SessionInformationProvider sessionInformationProvider;
    @NotNull
    private final TimeProvider timeProvider;

    public UserInteractionTracker(@NotNull RumEventDispatcher rumEventDispatcher, @NotNull SessionInformationProvider sessionInformationProvider, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)rumEventDispatcher, (String)"rumEventDispatcher");
        Intrinsics.checkNotNullParameter((Object)sessionInformationProvider, (String)"sessionInformationProvider");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.rumEventDispatcher = rumEventDispatcher;
        this.sessionInformationProvider = sessionInformationProvider;
        this.timeProvider = timeProvider;
    }

    public final void track$com_dynatrace_agent_release(@NotNull JSONObject userInteractionJson) {
        Intrinsics.checkNotNullParameter((Object)userInteractionJson, (String)"userInteractionJson");
        SessionInformationMetrics sessionInformationMetrics = this.sessionInformationProvider.collectSessionInfo();
        if (!sessionInformationMetrics.isGrailEventsCanBeCaptured()) {
            Utility.devLog("dtxUserAction", "User Interaction cannot be tracked, isGrailEventsCanBeCaptured == false");
            return;
        }
        if (!sessionInformationMetrics.getSessionActive()) {
            Utility.devLog("dtxUserAction", "User Interaction cannot be tracked, session is disabled");
            return;
        }
        RumEventDispatcher rumEventDispatcher = this.rumEventDispatcher;
        long l = this.timeProvider.millisSinceEpoch();
        rumEventDispatcher.dispatchEvent(userInteractionJson, l, 0L, sessionInformationMetrics, false, null);
    }
}

