/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose;

import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.state.ToggleableState;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.agent.measurement.MeasurementProviderImpl;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.compose.ClassBasedActionNameGenerator;
import com.dynatrace.android.compose.ToggleActionRecorder;
import com.dynatrace.android.compose.ToggleableInfo;
import com.dynatrace.android.useraction.UserActionFactory;
import com.dynatrace.android.useraction.UserActionFactoryImpl;
import kotlin.jvm.functions.Function0;

public class ToggleableComposeCallback
implements Function0 {
    private static final String TAG = Global.LOG_PREFIX + "ToggleableCompose";
    private final Function0 function;
    private final Role role;
    private final ToggleableState state;

    public ToggleableComposeCallback(Function0 function, Role role, ToggleableState state) {
        this.role = role;
        this.function = function;
        this.state = state;
    }

    public Object invoke() {
        if (!Global.isAlive.get()) {
            return this.function.invoke();
        }
        MeasurementProviderImpl measurementProvider = new MeasurementProviderImpl(TimeLineProvider.globalTimeLineProvider);
        UserActionFactoryImpl userActionFactory = new UserActionFactoryImpl();
        ToggleableInfo toggleableInfo = new ToggleableInfo(this.state, this.role, this.function);
        ClassBasedActionNameGenerator nameGenerator = new ClassBasedActionNameGenerator(toggleableInfo);
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("onUA: " + toggleableInfo));
        }
        ToggleActionRecorder clickActionRecorder = new ToggleActionRecorder(nameGenerator, (MeasurementProvider)measurementProvider, (UserActionFactory)userActionFactory, toggleableInfo);
        return clickActionRecorder.invokeFunction(this.function);
    }
}

