/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

public final class ReplayConfiguration {
    static final ReplayConfiguration DEFAULT_REPLAY_CONFIGURATION = ReplayConfiguration.builder().build();
    private static final boolean DEFAULT_CAPTURE = false;
    private static final int DEFAULT_RETENTION_TIME = 0;
    private static final int DEFAULT_PROTOCOL_VERSION = 1;
    private static final int DEFAULT_FS_SELFMONITORING = 0;
    private final boolean capture;
    private final int retentionTimeInMinutes;
    private final int protocolVersion;
    private final int selfMonitoring;

    private ReplayConfiguration(Builder builder) {
        this.capture = builder.capture;
        this.retentionTimeInMinutes = builder.retentionTimeInMinutes;
        this.protocolVersion = builder.protocolVersion;
        this.selfMonitoring = builder.selfMonitoring;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isCaptureOn() {
        return this.capture;
    }

    public int getRetentionTimeInMinutes() {
        return this.retentionTimeInMinutes;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getSelfMonitoring() {
        return this.selfMonitoring;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayConfiguration that = (ReplayConfiguration)o;
        return this.capture == that.capture && this.retentionTimeInMinutes == that.retentionTimeInMinutes && this.protocolVersion == that.protocolVersion && this.selfMonitoring == that.selfMonitoring;
    }

    public int hashCode() {
        int result = this.capture ? 1 : 0;
        result = 31 * result + (this.retentionTimeInMinutes ^ this.retentionTimeInMinutes >>> 32);
        result = 31 * result + this.protocolVersion;
        result = 31 * result + this.selfMonitoring;
        return result;
    }

    public String toString() {
        return "ReplayConfiguration{capture=" + this.capture + ", retentionTime=" + this.retentionTimeInMinutes + ", protocolVersion=" + this.protocolVersion + ", selfMonitoring=" + this.selfMonitoring + '}';
    }

    public static class Builder {
        private boolean capture;
        private int retentionTimeInMinutes;
        private int protocolVersion;
        private int selfMonitoring;

        public Builder() {
            this.capture = false;
            this.retentionTimeInMinutes = 0;
            this.protocolVersion = 1;
            this.selfMonitoring = 0;
        }

        public Builder(ReplayConfiguration oldReplayConfiguration) {
            this.capture = oldReplayConfiguration.capture;
            this.retentionTimeInMinutes = oldReplayConfiguration.retentionTimeInMinutes;
            this.protocolVersion = oldReplayConfiguration.protocolVersion;
            this.selfMonitoring = oldReplayConfiguration.selfMonitoring;
        }

        public Builder withCapture(boolean capture) {
            this.capture = capture;
            return this;
        }

        public Builder withRetentionTimeInMinutes(int retentionTimeInMinutes) {
            this.retentionTimeInMinutes = retentionTimeInMinutes;
            return this;
        }

        public Builder withProtocolVersion(int protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder withSelfMonitoring(int selfMonitoring) {
            this.selfMonitoring = selfMonitoring;
            return this;
        }

        public ReplayConfiguration build() {
            return new ReplayConfiguration(this);
        }
    }
}

