/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

public final class SessionSplitConfiguration {
    static final SessionSplitConfiguration DEFAULT_SESSION_SPLIT_CONFIGURATION = SessionSplitConfiguration.builder().build();
    static final int DEFAULT_SESSION_TIMEOUT_SEC = 600;
    static final int DEFAULT_MAX_SESSION_DURATION_MINS = 360;
    private final int maxSessionDuration;
    private final int inactivityTimeout;

    private SessionSplitConfiguration(Builder builder) {
        this.maxSessionDuration = builder.maxSessionDuration;
        this.inactivityTimeout = builder.inactivityTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getMaxSessionDurationMs() {
        return (long)(this.maxSessionDuration * 60) * 1000L;
    }

    public long getMaxSessionDurationMinutes() {
        return this.maxSessionDuration;
    }

    public long getInactivityTimeoutMs() {
        return (long)this.inactivityTimeout * 1000L;
    }

    public long getInactivityTimeoutSeconds() {
        return this.inactivityTimeout;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionSplitConfiguration that = (SessionSplitConfiguration)o;
        if (this.maxSessionDuration != that.maxSessionDuration) {
            return false;
        }
        return this.inactivityTimeout == that.inactivityTimeout;
    }

    public int hashCode() {
        int result = this.maxSessionDuration;
        result = 31 * result + this.inactivityTimeout;
        return result;
    }

    public String toString() {
        return "SessionSplitConfiguration{maxSessionDuration=" + this.maxSessionDuration + ", inactivityTimeout=" + this.inactivityTimeout + '}';
    }

    public static class Builder {
        private int maxSessionDuration;
        private int inactivityTimeout;

        public Builder() {
            this.maxSessionDuration = 360;
            this.inactivityTimeout = 600;
        }

        public Builder(SessionSplitConfiguration sessionSplitConfig) {
            this.maxSessionDuration = sessionSplitConfig.maxSessionDuration;
            this.inactivityTimeout = sessionSplitConfig.inactivityTimeout;
        }

        public Builder withMaxSessionDuration(int maxSessionDurationMins) {
            this.maxSessionDuration = maxSessionDurationMins;
            return this;
        }

        public Builder withInactivityTimeout(int inactivityTimeoutSec) {
            this.inactivityTimeout = inactivityTimeoutSec;
            return this;
        }

        public SessionSplitConfiguration build() {
            return new SessionSplitConfiguration(this);
        }
    }
}

