/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.cookie;

import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.cookie.CookieProducer;
import com.dynatrace.android.agent.cookie.CookieWriter;
import com.dynatrace.android.agent.data.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CookieHandler {
    private static final String ADK = "dtAdk";
    private static final String ADK_SETTINGS = "dtAdkSettings";
    @Deprecated
    private static final String DT_COOKIE = "dtCookie";
    private CookieProducer producer = new CookieProducer();
    private CookieWriter cookieWriter;
    private AgentMode agentMode;
    private Set<String> domains;
    private Set<String> httpsDomains;
    private Map<String, String> cookies;

    public CookieHandler(Set<String> domains, Set<String> httpsDomains, AgentMode agentMode) {
        this.domains = domains;
        this.httpsDomains = httpsDomains;
        this.agentMode = agentMode;
    }

    void setCookieWriter(CookieWriter cookieWriter) {
        this.cookieWriter = cookieWriter;
    }

    public void onAgentStart() {
        this.cookieWriter = new CookieWriter();
    }

    public synchronized void onSessionStart(Session session, String encodedApplicationId) {
        this.cookies = new HashMap<String, String>();
        if (this.agentMode == AgentMode.SAAS) {
            this.cookies.put(ADK_SETTINGS, "dtAdkSettings=" + this.producer.createAdkSettingsCookie(session));
        }
        if (session.getPrivacyRules().allowUserRelatedCookies()) {
            this.cookies.put(ADK, "dtAdk=" + this.producer.createAdkCookie(session, encodedApplicationId));
            if (this.agentMode == AgentMode.APP_MON) {
                this.cookies.put(DT_COOKIE, "dtCookie=" + this.producer.createDtCookie(session.visitorId, session.sessionId));
            }
        } else {
            ArrayList<String> removeCookies = new ArrayList<String>();
            removeCookies.add(ADK);
            if (this.agentMode == AgentMode.APP_MON) {
                removeCookies.add(DT_COOKIE);
            }
            this.cookieWriter.removeCookies(this.domains, removeCookies);
            this.cookieWriter.removeCookies(this.httpsDomains, removeCookies);
        }
        if (!this.cookies.isEmpty()) {
            this.cookieWriter.writeCookies(this.domains, this.cookies.values(), false);
            this.cookieWriter.writeCookies(this.httpsDomains, this.cookies.values(), true);
        }
    }

    public synchronized void onTrafficControlUpdate(Session session) {
        if (this.agentMode == AgentMode.SAAS) {
            String cookie = "dtAdkSettings=" + this.producer.createAdkSettingsCookie(session);
            this.cookies.put(ADK_SETTINGS, cookie);
            ArrayList<String> updatedCookies = new ArrayList<String>();
            updatedCookies.add(cookie);
            this.cookieWriter.writeCookies(this.domains, updatedCookies, false);
            this.cookieWriter.writeCookies(this.httpsDomains, updatedCookies, true);
        }
    }

    public synchronized void restoreCookies() {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            this.cookieWriter.writeCookies(this.domains, this.cookies.values(), false);
            this.cookieWriter.writeCookies(this.httpsDomains, this.cookies.values(), true);
        }
    }
}

