/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.ExposedUserAction;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.UserActionModifier;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.ConfigurationPreset;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.intf.DTXActionListener;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.useraction.AppStartPlaceholderSegment;
import com.dynatrace.android.useraction.LifecyclePlaceholderSegment;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class DTXAutoAction
extends DTXActionImpl
implements DTXActionListener {
    private static final String LOGTAG = Global.LOG_PREFIX + "DTXAutoAction";
    private static final int INTERVAL = 100;
    static int graceTime = ConfigurationPreset.generateImproperConfiguration().graceTime;
    static int waitTime = ConfigurationPreset.generateImproperConfiguration().waitTime;
    static boolean sendEmptyActions = true;
    static UserActionModifier autoUserActionModifier = null;
    private static volatile DTXAutoAction theAutoAction;
    private static List<DTXAutoAction> outstandingGaua;
    private volatile long adjustedEndTime = 0L;
    private volatile int webReqCount = 0;
    private volatile int actionCount = 0;
    private volatile boolean haveWebReq = false;
    private volatile boolean haveAction = false;
    private volatile boolean hasEvents = false;
    private volatile boolean waitTimeStarted = false;
    private volatile boolean graceTimeOver;
    private boolean abandonThis = false;
    private volatile Timer theTimer = null;
    private boolean modifiedName = false;

    protected DTXAutoAction(String actionName, Session session, int serverId) {
        super(actionName, EventType.ACTION_AUTO, 0L, session, serverId);
        Core.addEvent(actionName, 1, this.getParentTagId(), this, session, serverId, new String[0]);
    }

    public static DTXAutoAction createAutoAction(String actionName, Session session, int serverId) {
        DTXAutoAction newGaua = new DTXAutoAction(actionName, session, serverId);
        DTXAutoAction.swapGaua(newGaua);
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("onUA: new GAUA %s @ %d", actionName, newGaua.getStartTime()));
        }
        if (autoUserActionModifier != null) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "invoking the AUA modifier on the current auto action");
            }
            autoUserActionModifier.modify(new ExposedUserAction(newGaua));
        }
        return newGaua;
    }

    public static DTXAutoAction getAutoAction() {
        return theAutoAction;
    }

    public static void setAutoInstrProperties(Configuration configuration) {
        graceTime = configuration.graceTime;
        waitTime = configuration.waitTime;
        sendEmptyActions = configuration.sendEmptyAction;
        autoUserActionModifier = configuration.autoUserActionModifier;
    }

    private static synchronized DTXAutoAction swapGaua(DTXAutoAction newGaua) {
        DTXAutoAction oldGaua = theAutoAction;
        theAutoAction = newGaua;
        if (oldGaua != null) {
            outstandingGaua.add(oldGaua);
        }
        return oldGaua;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        ArrayList<DTXAutoAction> copy;
        DTXAutoAction.swapGaua(null);
        List<DTXAutoAction> list = outstandingGaua;
        synchronized (list) {
            copy = new ArrayList<DTXAutoAction>(outstandingGaua);
        }
        for (DTXAutoAction gaua : copy) {
            try {
                gaua.leaveAction();
            }
            catch (Exception e) {
                if (!Global.DEBUG) continue;
                Utility.zlogE(LOGTAG, "GAUA close all internal errors", e);
            }
        }
    }

    public void startTimer() {
        this.startTimer(graceTime);
        this.markOverrideEndTime();
    }

    public void startTimerIfNeeded() {
        if (this.theTimer == null) {
            this.startTimer(graceTime);
        }
    }

    public void startTimer(int gracePeriodMs) {
        this.cancelTimer();
        if (gracePeriodMs <= 0) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    DTXAutoAction.this.onTimerPop(0);
                }
            };
            t.start();
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("onUA: start grace period for %s", this.getName()));
        }
        this.startTimer(gracePeriodMs, gracePeriodMs, 0, false);
    }

    private void startTimer(long delay, long period, final int numPeriods, final boolean execOnEachInterval) {
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("onUA: startTimer for %s delay=%dms period=%dms #period=%d", this.getName(), delay, period, numPeriods));
        }
        TimerTask tt = new TimerTask(){
            int intervals;
            {
                this.intervals = numPeriods;
            }

            @Override
            public void run() {
                if (this.intervals > 0) {
                    --this.intervals;
                    if (!execOnEachInterval) {
                        return;
                    }
                } else {
                    DTXAutoAction.this.cancelTimer();
                }
                DTXAutoAction.this.onTimerPop(this.intervals);
            }
        };
        for (int count = 3; count > 0; --count) {
            try {
                Timer timer = this.getTimer(true);
                timer.schedule(tt, delay, period);
                break;
            }
            catch (IllegalArgumentException iae) {
                break;
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
        }
    }

    private void onTimerPop(int intervalNum) {
        this.graceTimeOver = true;
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("onUA: onTimerPop for %s intv=%d WR=%d action=%d", this.getName(), intervalNum, this.webReqCount, this.actionCount));
        }
        if (!this.waitTimeStarted) {
            this.bootGauaOff(this, true);
        }
        if (this.webReqCount > 0 || this.actionCount > 0) {
            if (!this.waitTimeStarted) {
                int adjustedWaitInterval;
                long adjustedWaitTime;
                this.waitTimeStarted = true;
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, String.format("onUA: starting waiting period for %s", this.getName()));
                }
                if ((adjustedWaitTime = (long)waitTime - (this.getSessionRunningTime() - this.getStartTime())) > 1000L) {
                    adjustedWaitInterval = 1000;
                } else {
                    adjustedWaitInterval = 100;
                    if (adjustedWaitTime < 0L) {
                        adjustedWaitTime = 0L;
                    }
                }
                int numPeriods = Math.round((float)adjustedWaitTime / (float)adjustedWaitInterval) - 1;
                this.startTimer(adjustedWaitInterval, adjustedWaitInterval, numPeriods, true);
                return;
            }
            if (intervalNum > 0) {
                return;
            }
        }
        this.cancelTimer();
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("onUA: closing %s", this.getName()));
        }
        this.leaveAction();
    }

    public void cancelTimer() {
        this.cancelTimer(this.getTimer(false));
    }

    private void cancelTimer(Timer timer) {
        this.graceTimeOver = this.waitTimeStarted;
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, "onUA: cancel timer=" + timer + " graceTimeOver=" + this.graceTimeOver);
        }
        if (timer != null) {
            timer.cancel();
            timer.purge();
        }
    }

    private synchronized Timer getTimer(boolean createNew) {
        Timer timerToReturn;
        if (createNew) {
            if (this.theTimer != null) {
                this.cancelTimer(this.theTimer);
            }
            timerToReturn = this.theTimer = new Timer(LOGTAG);
        } else {
            timerToReturn = this.theTimer;
            this.theTimer = null;
        }
        return timerToReturn;
    }

    private synchronized void bootGauaOff(DTXAutoAction gaua, boolean needToTrack) {
        if (theAutoAction == gaua) {
            theAutoAction = null;
            if (needToTrack && gaua != null) {
                outstandingGaua.add(gaua);
            }
        }
    }

    @Override
    public void tagRequest(HttpURLConnection conn) {
        if (this.graceTimeOver) {
            return;
        }
        super.tagRequest(conn);
    }

    @Override
    public String tagRequest() {
        if (this.graceTimeOver) {
            return Dynatrace.getRequestTag();
        }
        return super.tagRequest();
    }

    @Override
    public String getRequestTag() {
        if (this.graceTimeOver) {
            return Dynatrace.getRequestTag();
        }
        return super.getRequestTag();
    }

    @Override
    protected WebReqTag getInternalRequestTag() {
        if (this.graceTimeOver) {
            return null;
        }
        return super.getInternalRequestTag();
    }

    @Override
    protected void notifyChildAdded(CustomSegment childEvent) {
        if (childEvent == null) {
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("onUA: add child %s to %s", childEvent.getName(), this.getName()));
        }
        switch (childEvent.getType()) {
            case 100: 
            case 110: {
                ++this.webReqCount;
                this.haveWebReq = true;
                break;
            }
            case 5: {
                ++this.actionCount;
                this.haveAction = true;
                DTXAutoAction.registerActionListener(this);
                break;
            }
            default: {
                this.hasEvents = this.isAnEvent(childEvent);
            }
        }
    }

    private boolean isAnEvent(CustomSegment childEvent) {
        switch (childEvent.getEventType()) {
            case VALUE_INT64: 
            case VALUE_DOUBLE: 
            case VALUE_STRING: 
            case ERROR_INT: 
            case ERROR_EXCEPTION: 
            case NAMED_EVENT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void leaveAction() {
        this.cancelTimer();
        this.waitTimeStarted = true;
        this.graceTimeOver = true;
        this.bootGauaOff(this, false);
        outstandingGaua.remove(this);
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("onUA: leave %s - abandon=%b WR=%b action=%b modified=%b eT=%d", this.getName(), this.abandonThis, this.haveWebReq, this.haveAction, this.hasEvents, this.adjustedEndTime));
        }
        DTXActionImpl.removeActionListener(this);
        if (this.abandonThis) {
            super.leaveAction(false);
        } else {
            Vector<CustomSegment> childEvents;
            boolean shouldStoreAction;
            boolean bl = shouldStoreAction = (this.haveWebReq || this.haveAction) && this.adjustedEndTime > 0L || sendEmptyActions || this.hasEvents;
            if (shouldStoreAction && this.actionCount > 0 && this.getName().equals("Loading " + AdkSettings.applName) && (childEvents = this.getChildEventVector()).size() > 0 && !this.hasLifecycleChildEvents(childEvents) && childEvents.get(0) instanceof AppStartPlaceholderSegment) {
                AppStartPlaceholderSegment placeholderSegment = (AppStartPlaceholderSegment)childEvents.get(0);
                placeholderSegment.discardAction();
                shouldStoreAction = false;
            }
            super.leaveAction(shouldStoreAction);
        }
    }

    private boolean hasLifecycleChildEvents(Vector<CustomSegment> childEvents) {
        for (CustomSegment segment : childEvents) {
            if (!(segment instanceof LifecyclePlaceholderSegment)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean getPreconditions() {
        return super.getPreconditions();
    }

    @Override
    protected long getOverrideEndTime() {
        if (this.haveWebReq || this.haveAction) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, String.format("onUA: use adjusted eT=%d dur=%d", this.adjustedEndTime, this.adjustedEndTime - this.getStartTime()));
            }
            return this.adjustedEndTime;
        }
        if (this.adjustedEndTime > 0L) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, String.format("onUA (empty): use adjusted eT=%d dur=%d", this.adjustedEndTime, this.adjustedEndTime - this.getStartTime()));
            }
            return this.adjustedEndTime;
        }
        return super.getOverrideEndTime();
    }

    public synchronized void markOverrideEndTime() {
        if (this.isFinalized()) {
            return;
        }
        this.adjustedEndTime = this.getSessionRunningTime();
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("onUA: new eT=%d dur=%d", this.adjustedEndTime, this.adjustedEndTime - this.getStartTime()));
        }
    }

    public int onWrFinished(long parentTagId) {
        if (this.isFinalized()) {
            return this.webReqCount;
        }
        if (this.webReqCount > 0 && parentTagId == this.getTagId()) {
            this.markOverrideEndTime();
            --this.webReqCount;
        }
        return this.webReqCount;
    }

    @Override
    public void onLeaveAction(DTXActionImpl action) {
        Vector<CustomSegment> children = this.getChildEventVector();
        if (children.contains(action)) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, String.format("onUA: child %s of %s done", action.getName(), this.getName()));
            }
            this.markOverrideEndTime();
            --this.actionCount;
        }
    }

    @Override
    public void discardAction() {
        this.abandonThis = true;
        this.leaveAction();
    }

    @Override
    public void removeChildEvent(String childName) {
        if (childName.startsWith(WebReqTag.getTagPrefix())) {
            --this.webReqCount;
        } else {
            --this.actionCount;
        }
        super.removeChildEvent(childName);
    }

    @Override
    public StringBuilder createEventData() {
        StringBuilder sb = new StringBuilder();
        sb.append("et=").append(this.eventType.getProtocolId());
        sb.append("&na=").append(Utility.urlEncode(this.getName()));
        sb.append("&it=").append(Thread.currentThread().getId());
        sb.append("&ca=").append(this.getTagId());
        sb.append("&pa=").append(this.getParentTagId());
        sb.append("&s0=").append(this.getLcSeqNum());
        sb.append("&t0=").append(this.getStartTime());
        sb.append("&s1=").append(this.endActionSequenceNum);
        sb.append("&t1=").append(this.getEndTime() - this.getStartTime());
        sb.append("&mo=").append(this.modifiedName ? "1" : "0");
        return sb;
    }

    public boolean isGraceTimeOver() {
        return this.graceTimeOver;
    }

    public void cancelGracefully() {
        this.abandonThis = true;
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, "AutoAction '" + this.getName() + "' was canceled by the developer");
        }
    }

    boolean isAbandoned() {
        return this.abandonThis;
    }

    public void modifyName(String name) {
        String oldName = this.getName();
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, "changing the action name from '" + oldName + "' to '" + name + "'");
        }
        this.setName(name);
        if (!this.getName().equals(oldName)) {
            this.modifiedName = true;
        }
    }

    boolean isNameModified() {
        return this.modifiedName;
    }

    static {
        outstandingGaua = Collections.synchronizedList(new ArrayList(5));
    }
}

