/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import com.dynatrace.android.agent.comm.InvalidConfigurationException;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.conf.RageTapConfiguration;
import com.dynatrace.android.agent.conf.ReplayConfiguration;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.conf.ServerConfigurationParser;
import com.dynatrace.android.agent.conf.SessionSplitConfiguration;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.internal.api.SelfMonitoring;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ServerConfigurationManager
implements ServerConfigurationParser {
    private static final ServerConfiguration CONFIG_AGENT_ERROR = new ServerConfiguration.Builder().withCaptureOff().withStatus(ServerConfiguration.Status.ERROR).build();
    private static final ServerConfiguration CONFIG_INIT_MEMORY = new ServerConfiguration.Builder().withTimestamp(-1L).build();
    private static final String KEY_MOBILE_AGENT_CONFIG = "mobileAgentConfig";
    private static final String KEY_APP_CONFIG = "appConfig";
    private static final String KEY_DYNAMIC_CONFIG = "dynamicConfig";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_REPLAY_CONFIG = "replayConfig";
    private static final String KEY_MAX_BEACON_SIZE_KB = "maxBeaconSizeKb";
    private static final String KEY_SELFMONITORING = "selfmonitoring";
    private static final String KEY_MAX_SESSION_DURATION_MINS = "maxSessionDurationMins";
    private static final String KEY_SESSION_TIMEOUT_SEC = "sessionTimeoutSec";
    private static final String KEY_SEND_INTERVAL_SEC = "sendIntervalSec";
    private static final String KEY_VISIT_STORE_VERSION = "visitStoreVersion";
    private static final String KEY_MAX_CACHED_CRASHES = "maxCachedCrashesCount";
    private static final String KEY_RAGE_TAP_CONFIG = "rageTapConfig";
    private static final String KEY_TAP_DURATION = "tapDuration";
    private static final String KEY_DISPERSION_RADIUS = "dispersionRadius";
    private static final String KEY_TIMESPAN_DIFFERENCE = "timespanDifference";
    private static final String KEY_MINIMUM_NUMBER_OF_TAPS = "minimumNumberOfTaps";
    private static final String KEY_CAPTURE = "capture";
    private static final String KEY_TRAFFIC_CONTROL_PERCENTAGE = "trafficControlPercentage";
    private static final String KEY_APPLICATION_ID = "applicationId";
    private static final String KEY_REPLAY_CAPTURE = "capture";
    private static final String KEY_REPLAY_RETENTION_TIME = "imageRetentionTimeInMinutes";
    private static final String KEY_REPLAY_PROTOCOL_VERSION = "protocolVersion";
    private static final String KEY_REPLAY_SELFMONITORING = "selfmonitoring";
    private static final String KEY_MULTIPLICITY = "multiplicity";
    private static final String KEY_SERVERID = "serverId";
    private static final String KEY_SWITCH_SERVER = "switchServer";
    private static final String KEY_STATUS = "status";
    private final String appIdEncoded;

    public ServerConfigurationManager(String appIdEncoded) {
        this.appIdEncoded = appIdEncoded;
    }

    @Override
    public ServerConfiguration fromJSON(ServerConfiguration oldServerConfig, String json) throws JSONException, ClassCastException, InvalidConfigurationException {
        String status;
        ServerConfiguration.Builder newConfig;
        boolean isFullConfig;
        JSONObject rootObject = (JSONObject)new JSONTokener(json).nextValue();
        if (!rootObject.has(KEY_DYNAMIC_CONFIG)) {
            throw new InvalidConfigurationException("The configuration is missing the dynamicConfig block");
        }
        boolean bl = isFullConfig = rootObject.has(KEY_TIMESTAMP) && rootObject.has(KEY_APP_CONFIG) && rootObject.has(KEY_MOBILE_AGENT_CONFIG);
        if (!isFullConfig) {
            newConfig = oldServerConfig.newBuilder(true);
        } else {
            JSONObject appJsonObject;
            int visitStoreVersion;
            newConfig = ServerConfiguration.builder();
            long newTimestamp = rootObject.getLong(KEY_TIMESTAMP);
            if (newTimestamp <= oldServerConfig.getTimestamp()) {
                return oldServerConfig;
            }
            newConfig.withTimestamp(newTimestamp);
            JSONObject agentJsonObject = rootObject.getJSONObject(KEY_MOBILE_AGENT_CONFIG);
            if (agentJsonObject.has(KEY_MAX_BEACON_SIZE_KB)) {
                newConfig.withMaxBeaconSizeKb(this.fitOrClosest(agentJsonObject.getInt(KEY_MAX_BEACON_SIZE_KB), 10, Integer.MAX_VALUE));
            }
            if (agentJsonObject.has("selfmonitoring")) {
                newConfig.withSelfmonitoring(agentJsonObject.getBoolean("selfmonitoring"));
            }
            newConfig.withSessionSplitConfiguration(this.parseSessionSplitConfiguration(agentJsonObject));
            if (agentJsonObject.has(KEY_SEND_INTERVAL_SEC)) {
                newConfig.withSendIntervalSec(this.fitOrClosest(agentJsonObject.getInt(KEY_SEND_INTERVAL_SEC), 10, 120));
            }
            if (agentJsonObject.has(KEY_VISIT_STORE_VERSION) && (visitStoreVersion = agentJsonObject.getInt(KEY_VISIT_STORE_VERSION)) != 2) {
                SelfMonitoring.reportLogEvent("SelfMonitoringUnexpectedVisitStoreVersion", "unexpected visitstore version - expected 2 but received " + visitStoreVersion + ".");
            }
            if (agentJsonObject.has(KEY_MAX_CACHED_CRASHES)) {
                newConfig.withMaxCachedCrashesCount(this.fitOrClosest(agentJsonObject.getInt(KEY_MAX_CACHED_CRASHES), 0, 100));
            }
            if (agentJsonObject.has(KEY_RAGE_TAP_CONFIG)) {
                JSONObject rageTapConfigObject = agentJsonObject.getJSONObject(KEY_RAGE_TAP_CONFIG);
                newConfig.withRageTapConfiguration(this.parseRageTapConfiguration(rageTapConfigObject));
            }
            if ((appJsonObject = rootObject.getJSONObject(KEY_APP_CONFIG)).has(KEY_APPLICATION_ID) && !this.appIdEncoded.equals(appJsonObject.getString(KEY_APPLICATION_ID))) {
                return CONFIG_AGENT_ERROR;
            }
            if (appJsonObject.has("capture")) {
                newConfig.withCapture(this.fitOrDefault(appJsonObject.getInt("capture"), 0, 1, 1));
            }
            if (appJsonObject.has(KEY_TRAFFIC_CONTROL_PERCENTAGE)) {
                newConfig.withTrafficControlPercentage(this.fitOrDefault(appJsonObject.getInt(KEY_TRAFFIC_CONTROL_PERCENTAGE), 1, 100, 100));
            }
            newConfig.withReplayConfiguration(this.parseReplayConfiguration(agentJsonObject, appJsonObject));
        }
        JSONObject jsonObject = rootObject.getJSONObject(KEY_DYNAMIC_CONFIG);
        if (jsonObject.has(KEY_STATUS) && (status = jsonObject.getString(KEY_STATUS)).compareToIgnoreCase("ERROR") == 0) {
            return CONFIG_AGENT_ERROR;
        }
        newConfig.withStatus(ServerConfiguration.Status.OK);
        if (jsonObject.has(KEY_MULTIPLICITY)) {
            newConfig.withMultiplicity(this.fitOrDefault(jsonObject.getInt(KEY_MULTIPLICITY), 0, Integer.MAX_VALUE, 1));
        }
        if (jsonObject.has(KEY_SERVERID)) {
            newConfig.withServerId(this.fitOrDefault(jsonObject.getInt(KEY_SERVERID), 0, Integer.MAX_VALUE, 1));
        }
        if (jsonObject.has(KEY_SWITCH_SERVER)) {
            newConfig.withSwitchServer(jsonObject.getBoolean(KEY_SWITCH_SERVER));
        }
        return newConfig.build();
    }

    SessionSplitConfiguration parseSessionSplitConfiguration(JSONObject mobileAgentConfigJson) throws JSONException {
        SessionSplitConfiguration.Builder sessionSplitConfigBuilder = SessionSplitConfiguration.builder();
        if (mobileAgentConfigJson.has(KEY_MAX_SESSION_DURATION_MINS)) {
            sessionSplitConfigBuilder.withMaxSessionDuration(this.fitOrClosest(mobileAgentConfigJson.getInt(KEY_MAX_SESSION_DURATION_MINS), 10, Integer.MAX_VALUE));
        }
        if (mobileAgentConfigJson.has(KEY_SESSION_TIMEOUT_SEC)) {
            sessionSplitConfigBuilder.withInactivityTimeout(this.fitOrClosest(mobileAgentConfigJson.getInt(KEY_SESSION_TIMEOUT_SEC), 30, Integer.MAX_VALUE));
        }
        return sessionSplitConfigBuilder.build();
    }

    ReplayConfiguration parseReplayConfiguration(JSONObject mobileAgentConfiguration, JSONObject appConfiguration) throws JSONException {
        JSONObject replayConfigObject;
        ReplayConfiguration.Builder replayConfigBuilder = ReplayConfiguration.builder();
        if (mobileAgentConfiguration.has(KEY_REPLAY_CONFIG)) {
            replayConfigObject = mobileAgentConfiguration.getJSONObject(KEY_REPLAY_CONFIG);
            if (replayConfigObject.has(KEY_REPLAY_PROTOCOL_VERSION)) {
                replayConfigBuilder.withProtocolVersion(this.fitOrClosest(replayConfigObject.getInt(KEY_REPLAY_PROTOCOL_VERSION), 1, Short.MAX_VALUE));
            }
            if (replayConfigObject.has("selfmonitoring")) {
                replayConfigBuilder.withSelfMonitoring(this.fitOrClosest(replayConfigObject.getInt("selfmonitoring"), 0, Integer.MAX_VALUE));
            }
        }
        if (appConfiguration.has(KEY_REPLAY_CONFIG)) {
            replayConfigObject = appConfiguration.getJSONObject(KEY_REPLAY_CONFIG);
            if (replayConfigObject.has("capture")) {
                replayConfigBuilder.withCapture(replayConfigObject.getBoolean("capture"));
            }
            if (replayConfigObject.has(KEY_REPLAY_RETENTION_TIME)) {
                replayConfigBuilder.withRetentionTimeInMinutes(this.fitOrClosest(replayConfigObject.getInt(KEY_REPLAY_RETENTION_TIME), 0, Integer.MAX_VALUE));
            }
        }
        return replayConfigBuilder.build();
    }

    RageTapConfiguration parseRageTapConfiguration(JSONObject rageTapConfigObject) throws JSONException {
        RageTapConfiguration.Builder rageTapConfigBuilder = RageTapConfiguration.builder();
        if (rageTapConfigObject.has(KEY_TAP_DURATION)) {
            rageTapConfigBuilder.withTapDuration(this.fitOrClosest(rageTapConfigObject.getInt(KEY_TAP_DURATION), 0, Integer.MAX_VALUE));
        }
        if (rageTapConfigObject.has(KEY_DISPERSION_RADIUS)) {
            rageTapConfigBuilder.withDispersionRadius(this.fitOrClosest(rageTapConfigObject.getInt(KEY_DISPERSION_RADIUS), 0, Integer.MAX_VALUE));
        }
        if (rageTapConfigObject.has(KEY_TIMESPAN_DIFFERENCE)) {
            rageTapConfigBuilder.withTimespanDifference(this.fitOrClosest(rageTapConfigObject.getInt(KEY_TIMESPAN_DIFFERENCE), 0, Integer.MAX_VALUE));
        }
        if (rageTapConfigObject.has(KEY_MINIMUM_NUMBER_OF_TAPS)) {
            rageTapConfigBuilder.withMinimumNumberOfTaps(this.fitOrClosest(rageTapConfigObject.getInt(KEY_MINIMUM_NUMBER_OF_TAPS), 3, Integer.MAX_VALUE));
        }
        return rageTapConfigBuilder.build();
    }

    @Override
    public ServerConfiguration fromMap(Map<String, String> keyValueConfig, AgentMode agentMode) {
        ServerConfiguration.Builder newConfig = new ServerConfiguration.Builder();
        newConfig.withCapture(Utility.parseInt(keyValueConfig, "cp", 0, 1, 1, true));
        newConfig.withSendIntervalSec(Utility.parseInt(keyValueConfig, "si", 60, 540, 120));
        newConfig.withServerId(Utility.parseInt(keyValueConfig, "id", 0, Integer.MAX_VALUE, 1));
        newConfig.withMaxBeaconSizeKb(Utility.parseInt(keyValueConfig, "bl", 1, Integer.MAX_VALUE, agentMode == AgentMode.APP_MON ? 30 : 150));
        SessionSplitConfiguration splitConfig = SessionSplitConfiguration.builder().withInactivityTimeout(Utility.parseInt(keyValueConfig, "st", 0, Integer.MAX_VALUE, 600)).build();
        newConfig.withSessionSplitConfiguration(splitConfig);
        newConfig.withTrafficControlPercentage(Utility.parseInt(keyValueConfig, "tc", 1, 100, 100, true));
        newConfig.withMultiplicity(Utility.parseInt(keyValueConfig, "mp", 0, Integer.MAX_VALUE, 1, true));
        newConfig.withSelfmonitoring(Utility.parseInt(keyValueConfig, "sm", 0, 1, 1, true) == 1);
        return newConfig.build();
    }

    private int fitOrDefault(int value, int lowerBorder, int higherBorder, int defaultValue) {
        return this.fit(value, lowerBorder, higherBorder, defaultValue, defaultValue);
    }

    private int fitOrClosest(int value, int lowerBorder, int higherBorder) {
        return this.fit(value, lowerBorder, higherBorder, lowerBorder, higherBorder);
    }

    private int fit(int value, int lowerBorder, int higherBorder, int lowerCap, int higherCap) {
        if (value < lowerBorder) {
            return lowerCap;
        }
        if (value > higherBorder) {
            return higherCap;
        }
        return value;
    }

    public String generateStorableConfiguration(ServerConfiguration serverConfig) throws JSONException {
        JSONObject rootObject = new JSONObject();
        rootObject.put(KEY_MOBILE_AGENT_CONFIG, (Object)this.generateMobileAgentConfiguration(serverConfig));
        rootObject.put(KEY_APP_CONFIG, (Object)this.generateAppConfiguration(serverConfig));
        rootObject.put(KEY_DYNAMIC_CONFIG, (Object)this.generateDynamicConfiguration(serverConfig));
        rootObject.put(KEY_TIMESTAMP, 0L);
        return rootObject.toString();
    }

    private JSONObject generateMobileAgentConfiguration(ServerConfiguration serverConfig) throws JSONException {
        JSONObject rootObject = new JSONObject();
        rootObject.put(KEY_MAX_BEACON_SIZE_KB, serverConfig.getMaxBeaconSizeKb());
        rootObject.put("selfmonitoring", serverConfig.isSelfmonitoring());
        SessionSplitConfiguration sessionSplitConfig = serverConfig.getSessionSplitConfiguration();
        rootObject.put(KEY_MAX_SESSION_DURATION_MINS, sessionSplitConfig.getMaxSessionDurationMinutes());
        rootObject.put(KEY_SESSION_TIMEOUT_SEC, sessionSplitConfig.getInactivityTimeoutSeconds());
        rootObject.put(KEY_SEND_INTERVAL_SEC, serverConfig.getSendIntervalSec());
        rootObject.put(KEY_MAX_CACHED_CRASHES, serverConfig.getMaxCachedCrashesCount());
        rootObject.put(KEY_RAGE_TAP_CONFIG, (Object)this.generateRageTapConfiguration(serverConfig));
        rootObject.put(KEY_REPLAY_CONFIG, (Object)this.generateReplayConfigurationMobileAgent(serverConfig));
        return rootObject;
    }

    private JSONObject generateAppConfiguration(ServerConfiguration serverConfig) throws JSONException {
        JSONObject rootObject = new JSONObject();
        rootObject.put(KEY_REPLAY_CONFIG, (Object)this.generateReplayConfigurationApp(serverConfig));
        return rootObject;
    }

    private JSONObject generateReplayConfigurationMobileAgent(ServerConfiguration serverConfig) throws JSONException {
        ReplayConfiguration replayConfiguration = serverConfig.getReplayConfiguration();
        JSONObject replayConfigObject = new JSONObject();
        replayConfigObject.put(KEY_REPLAY_PROTOCOL_VERSION, replayConfiguration.getProtocolVersion());
        return replayConfigObject;
    }

    private JSONObject generateReplayConfigurationApp(ServerConfiguration serverConfig) throws JSONException {
        ReplayConfiguration replayConfiguration = serverConfig.getReplayConfiguration();
        JSONObject replayConfigObject = new JSONObject();
        replayConfigObject.put("capture", replayConfiguration.isCaptureOn());
        replayConfigObject.put(KEY_REPLAY_RETENTION_TIME, replayConfiguration.getRetentionTimeInMinutes());
        return replayConfigObject;
    }

    private JSONObject generateRageTapConfiguration(ServerConfiguration serverConfig) throws JSONException {
        RageTapConfiguration rageTapConfiguration = serverConfig.getRageTapConfiguration();
        JSONObject rageTapConfigObject = new JSONObject();
        rageTapConfigObject.put(KEY_TAP_DURATION, rageTapConfiguration.getTapDuration());
        rageTapConfigObject.put(KEY_DISPERSION_RADIUS, rageTapConfiguration.getDispersionRadius());
        rageTapConfigObject.put(KEY_TIMESPAN_DIFFERENCE, rageTapConfiguration.getTimespanDifference());
        rageTapConfigObject.put(KEY_MINIMUM_NUMBER_OF_TAPS, rageTapConfiguration.getMinimumNumberOfTaps());
        return rageTapConfigObject;
    }

    private JSONObject generateDynamicConfiguration(ServerConfiguration serverConfig) throws JSONException {
        JSONObject rootObject = new JSONObject();
        rootObject.put(KEY_SERVERID, serverConfig.getServerId());
        return rootObject;
    }

    public ServerConfiguration fromMemory(String json) throws InvalidConfigurationException, JSONException {
        ServerConfiguration memoryConfig = this.fromJSON(CONFIG_INIT_MEMORY, json);
        if (memoryConfig.getStatus() != ServerConfiguration.Status.OK) {
            throw new InvalidConfigurationException("unexpected status code: " + (Object)((Object)memoryConfig.getStatus()));
        }
        return memoryConfig;
    }
}

