/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.events.lifecycle.FinishedActionObserver;
import com.dynatrace.android.agent.events.lifecycle.StoreActionObserver;
import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.ActionAggregator;
import com.dynatrace.android.lifecycle.action.LifecycleAction;
import com.dynatrace.android.lifecycle.action.LifecycleActionFactory;
import com.dynatrace.android.lifecycle.callback.ComponentIdentity;
import com.dynatrace.android.lifecycle.event.ActivityEventType;
import com.dynatrace.android.lifecycle.event.LifecycleEvent;
import com.dynatrace.android.useraction.UserAction;
import java.util.HashMap;
import java.util.Map;

public class LifecycleController {
    private static final String LOG_TAG = Global.LOG_PREFIX + "LifecycleController";
    private final Map<ComponentIdentity, LifecycleAction<ActivityEventType>> actionMap;
    private final LifecycleActionFactory actionFactory;
    private final FinishedActionObserver finishedActionObserver;
    private final StoreActionObserver storeActionObserver;
    private final MeasurementProvider measurementProvider;
    private final ActionAggregator actionAggregator;

    public LifecycleController(LifecycleActionFactory actionFactory, FinishedActionObserver finishedActionObserver, StoreActionObserver storeActionObserver, MeasurementProvider measurementProvider, ActionAggregator actionAggregator) {
        this.actionFactory = actionFactory;
        this.finishedActionObserver = finishedActionObserver;
        this.storeActionObserver = storeActionObserver;
        this.measurementProvider = measurementProvider;
        this.actionAggregator = actionAggregator;
        this.actionMap = new HashMap<ComponentIdentity, LifecycleAction<ActivityEventType>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEvent(ComponentIdentity componentIdentity, ActivityEventType eventType) {
        MeasurementPoint pointOfEventCreation;
        LifecycleAction<ActivityEventType> lifecycleAction = this.actionMap.get(componentIdentity);
        if (lifecycleAction != null) {
            pointOfEventCreation = this.measurementProvider.measure();
        } else {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "start activity monitoring for " + componentIdentity);
            }
            MeasurementPoint userActionStartPoint = this.measurementProvider.measure();
            MeasurementPoint actionStartPoint = this.measurementProvider.measure();
            pointOfEventCreation = this.measurementProvider.measure();
            UserAction parentAction = this.actionAggregator.determineUserAction(componentIdentity.getComponentName(), userActionStartPoint);
            lifecycleAction = this.actionFactory.createActivityLifecycleAction(componentIdentity.getComponentName(), parentAction, actionStartPoint);
            this.actionAggregator.aggregateAction(lifecycleAction, parentAction, this);
            this.actionMap.put(componentIdentity, lifecycleAction);
        }
        LifecycleEvent<ActivityEventType> lcEvent = new LifecycleEvent<ActivityEventType>(eventType, pointOfEventCreation);
        LifecycleAction<ActivityEventType> lifecycleAction2 = lifecycleAction;
        synchronized (lifecycleAction2) {
            lifecycleAction.addEvent(lcEvent);
        }
    }

    public void onLifecycleCompleted(ComponentIdentity componentIdentity) {
        LifecycleAction<ActivityEventType> lifecycleAction = this.actionMap.remove(componentIdentity);
        if (lifecycleAction == null) {
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD(LOG_TAG, "finish activity monitoring for " + componentIdentity);
        }
        if (lifecycleAction.isFinalized().compareAndSet(false, true)) {
            lifecycleAction.setEndPoint(this.measurementProvider.measure());
            this.finishedActionObserver.onActivityLifecycleAction(lifecycleAction);
        }
    }

    public void onUserActionClosed(LifecycleAction<ActivityEventType> lifecycleAction) {
        if (lifecycleAction.isFinalized().compareAndSet(false, true)) {
            lifecycleAction.setEndPoint(this.measurementProvider.measure());
            this.storeActionObserver.onActivityLifecycleAction(lifecycleAction);
        }
    }
}

