/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.appstart;

import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.useraction.AppStartPlaceholderSegment;
import com.dynatrace.android.useraction.UserAction;

public class AppStartAction {
    private final String name;
    private final MeasurementPoint startPoint;
    private final UserAction parentAction;
    private final MeasurementPoint endPoint;
    @Deprecated
    private final AppStartPlaceholderSegment placeholderSegment;

    private AppStartAction(Builder builder) {
        this.name = builder.getName();
        this.startPoint = builder.getStartPoint();
        this.parentAction = builder.getParentAction();
        this.placeholderSegment = builder.getPlaceholderSegment();
        this.endPoint = builder.getEndPoint();
    }

    public String getName() {
        return this.name;
    }

    public MeasurementPoint getStartPoint() {
        return this.startPoint;
    }

    public MeasurementPoint getEndPoint() {
        return this.endPoint;
    }

    public UserAction getParentAction() {
        return this.parentAction;
    }

    public AppStartPlaceholderSegment getPlaceholderSegment() {
        return this.placeholderSegment;
    }

    public String toString() {
        return "AppStartAction{name='" + this.name + '\'' + ", startPoint=" + this.startPoint + ", parentAction=" + this.parentAction + ", endPoint=" + this.endPoint + '}';
    }

    public static class Builder {
        private String name;
        private MeasurementPoint startPoint;
        private MeasurementPoint endPoint;
        private UserAction parentAction;
        @Deprecated
        private AppStartPlaceholderSegment placeholderSegment;

        String getName() {
            return this.name;
        }

        MeasurementPoint getStartPoint() {
            return this.startPoint;
        }

        MeasurementPoint getEndPoint() {
            return this.endPoint;
        }

        UserAction getParentAction() {
            return this.parentAction;
        }

        AppStartPlaceholderSegment getPlaceholderSegment() {
            return this.placeholderSegment;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withStartPoint(MeasurementPoint startPoint) {
            this.startPoint = startPoint;
            return this;
        }

        public Builder withEndPoint(MeasurementPoint endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public Builder withParentAction(UserAction parentAction) {
            this.parentAction = parentAction;
            return this;
        }

        @Deprecated
        public Builder withPlaceholderSegment(AppStartPlaceholderSegment placeholderSegment) {
            this.placeholderSegment = placeholderSegment;
            return this;
        }

        public AppStartAction build() {
            return new AppStartAction(this);
        }
    }
}

