/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.appstart;

import android.app.Application;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.events.lifecycle.AppStartActionObserverImpl;
import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.agent.measurement.MeasurementProviderImpl;
import com.dynatrace.android.lifecycle.appstart.ActivityStateListener;
import com.dynatrace.android.lifecycle.appstart.AppStartController;
import com.dynatrace.android.useraction.AppStartAggregatorImpl;
import com.dynatrace.android.useraction.LoadingActionNameGenerator;

public class ApplicationStartMonitor {
    private ActivityStateListener activityStateListener;
    private AppStartController controller;

    public void onAgentStart(Application application, TimeLineProvider timeLineProvider) {
        MeasurementProviderImpl measurementProvider = new MeasurementProviderImpl(timeLineProvider);
        this.controller = new AppStartController(measurementProvider, new AppStartAggregatorImpl(new LoadingActionNameGenerator()), new AppStartActionObserverImpl(), application);
        this.activityStateListener = this.controller.getActivityStateListener();
    }

    public void onAgentShutdown(Application application) {
        if (this.activityStateListener != null) {
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityStateListener);
            this.activityStateListener = null;
            this.controller = null;
        }
    }

    public void onApplicationStart(TimeLineProvider timeLineProvider) {
        if (this.controller == null) {
            return;
        }
        MeasurementProviderImpl measurementProvider = new MeasurementProviderImpl(timeLineProvider);
        MeasurementPoint userActionStartPoint = measurementProvider.measure();
        MeasurementPoint appStartPoint = measurementProvider.measure();
        String applicationName = AdkSettings.applName;
        if (applicationName == null || applicationName.isEmpty()) {
            applicationName = "null";
        }
        this.controller.appStart(applicationName, userActionStartPoint, appStartPoint);
    }
}

