/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose;

import com.dynatrace.android.compose.ClickableInfo;
import com.dynatrace.android.compose.SwipeableInfo;
import com.dynatrace.android.compose.ToggleableInfo;
import com.dynatrace.android.useraction.ActionNameGenerator;

public class ClassBasedActionNameGenerator
implements ActionNameGenerator {
    public static final String COMPONENT = "component";
    private final String actionName;

    public ClassBasedActionNameGenerator(ClickableInfo clickableInfo, String semanticsName) {
        String component = clickableInfo.getRole() == null ? COMPONENT : clickableInfo.getRole().toString();
        this.actionName = semanticsName != null ? "Touch on " + semanticsName : "Touch on " + component + " with function " + this.classNameWithoutPackage(clickableInfo.getFunction().getClass().getName());
    }

    public ClassBasedActionNameGenerator(ToggleableInfo toggleableInfo, String semanticsName) {
        String component = toggleableInfo.getRole() == null ? COMPONENT : toggleableInfo.getRole().toString();
        this.actionName = semanticsName != null ? "Touch on " + semanticsName : "Touch on " + component + " with function " + this.classNameWithoutPackage(toggleableInfo.getSourceName());
    }

    public ClassBasedActionNameGenerator(SwipeableInfo swipeableInfo, String semanticsName) {
        this.actionName = semanticsName != null ? "Swipe " + semanticsName + " to " + this.classNameWithoutPackage(swipeableInfo.getSourceName() + " " + swipeableInfo.getToState()) : "Swipe to " + this.classNameWithoutPackage(swipeableInfo.getSourceName() + " " + swipeableInfo.getToState());
    }

    private String classNameWithoutPackage(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public String generateActionName() {
        return this.actionName;
    }
}

