/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose;

import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.compose.ClickableInfo;
import com.dynatrace.android.useraction.ActionNameGenerator;
import com.dynatrace.android.useraction.UserAction;
import com.dynatrace.android.useraction.UserActionFactory;
import kotlin.jvm.functions.Function0;

public class ClickActionRecorder {
    private static final String ROLE = "role";
    private static final String FUNCTION = "function";
    private static final String INTERACTION_TYPE = "type";
    private final ActionNameGenerator actionNameGenerator;
    private final MeasurementProvider measurementProvider;
    private final UserActionFactory userActionFactory;
    private final ClickableInfo clickableInfo;

    public ClickActionRecorder(ActionNameGenerator nameGenerator, MeasurementProvider measurementProvider, UserActionFactory userActionFactory, ClickableInfo clickableInfo) {
        this.actionNameGenerator = nameGenerator;
        this.measurementProvider = measurementProvider;
        this.userActionFactory = userActionFactory;
        this.clickableInfo = clickableInfo;
    }

    public Object invokeFunction(Function0 function) {
        UserAction action = this.userActionFactory.createUserAction(this.actionNameGenerator.generateActionName(), this.measurementProvider.measure());
        action.reportValue(ROLE, String.valueOf(this.clickableInfo.getRole()));
        action.reportValue(FUNCTION, this.clickableInfo.getFunction().getClass().getName());
        action.reportValue(INTERACTION_TYPE, this.clickableInfo.getInteractionType());
        Object result = function.invoke();
        action.startTimer();
        return result;
    }
}

