/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose;

import androidx.compose.ui.semantics.Role;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.agent.measurement.MeasurementProviderImpl;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.compose.ClassBasedActionNameGenerator;
import com.dynatrace.android.compose.ClickActionRecorder;
import com.dynatrace.android.compose.ClickableInfo;
import com.dynatrace.android.compose.SemanticsManager;
import com.dynatrace.android.compose.ToggleActionRecorder;
import com.dynatrace.android.compose.ToggleableDataProvider;
import com.dynatrace.android.compose.ToggleableInfo;
import com.dynatrace.android.useraction.UserActionFactory;
import com.dynatrace.android.useraction.UserActionFactoryImpl;
import kotlin.jvm.functions.Function0;

public class ClickableComposeCallback
implements Function0 {
    private static final String TAG = Global.LOG_PREFIX + "ClickableCompose";
    private final Role role;
    private final Function0 function;
    private final String type;

    public ClickableComposeCallback(Function0 function, Role role, String type) {
        this.role = role;
        this.function = function;
        this.type = type;
    }

    public Object invoke() {
        if (!Global.isAlive.get()) {
            return this.function.invoke();
        }
        MeasurementProviderImpl measurementProvider = new MeasurementProviderImpl(TimeLineProvider.globalTimeLineProvider);
        UserActionFactoryImpl userActionFactory = new UserActionFactoryImpl();
        if (this.function instanceof ToggleableDataProvider) {
            ToggleableDataProvider provider = (ToggleableDataProvider)this.function;
            ToggleableInfo toggleableInfo = new ToggleableInfo(provider.providesToggleableState(), this.role, provider.providesSourceName());
            ClassBasedActionNameGenerator nameGenerator = new ClassBasedActionNameGenerator(toggleableInfo, SemanticsManager.INSTANCE.fetchNameAndClear());
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)("onUA: " + toggleableInfo));
            }
            ToggleActionRecorder clickActionRecorder = new ToggleActionRecorder(nameGenerator, (MeasurementProvider)measurementProvider, (UserActionFactory)userActionFactory, toggleableInfo);
            return clickActionRecorder.invokeFunction(this.function);
        }
        ClickableInfo clickableInfo = new ClickableInfo(this.type, this.role, this.function);
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("onUA: " + clickableInfo));
        }
        ClassBasedActionNameGenerator nameGenerator = new ClassBasedActionNameGenerator(clickableInfo, SemanticsManager.INSTANCE.fetchNameAndClear());
        ClickActionRecorder clickActionRecorder = new ClickActionRecorder(nameGenerator, (MeasurementProvider)measurementProvider, (UserActionFactory)userActionFactory, clickableInfo);
        return clickActionRecorder.invokeFunction(this.function);
    }
}

