/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose;

import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.compose.SwipeableInfo;
import com.dynatrace.android.useraction.ActionNameGenerator;
import com.dynatrace.android.useraction.UserAction;
import com.dynatrace.android.useraction.UserActionFactory;

public class SwipeActionRecorder {
    private static final String STATE = "state class";
    private static final String FROM_STATE = "fromState";
    private static final String TO_STATE = "toState";
    private static final String TYPE = "type";
    private static final String TYPE_SWIPE = "swipe";
    private final ActionNameGenerator actionNameGenerator;
    private final MeasurementProvider measurementProvider;
    private final UserActionFactory userActionFactory;
    private final SwipeableInfo swipeableInfo;

    public SwipeActionRecorder(ActionNameGenerator nameGenerator, MeasurementProvider measurementProvider, UserActionFactory userActionFactory, SwipeableInfo swipeableInfo) {
        this.actionNameGenerator = nameGenerator;
        this.measurementProvider = measurementProvider;
        this.userActionFactory = userActionFactory;
        this.swipeableInfo = swipeableInfo;
    }

    public void invoke() {
        UserAction action = this.userActionFactory.createUserAction(this.actionNameGenerator.generateActionName(), this.measurementProvider.measure());
        action.reportValue(STATE, this.swipeableInfo.getSourceName());
        action.reportValue(FROM_STATE, this.swipeableInfo.getFromState());
        action.reportValue(TO_STATE, this.swipeableInfo.getToState());
        action.reportValue(TYPE, TYPE_SWIPE);
        action.startTimer();
    }
}

