/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose;

import androidx.compose.material.SwipeableState;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.agent.measurement.MeasurementProviderImpl;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.compose.ClassBasedActionNameGenerator;
import com.dynatrace.android.compose.SemanticsManager;
import com.dynatrace.android.compose.SwipeActionRecorder;
import com.dynatrace.android.compose.SwipeableInfo;
import com.dynatrace.android.useraction.UserActionFactory;
import com.dynatrace.android.useraction.UserActionFactoryImpl;

public final class SwipeableComposeCallback {
    private static final String TAG = Global.LOG_PREFIX + "SwipeableCompose";

    private SwipeableComposeCallback() {
    }

    public static void enterAction(SwipeableState state) {
        if (!Global.isAlive.get()) {
            return;
        }
        MeasurementProviderImpl measurementProvider = new MeasurementProviderImpl(TimeLineProvider.globalTimeLineProvider);
        UserActionFactoryImpl userActionFactory = new UserActionFactoryImpl();
        SwipeableInfo swipeableInfo = new SwipeableInfo(state.getCurrentValue(), state.getTargetValue(), state);
        ClassBasedActionNameGenerator nameGenerator = new ClassBasedActionNameGenerator(swipeableInfo, SemanticsManager.INSTANCE.fetchNameAndClear());
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("onUA: " + swipeableInfo));
        }
        SwipeActionRecorder swipeActionRecorder = new SwipeActionRecorder(nameGenerator, (MeasurementProvider)measurementProvider, (UserActionFactory)userActionFactory, swipeableInfo);
        swipeActionRecorder.invoke();
    }
}

