/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose;

import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.compose.ToggleableInfo;
import com.dynatrace.android.useraction.ActionNameGenerator;
import com.dynatrace.android.useraction.UserAction;
import com.dynatrace.android.useraction.UserActionFactory;
import kotlin.jvm.functions.Function0;

public class ToggleActionRecorder {
    private static final String ROLE = "role";
    private static final String FUNCTION = "function";
    private static final String FROM_STATE = "fromState";
    private static final String TYPE = "type";
    private static final String TYPE_TOGGLE = "toggle";
    private final ActionNameGenerator actionNameGenerator;
    private final MeasurementProvider measurementProvider;
    private final UserActionFactory userActionFactory;
    private final ToggleableInfo toggleableInfo;

    public ToggleActionRecorder(ActionNameGenerator nameGenerator, MeasurementProvider measurementProvider, UserActionFactory userActionFactory, ToggleableInfo toggleableInfo) {
        this.actionNameGenerator = nameGenerator;
        this.measurementProvider = measurementProvider;
        this.userActionFactory = userActionFactory;
        this.toggleableInfo = toggleableInfo;
    }

    public Object invokeFunction(Function0 function) {
        UserAction action = this.userActionFactory.createUserAction(this.actionNameGenerator.generateActionName(), this.measurementProvider.measure());
        action.reportValue(ROLE, String.valueOf(this.toggleableInfo.getRole()));
        action.reportValue(FUNCTION, this.toggleableInfo.getSourceName());
        action.reportValue(FROM_STATE, this.toggleableInfo.getState().name());
        action.reportValue(TYPE, TYPE_TOGGLE);
        Object result = function.invoke();
        action.startTimer();
        return result;
    }
}

