/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.WebReqStateParms;
import java.net.URL;
import java.util.List;
import java.util.Map;
import okhttp3.Request;
import okhttp3.Response;

class OkRequestStateParms
extends WebReqStateParms {
    private static final String LOGTAG = Global.LOG_PREFIX + "OkRequestStateParms";
    Request request;

    OkRequestStateParms(Request request, CbConstants.WrMethod method, CbConstants.WrStates state, int respCode) {
        super(method, state, respCode);
        this.request = request;
    }

    String getRequestDesc() {
        return Utility.truncateWebRequest((String)this.request.url().toString());
    }

    String getRequestHost() {
        return this.request.url().host();
    }

    String getRequestMethod() {
        return this.request.method();
    }

    URL getUrl() {
        return this.request.url().url();
    }

    protected String getRequestClassName() {
        return this.getRequestClassName(this.request);
    }

    void calcHttpMessageBytes(Response resp) {
        Response networkResponse = resp.networkResponse();
        if (networkResponse != null) {
            try {
                Request networkRequest = networkResponse.request();
                long protocolLength = networkResponse.protocol().toString().length();
                this.requestLength = (long)(networkRequest.method().length() + networkRequest.url().url().getFile().length()) + protocolLength + 4L + this.calcHeader(networkRequest.headers().toMultimap()) + 2L;
                this.responseLength = protocolLength + (long)String.valueOf(networkResponse.code()).length() + (long)networkResponse.message().length() + 4L + this.calcHeader(networkResponse.headers().toMultimap()) + 2L;
            }
            catch (Exception e) {
                if (Global.DEBUG) {
                    Utility.zlogD((String)LOGTAG, (String)e.getMessage(), (Throwable)e);
                }
                this.requestLength = -1L;
                this.responseLength = -1L;
            }
        }
    }

    private long calcHeader(Map<String, List<String>> headers) {
        long length = 0L;
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            long keyLength = header.getKey().length() + 4;
            for (String value : header.getValue()) {
                length += keyLength + (long)value.length();
            }
            if (!"Content-Length".equalsIgnoreCase(header.getKey()) || header.getValue().size() <= 0) continue;
            try {
                length += Long.parseLong(header.getValue().get(0));
            }
            catch (NumberFormatException e) {
                if (!Global.DEBUG) continue;
                Utility.zlogD((String)LOGTAG, (String)"invalid content length", (Throwable)e);
            }
        }
        return length;
    }
}

