/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

public final class RageTapConfiguration {
    static final RageTapConfiguration DEFAULT_RAGE_TAP_CONFIGURATION = RageTapConfiguration.builder().build();
    private static final int DEFAULT_TAP_DURATION = 100;
    private static final int DEFAULT_DISPERSION_RADIUS = 100;
    private static final int DEFAULT_TIMESPAN_DIFFERENCE = 300;
    private static final int DEFAULT_MINIMUM_NUMBER_OF_TAPS = 3;
    private final int tapDuration;
    private final int dispersionRadius;
    private final int timespanDifference;
    private final int minimumNumberOfTaps;

    private RageTapConfiguration(Builder builder) {
        this.tapDuration = builder.tapDuration;
        this.dispersionRadius = builder.dispersionRadius;
        this.timespanDifference = builder.timespanDifference;
        this.minimumNumberOfTaps = builder.minimumNumberOfTaps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public int getTapDuration() {
        return this.tapDuration;
    }

    public int getDispersionRadius() {
        return this.dispersionRadius;
    }

    public int getTimespanDifference() {
        return this.timespanDifference;
    }

    public int getMinimumNumberOfTaps() {
        return this.minimumNumberOfTaps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RageTapConfiguration that = (RageTapConfiguration)o;
        if (this.tapDuration != that.tapDuration) {
            return false;
        }
        if (this.dispersionRadius != that.dispersionRadius) {
            return false;
        }
        if (this.timespanDifference != that.timespanDifference) {
            return false;
        }
        return this.minimumNumberOfTaps == that.minimumNumberOfTaps;
    }

    public int hashCode() {
        int result = this.tapDuration;
        result = 31 * result + this.dispersionRadius;
        result = 31 * result + this.timespanDifference;
        result = 31 * result + this.minimumNumberOfTaps;
        return result;
    }

    public String toString() {
        return "RageTapConfiguration{tapDuration=" + this.tapDuration + ", dispersionRadius=" + this.dispersionRadius + ", timespanDifference=" + this.timespanDifference + ", minimumNumberOfTaps=" + this.minimumNumberOfTaps + '}';
    }

    public static class Builder {
        private int tapDuration;
        private int dispersionRadius;
        private int timespanDifference;
        private int minimumNumberOfTaps;

        public Builder() {
            this.tapDuration = 100;
            this.dispersionRadius = 100;
            this.timespanDifference = 300;
            this.minimumNumberOfTaps = 3;
        }

        public Builder(RageTapConfiguration oldRageTapConfiguration) {
            this.tapDuration = oldRageTapConfiguration.tapDuration;
            this.dispersionRadius = oldRageTapConfiguration.dispersionRadius;
            this.timespanDifference = oldRageTapConfiguration.timespanDifference;
            this.minimumNumberOfTaps = oldRageTapConfiguration.minimumNumberOfTaps;
        }

        public Builder withTapDuration(int tapDuration) {
            this.tapDuration = tapDuration;
            return this;
        }

        public Builder withDispersionRadius(int dispersionRadius) {
            this.dispersionRadius = dispersionRadius;
            return this;
        }

        public Builder withTimespanDifference(int timespanDifference) {
            this.timespanDifference = timespanDifference;
            return this;
        }

        public Builder withMinimumNumberOfTaps(int minimumNumberOfTaps) {
            this.minimumNumberOfTaps = minimumNumberOfTaps;
            return this;
        }

        public RageTapConfiguration build() {
            return new RageTapConfiguration(this);
        }
    }
}

